/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightUpPumpkin
extends Behavior<Villager> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 100;
    protected int lastBreakProgress = -1;

    public LightUpPumpkin(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_ABSENT, ModRegistry.PUMPKIN_POS.get(), (Object)MemoryStatus.VALUE_PRESENT), 250, 360);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!HauntedHarvest.isTrickOrTreatTime((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        GlobalPos globalpos = (GlobalPos)pOwner.m_6274_().m_21952_(ModRegistry.PUMPKIN_POS.get()).get();
        return globalpos.m_122640_() == pLevel.m_46472_() && pOwner.m_6162_() && globalpos.m_122646_().m_203195_((Position)pOwner.m_20182_(), 28.0);
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (20 + pLevel.f_46441_.m_188503_(20)) + pLevel.f_46441_.m_188503_(20);
        this.ticksSinceReached = 0;
        this.lastBreakProgress = -1;
        GlobalPos globalpos = (GlobalPos)pEntity.m_6274_().m_21952_(ModRegistry.PUMPKIN_POS.get()).get();
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        pEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(globalpos.m_122646_(), this.speedModifier, 1));
        AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.f_42000_));
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pEntity.m_6274_().m_21874_(ModRegistry.PUMPKIN_POS.get());
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        BlockPos pos = ((GlobalPos)pOwner.m_6274_().m_21952_(ModRegistry.PUMPKIN_POS.get()).get()).m_122646_();
        pOwner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(pos, this.speedModifier, 2));
        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pos));
        if (pos.m_203195_((Position)pOwner.m_20182_(), 2.3)) {
            ++this.ticksSinceReached;
            BlockState state = pLevel.m_8055_(pos);
            if (!state.m_204336_(ModTags.CARVED_PUMPKINS)) {
                pOwner.m_6274_().m_21936_(ModRegistry.PUMPKIN_POS.get());
            } else if (this.ticksSinceReached > 40) {
                SoundType soundtype = Blocks.f_50081_.m_49966_().m_60827_();
                pLevel.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                pOwner.m_6274_().m_21936_(ModRegistry.PUMPKIN_POS.get());
                Block toPlace = state.m_60713_((Block)ModRegistry.CARVED_PUMPKIN.get()) ? (Block)ModRegistry.JACK_O_LANTERN.get() : Blocks.f_50144_;
                pLevel.m_46597_(pos, (BlockState)toPlace.m_49966_().m_61124_((Property)CarvedPumpkinBlock.f_51367_, (Comparable)((Direction)state.m_61143_((Property)CarvedPumpkinBlock.f_51367_))));
            }
        }
    }
}

