/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GiveCandyToPlayers
extends Behavior<Villager> {
    private boolean hasGivenCandy = false;
    private int tickSinceStarted = 0;
    private int timeToGiveCandy = 0;

    public GiveCandyToPlayers() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26368_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!HauntedHarvest.isHalloweenSeason((Level)pLevel)) {
            return false;
        }
        return this.getValidTarget((LivingEntity)pOwner) != null;
    }

    public static boolean isValidTrickOrTreater(LivingEntity self, LivingEntity villagerTarget) {
        if (self.m_20280_((Entity)villagerTarget) <= 12.0 && !HauntedHarvest.isPlayerOnCooldown(self)) {
            Entity lookTarget = villagerTarget.m_6274_().m_21952_(MemoryModuleType.f_26374_).orElse(null);
            return lookTarget == self;
        }
        return false;
    }

    @Nullable
    private LivingEntity getValidTarget(LivingEntity self) {
        List list = self.m_6274_().m_21952_(MemoryModuleType.f_26366_).orElse(List.of());
        return list.stream().filter(t -> GiveCandyToPlayers.isValidTrickOrTreater(self, t)).findFirst().orElse(null);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (this.tickSinceStarted < 300 && !this.hasGivenCandy) {
            Optional p = pEntity.m_6274_().m_21952_(MemoryModuleType.f_26374_);
            return p.isPresent() && GiveCandyToPlayers.isValidTrickOrTreater((LivingEntity)pEntity, (LivingEntity)p.get());
        }
        return false;
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        LivingEntity target = this.lookAtTarget(pOwner);
        if (target != null && this.tickSinceStarted > this.timeToGiveCandy) {
            int r = pLevel.m_213780_().m_188503_(12);
            if (r == 0) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42414_);
                GiveCandyToPlayers.throwCandy((LivingEntity)pOwner, target, stack);
                pLevel.m_7605_((Entity)pOwner, (byte)13);
            } else if (r < 3) {
                GiveCandyToPlayers.spookVillager(pOwner, target);
            } else {
                pLevel.m_7605_((Entity)pOwner, (byte)14);
            }
            this.hasGivenCandy = true;
            if (target instanceof IHalloweenVillager) {
                IHalloweenVillager e = (IHalloweenVillager)target;
                e.hauntedharvest$setEntityOnCooldown((Entity)pOwner);
            }
        }
        ++this.tickSinceStarted;
    }

    public static void spookVillager(Villager target, LivingEntity cause) {
        Level level = target.m_9236_();
        ((ServerLevel)level).m_8767_((ParticleOptions)ModRegistry.SPOOKED_PARTICLE.get(), target.m_20185_(), target.m_20186_() + 1.25, target.m_20189_(), 5, (double)(target.m_20205_() / 2.0f), (double)(target.m_20206_() / 3.0f), (double)(target.m_20205_() / 2.0f), 0.02);
        DamageSource dmg = level.m_269111_().m_269264_();
        target.m_6703_(cause);
        target.m_6469_(dmg, 0.1f);
        target.m_5634_(0.1f);
        target.m_6274_().m_21889_(Activity.f_37984_);
        target.m_6274_().m_21879_(MemoryModuleType.f_26381_, (Object)dmg);
        target.m_6274_().m_21879_(MemoryModuleType.f_26382_, (Object)cause);
    }

    public static void throwCandy(LivingEntity self, LivingEntity pTarget, ItemStack stack) {
        Vec3 vec3 = pTarget.m_20184_();
        double pX = pTarget.m_20185_() + vec3.f_82479_ - self.m_20185_();
        double d1 = pTarget.m_20188_() - (double)1.1f - self.m_20186_();
        double pZ = pTarget.m_20189_() + vec3.f_82481_ - self.m_20189_();
        double d3 = Math.sqrt(pX * pX + pZ * pZ);
        double d0 = self.m_20188_() - (double)0.3f;
        Level level = self.m_9236_();
        ItemEntity itementity = new ItemEntity(level, self.m_20185_(), d0, self.m_20189_(), stack);
        float pVelocity = 0.2f;
        double pY = d1 + d3 * 0.7;
        itementity.m_20256_(new Vec3(pX, pY, pZ).m_82541_().m_82490_((double)pVelocity));
        level.m_7967_((Entity)itementity);
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6735_(pLevel, (LivingEntity)pEntity, pGameTime);
        pEntity.m_5796_();
        LivingEntity target = this.lookAtTarget(pEntity);
        this.timeToGiveCandy = 20 + pLevel.f_46441_.m_188503_(30);
        this.tickSinceStarted = 0;
        this.hasGivenCandy = false;
    }

    @Nullable
    private LivingEntity lookAtTarget(Villager self) {
        LivingEntity entity = this.getValidTarget((LivingEntity)self);
        if (entity != null) {
            Brain brain = self.m_6274_();
            brain.m_21879_(MemoryModuleType.f_26374_, (Object)entity);
            brain.m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)entity, true));
            brain.m_21936_(MemoryModuleType.f_26370_);
        }
        return entity;
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        Brain brain = pEntity.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26371_);
        brain.m_21936_(MemoryModuleType.f_26374_);
        this.hasGivenCandy = false;
        this.tickSinceStarted = 0;
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
    }
}

