/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.CustomCarvingsManager;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class CarvePumpkin
extends Behavior<Villager> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 200;

    public CarvePumpkin(float speed) {
        super((Map)ImmutableMap.of(ModRegistry.NEAREST_PUMPKIN.get(), (Object)MemoryStatus.VALUE_PRESENT), 150, 250);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!HauntedHarvest.isHalloweenSeason((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!pOwner.m_6162_()) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (30 + pLevel.f_46441_.m_188503_(30)) + pLevel.f_46441_.m_188503_(20);
        this.ticksSinceReached = 0;
        BlockPos targetPos = ((GlobalPos)pEntity.m_6274_().m_21952_(ModRegistry.NEAREST_PUMPKIN.get()).get()).m_122646_();
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        pEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(targetPos, this.speedModifier, 2));
        AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.f_42574_));
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pEntity.m_6274_().m_21874_(ModRegistry.NEAREST_PUMPKIN.get()) && CarvePumpkin.isValidPumpkin(pLevel, pEntity);
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        BlockPos targetPos = ((GlobalPos)pOwner.m_6274_().m_21952_(ModRegistry.NEAREST_PUMPKIN.get()).get()).m_122646_();
        pOwner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(targetPos, this.speedModifier, 1));
        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(targetPos));
        if (targetPos.m_203195_((Position)pOwner.m_20182_(), 2.3)) {
            ++this.ticksSinceReached;
            if (this.ticksSinceReached > 40) {
                pLevel.m_5594_(null, targetPos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
                CustomCarvingsManager.placeRandomPumpkin(targetPos, (LevelAccessor)pLevel, pOwner.m_6350_().m_122424_(), true, 0.1f, 0.0f, 3);
                pOwner.m_6274_().m_21936_(ModRegistry.NEAREST_PUMPKIN.get());
                pOwner.m_6274_().m_21879_(ModRegistry.PUMPKIN_POS.get(), (Object)GlobalPos.m_122643_((ResourceKey)pLevel.m_46472_(), (BlockPos)targetPos));
            }
        }
    }

    public static boolean isValidPumpkin(ServerLevel serverLevel, Villager villager) {
        return serverLevel.m_8055_(((GlobalPos)villager.m_6274_().m_21952_(ModRegistry.NEAREST_PUMPKIN.get()).get()).m_122646_()).m_60713_(Blocks.f_50133_);
    }
}

