/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.TreeStarBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AncientTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public AncientTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int height;
        BlockPos treeBottom;
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (!this.checkCanTreePlace(level, treeBottom = context.m_159777_(), height = 3 + randomsource.m_188503_(4))) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            int i;
            if (direction.m_122434_() == Direction.Axis.Y) continue;
            int rootHeight = randomsource.m_188503_(2);
            for (int i2 = 0; i2 < rootHeight; ++i2) {
                level.m_7731_(treeBottom.m_6630_(i2).m_121945_(direction), Blocks.f_50002_.m_49966_(), 3);
            }
            BlockPos canopyPos = treeBottom.m_6630_(height);
            int branchOut = 1 + randomsource.m_188503_(2);
            int branchUp = randomsource.m_188503_(1) + 1;
            for (i = 1; i <= branchOut; ++i) {
                level.m_7731_(canopyPos.m_5484_(direction, i), (BlockState)Blocks.f_50002_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 3);
            }
            for (i = 1; i <= branchUp + 1; ++i) {
                level.m_7731_(canopyPos.m_5484_(direction, branchOut + 1).m_6630_(i), Blocks.f_50002_.m_49966_(), 3);
            }
            AncientTreeFeature.drawLeafOrb(level, canopyPos.m_5484_(direction, branchOut).m_6630_(branchUp + 2), randomsource, ((Block)ACBlockRegistry.ANCIENT_LEAVES.get()).m_49966_(), 2 + randomsource.m_188503_(2), 4 + randomsource.m_188503_(2), 2 + randomsource.m_188503_(2));
        }
        for (int i = 0; i <= height; ++i) {
            BlockPos trunkPos = treeBottom.m_6630_(i);
            level.m_7731_(trunkPos, Blocks.f_50002_.m_49966_(), 3);
        }
        return true;
    }

    private boolean checkCanTreePlace(WorldGenLevel level, BlockPos treeBottom, int height) {
        BlockState below = level.m_8055_(treeBottom.m_7495_());
        if (!below.m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            if (AncientTreeFeature.canReplace(level.m_8055_(treeBottom.m_6630_(i)))) continue;
            return false;
        }
        BlockPos treeTop = treeBottom.m_6630_(height);
        for (BlockPos checkLeaf : BlockPos.m_121940_((BlockPos)treeTop.m_7918_(-3, -1, -3), (BlockPos)treeTop.m_7918_(3, 3, 3))) {
            if (AncientTreeFeature.canReplace(level.m_8055_(checkLeaf))) continue;
            return false;
        }
        return true;
    }

    private static void drawLeafOrb(WorldGenLevel level, BlockPos center, RandomSource random, BlockState blockState, int radiusX, int radiusY, int radiusZ) {
        double equalRadius = (double)(radiusX + radiusY + radiusZ) / 3.0;
        for (int x = -radiusX; x <= radiusX; ++x) {
            for (int y = -radiusY / 3; y <= radiusY; ++y) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    Direction dir;
                    BlockPos starPos;
                    BlockPos fill = center.m_7918_(x, y, z);
                    if (!(fill.m_203202_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_()) <= equalRadius * equalRadius - (double)(random.m_188501_() * 7.0f)) || !AncientTreeFeature.canReplace(level.m_8055_(fill))) continue;
                    level.m_7731_(fill, blockState, 3);
                    if (random.m_188503_(5) != 0 || !level.m_8055_(starPos = fill.m_121945_(dir = Direction.m_235672_((RandomSource)random))).m_60795_()) continue;
                    level.m_7731_(starPos, (BlockState)((Block)ACBlockRegistry.TREE_STAR.get()).m_49966_().m_61124_((Property)TreeStarBlock.FACING, (Comparable)dir), 3);
                }
            }
        }
    }

    private static boolean canReplace(BlockState state) {
        return (state.m_60795_() || state.m_247087_() || state.m_60713_((Block)ACBlockRegistry.ANCIENT_LEAVES.get()) || state.m_60713_((Block)ACBlockRegistry.TREE_STAR.get())) && !state.m_204336_(ACTagRegistry.UNMOVEABLE) && state.m_60819_().m_76178_();
    }
}

