/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.model.TremorzillaBeamModel;
import com.github.alexmodguy.alexscaves.client.model.TremorzillaModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.client.render.entity.layer.TremorzillaRiderLayer;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class TremorzillaRenderer
extends MobRenderer<TremorzillaEntity, TremorzillaModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla.png");
    private static final ResourceLocation TEXTURE_RETRO = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro.png");
    private static final ResourceLocation TEXTURE_TECTONIC = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_glow.png");
    private static final ResourceLocation TEXTURE_RETRO_GLOW = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_glow.png");
    private static final ResourceLocation TEXTURE_TECTONIC_GLOW = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_glow.png");
    private static final ResourceLocation TEXTURE_GLOW_POWERED = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_glow_powered.png");
    private static final ResourceLocation TEXTURE_RETRO_GLOW_POWERED = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_glow_powered.png");
    private static final ResourceLocation TEXTURE_TECTONIC_GLOW_POWERED = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_glow_powered.png");
    private static final ResourceLocation TEXTURE_BEAM_INNER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_inner.png");
    private static final ResourceLocation TEXTURE_RETRO_BEAM_INNER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_beam_inner.png");
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_INNER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_inner.png");
    private static final ResourceLocation TEXTURE_BEAM_OUTER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_outer.png");
    private static final ResourceLocation TEXTURE_RETRO_BEAM_OUTER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_beam_outer.png");
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_OUTER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_outer.png");
    private static final ResourceLocation TEXTURE_BEAM_END_0 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_end_0.png");
    private static final ResourceLocation TEXTURE_RETRO_BEAM_END_0 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_beam_end_0.png");
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_END_0 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_end_0.png");
    private static final ResourceLocation TEXTURE_BEAM_END_1 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_end_1.png");
    private static final ResourceLocation TEXTURE_RETRO_BEAM_END_1 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_beam_end_1.png");
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_END_1 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_end_1.png");
    private static final ResourceLocation TEXTURE_BEAM_END_2 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_end_2.png");
    private static final ResourceLocation TEXTURE_RETRO_BEAM_END_2 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_beam_end_2.png");
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_END_2 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_end_2.png");
    private static final HashMap<Integer, Vec3> mouthParticlePositions = new HashMap();
    private static final Vec3 MOUTH_TRANSFORM_POS = new Vec3(0.0, 1.0, -1.0);
    private static final TremorzillaBeamModel BEAM_END_MODEL = new TremorzillaBeamModel();
    private boolean sepia;

    public TremorzillaRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new TremorzillaModel(), 4.0f);
        this.m_115326_(new LayerGlow());
        this.m_115326_(new TremorzillaRiderLayer(this));
    }

    protected void scale(TremorzillaEntity mob, PoseStack matrixStackIn, float partialTicks) {
    }

    public ResourceLocation getTextureLocation(TremorzillaEntity entity) {
        return entity.getAltSkin() == 2 ? TEXTURE_TECTONIC : (entity.getAltSkin() == 1 ? TEXTURE_RETRO : TEXTURE);
    }

    public void render(TremorzillaEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight) {
        ((TremorzillaModel)this.f_115290_).straighten = this.sepia;
        this.f_114477_ = 4.0f * entity.m_6134_();
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, source, packedLight);
        float bodyYaw = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        float beamProgress = entity.getBeamProgress(partialTicks);
        Vec3 beamEndVec = entity.getClientBeamEndPosition(partialTicks);
        if (beamProgress > 0.0f && entity.m_6084_() && beamEndVec != null) {
            Vec3 modelOffset = ((TremorzillaModel)this.m_7200_()).getMouthPosition(new Vec3(0.0, (double)0.1f, 0.0)).m_82524_((float)(Math.PI - (double)(bodyYaw * ((float)Math.PI / 180))));
            float ageInTicks = (float)entity.f_19797_ + partialTicks;
            float shakeByX = (float)Math.sin(ageInTicks * 4.0f) * 0.075f;
            float shakeByY = (float)Math.sin(ageInTicks * 4.0f + 1.2f) * 0.075f;
            float shakeByZ = (float)Math.sin(ageInTicks * 4.0f + 2.4f) * 0.075f;
            Vec3 rawBeamPosition = beamEndVec.m_82546_(entity.m_20318_(partialTicks).m_82549_(modelOffset));
            float length = (float)rawBeamPosition.m_82553_();
            Vec3 vec3 = rawBeamPosition.m_82541_();
            float xRot = (float)Math.acos(vec3.f_82480_);
            float yRot = (float)Math.atan2(vec3.f_82481_, vec3.f_82479_);
            float width = beamProgress * 1.5f;
            poseStack.m_85836_();
            poseStack.m_85837_(modelOffset.f_82479_ + (double)shakeByX, modelOffset.f_82480_ + (double)shakeByY, modelOffset.f_82481_ + (double)shakeByZ);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - yRot) * 57.295776f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((-1.5707964f + xRot) * 57.295776f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            this.renderBeam(entity, poseStack, source, partialTicks, width, length, true, false);
            if (((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue()) {
                this.renderBeam(entity, poseStack, source, partialTicks, width, length, true, true);
            }
            this.renderBeam(entity, poseStack, source, partialTicks, width, length, false, false);
            poseStack.m_85849_();
        }
        mouthParticlePositions.put(entity.m_19879_(), ((TremorzillaModel)this.f_115290_).getMouthPosition(MOUTH_TRANSFORM_POS));
    }

    public static Vec3 getMouthPositionFor(int entityId) {
        return mouthParticlePositions.get(entityId);
    }

    @Nullable
    protected RenderType getRenderType(TremorzillaEntity mob, boolean normal, boolean translucent, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(mob);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return this.sepia ? ACRenderTypes.getBookWidget(resourcelocation, true) : RenderType.m_110473_((ResourceLocation)resourcelocation);
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    private void renderBeam(TremorzillaEntity entity, PoseStack poseStack, MultiBufferSource source, float partialTicks, float width, float length, boolean inner, boolean glowSecondPass) {
        float speed;
        VertexConsumer vertexconsumer;
        int vertices;
        poseStack.m_85836_();
        float startAlpha = 1.0f;
        float endAlpha = 1.0f;
        if (inner) {
            vertices = 4;
            ResourceLocation resourceLocation = entity.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_INNER : (resourceLocation = entity.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_INNER : TEXTURE_BEAM_INNER);
            if (((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue() && glowSecondPass) {
                PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.IRRADIATED_SHADER);
                vertexconsumer = source.m_6299_(ACRenderTypes.getTremorzillaBeam(resourceLocation, true));
                endAlpha = 0.5f;
            } else {
                vertexconsumer = source.m_6299_(ACRenderTypes.getTremorzillaBeam(resourceLocation, false));
            }
            speed = 0.5f;
        } else {
            vertices = 8;
            ResourceLocation resourceLocation = entity.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_OUTER : (resourceLocation = entity.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_OUTER : TEXTURE_BEAM_OUTER);
            if (((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue()) {
                PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.IRRADIATED_SHADER);
                vertexconsumer = source.m_6299_(ACRenderTypes.getTremorzillaBeam(resourceLocation, true));
            } else {
                vertexconsumer = source.m_6299_(ACRenderTypes.getTremorzillaBeam(resourceLocation, false));
            }
            width += 0.25f;
            speed = 1.0f;
            endAlpha = 0.0f;
        }
        float v = ((float)entity.f_19797_ + partialTicks) * -0.25f * speed;
        float v1 = v + length * (inner ? 0.5f : 0.15f);
        float f4 = -width;
        float f5 = 0.0f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        for (int j = 0; j <= vertices; ++j) {
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f7 = Mth.m_14089_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f8 = Mth.m_14031_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f9 = (float)j + 1.0f;
            vertexconsumer.m_252986_(matrix4f, f4 * 0.55f, f5 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f6, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f4, f5, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f6, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7, f8, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f9, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * 0.55f, f8 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f9, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        if (inner) {
            VertexConsumer endVertexConsumer;
            if (((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue() && glowSecondPass) {
                PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.IRRADIATED_SHADER);
                endVertexConsumer = source.m_6299_(ACRenderTypes.getTremorzillaBeam(this.getEndBeamTexture(entity), true));
            } else {
                endVertexConsumer = source.m_6299_(ACRenderTypes.getTremorzillaBeam(this.getEndBeamTexture(entity), false));
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, length - 1.5f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(width, width, width);
            BEAM_END_MODEL.resetToDefaultPose();
            BEAM_END_MODEL.m_7695_(poseStack, endVertexConsumer, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private ResourceLocation getEndBeamTexture(TremorzillaEntity entity) {
        int time = entity.f_19797_ / 2 % 3;
        switch (time) {
            case 0: {
                return entity.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_END_0 : (entity.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_END_0 : TEXTURE_BEAM_END_0);
            }
            case 1: {
                return entity.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_END_1 : (entity.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_END_1 : TEXTURE_BEAM_END_1);
            }
            case 2: {
                return entity.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_END_2 : (entity.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_END_2 : TEXTURE_BEAM_END_2);
            }
        }
        return entity.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_END_0 : (entity.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_END_0 : TEXTURE_BEAM_END_0);
    }

    public boolean shouldRender(TremorzillaEntity entity, Frustum camera, double x, double y, double z) {
        Vec3 endBeam;
        if (super.m_5523_((Mob)entity, camera, x, y, z)) {
            return true;
        }
        for (PartEntity<?> part : entity.getParts()) {
            if (!camera.m_113029_(part.m_6921_())) continue;
            return true;
        }
        if (entity.isFiring() && (endBeam = entity.getClientBeamEndPosition(1.0f)) != null) {
            Vec3 vec3 = entity.getBeamShootFrom(1.0f);
            return camera.m_113029_(new AABB(endBeam.f_82479_, endBeam.f_82480_, endBeam.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    class LayerGlow
    extends RenderLayer<TremorzillaEntity, TremorzillaModel> {
        public LayerGlow() {
            super((RenderLayerParent)TremorzillaRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, TremorzillaEntity tremorzilla, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float normalAlpha = (float)Math.sin(ageInTicks * 0.2f) * 0.15f + 0.5f;
            float spikeDownAmount = tremorzilla.getClientSpikeDownAmount(partialTicks);
            VertexConsumer normalGlowConsumer = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(tremorzilla.isPowered() ? (tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_GLOW_POWERED : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_GLOW_POWERED : TEXTURE_GLOW_POWERED)) : (tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_GLOW : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_GLOW : TEXTURE_GLOW))));
            ((TremorzillaModel)this.m_117386_()).m_7695_(matrixStackIn, normalGlowConsumer, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)tremorzilla, (float)0.0f), 1.0f, 1.0f, 1.0f, normalAlpha);
            if (spikeDownAmount > 0.0f) {
                VertexConsumer spikeGlowConsumer;
                if (((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue()) {
                    PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.IRRADIATED_SHADER);
                    spikeGlowConsumer = bufferIn.m_6299_(ACRenderTypes.getTremorzillaBeam(tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_GLOW_POWERED : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_GLOW_POWERED : TEXTURE_GLOW_POWERED), true));
                } else {
                    spikeGlowConsumer = normalGlowConsumer;
                }
                ((TremorzillaModel)this.m_117386_()).showSpikesBasedOnProgress(spikeDownAmount, 0.0f);
                ((TremorzillaModel)this.m_117386_()).m_7695_(matrixStackIn, spikeGlowConsumer, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)tremorzilla, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                ((TremorzillaModel)this.m_117386_()).showAllSpikes();
            }
        }
    }
}

