/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.util.UnderzealotSacrifice;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class VoidBeingCloudParticle
extends Particle {
    private final int textureSize;
    private static int currentlyUsedTextures = 0;
    private final DynamicTexture dynamicTexture;
    private final RenderType renderType;
    private boolean requiresUpload = true;
    private float size;
    private int id = 0;
    private int targetId;
    private int totalTendrils;
    private int idleSoundTime = 30;
    private boolean spawnedExtras = false;

    public VoidBeingCloudParticle(ClientLevel world, double x, double y, double z, int size, int target, int totalTendrils) {
        super(world, x, y, z);
        this.f_107226_ = 0.0f;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107225_ = 300;
        this.size = size + 1;
        this.m_107250_(this.size, this.size);
        this.textureSize = 32 + size * 32;
        this.dynamicTexture = new DynamicTexture(this.textureSize, this.textureSize, true);
        this.id = currentlyUsedTextures++;
        ResourceLocation resourcelocation = Minecraft.m_91087_().f_90987_.m_118490_("alexscavesvoid_particle/void_cloud_" + this.id, this.dynamicTexture);
        this.renderType = ACRenderTypes.getVoidBeingCloud(resourcelocation);
        this.targetId = target;
        this.totalTendrils = totalTendrils;
    }

    public void m_5989_() {
        if (this.f_107224_ <= 0 && !this.spawnedExtras) {
            this.onSpawn();
            this.spawnedExtras = true;
        }
        super.m_5989_();
        this.f_107215_ *= 0.97;
        this.f_107216_ *= 0.97;
        this.f_107217_ *= 0.97;
        this.updateTexture();
        if (this.idleSoundTime-- <= 0) {
            this.idleSoundTime = 80 + this.f_107223_.m_188503_(60);
            this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, (SoundEvent)ACSoundRegistry.DARK_CLOUD_IDLE.get(), SoundSource.BLOCKS, 2.0f, 1.0f, false);
        }
        this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.f_107212_, this.f_107213_, this.f_107214_, (double)(this.f_107223_.m_188501_() - 0.5f), (double)(this.f_107223_.m_188501_() - 0.5f), (double)(this.f_107223_.m_188501_() - 0.5f));
        Entity entity = this.f_107208_.m_6815_(this.targetId);
        if (entity == null || !(entity instanceof UnderzealotSacrifice)) {
            this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, (SoundEvent)ACSoundRegistry.DARK_CLOUD_DISAPPEAR.get(), SoundSource.BLOCKS, 2.0f, 1.0f, false);
            this.m_107274_();
        }
        if (this.f_107224_ == this.f_107225_ - 10) {
            this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, (SoundEvent)ACSoundRegistry.DARK_CLOUD_DISAPPEAR.get(), SoundSource.BLOCKS, 2.0f, 1.0f, false);
        }
    }

    private void onSpawn() {
        int j;
        int circleOffset = this.f_107223_.m_188503_(360);
        int eyes = 3 + this.f_107223_.m_188503_(2);
        this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, (SoundEvent)ACSoundRegistry.DARK_CLOUD_APPEAR.get(), SoundSource.BLOCKS, 2.0f, 1.0f, false);
        for (j = 0; j < eyes; ++j) {
            Vec3 vec3 = new Vec3((double)((0.5f + this.f_107223_.m_188501_() * 0.7f) * this.size * 1.1f), 0.0, 0.0).m_82524_((float)((double)circleOffset + (double)((float)j / (float)eyes * 180.0f) * (Math.PI / 180)));
            this.f_107208_.m_7106_((ParticleOptions)ACParticleRegistry.VOID_BEING_EYE.get(), this.f_107212_, this.f_107213_, this.f_107214_, vec3.f_82479_, vec3.f_82481_, 0.0);
        }
        for (j = 0; j < this.totalTendrils; ++j) {
            int timeBy = 200 / this.totalTendrils * (j + 1);
            this.f_107208_.m_7106_((ParticleOptions)ACParticleRegistry.VOID_BEING_TENDRIL.get(), this.f_107212_, this.f_107213_, this.f_107214_, (double)this.targetId, (double)timeBy, 0.0);
        }
    }

    private void updateTexture() {
        int center = this.textureSize / 2;
        int black = 0;
        double alphaFadeOut = this.f_107224_ > this.f_107225_ - 10 ? (double)((float)(this.f_107225_ - this.f_107224_) / 10.0f) : 1.0;
        double radiusSq = (float)(center * center) * VoidBeingCloudParticle.getAlphaFromAge(this.f_107224_, this.f_107225_);
        for (int i = 0; i < this.textureSize; ++i) {
            for (int j = 0; j < this.textureSize; ++j) {
                double d0 = center - i;
                double d1 = center - j;
                double d2 = d0 * d0 + d1 * d1;
                double f1 = (ACMath.sampleNoise3D(i, this.f_107224_, j, 15.0f) + 1.0f) / 2.0f;
                double alpha = (1.0 - d2 / (radiusSq - f1 * f1 * radiusSq)) * alphaFadeOut;
                if (alpha < 0.0) {
                    this.dynamicTexture.m_117991_().m_84988_(j, i, 0);
                    continue;
                }
                this.dynamicTexture.m_117991_().m_84988_(j, i, FastColor.ARGB32.m_13660_((int)((int)Math.min(alpha * 255.0, 255.0)), (int)black, (int)black, (int)black));
            }
        }
        this.dynamicTexture.m_117985_();
    }

    public static float getAlphaFromAge(int age, int lifetime) {
        float alphaFadeIn = (float)Math.min(20, age) / 20.0f;
        float alphaFadeOut = age > lifetime - 10 ? (float)(lifetime - age) / 10.0f : 1.0f;
        return alphaFadeIn * alphaFadeOut;
    }

    public void m_107274_() {
        this.f_107220_ = true;
        --currentlyUsedTextures;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Quaternionf quaternion;
        if (this.requiresUpload) {
            this.updateTexture();
            this.requiresUpload = false;
        }
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
            float f3 = Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
        }
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexConsumer1 = multibuffersource$buffersource.m_6299_(this.renderType);
        PoseStack posestack = new PoseStack();
        PoseStack.Pose posestack$pose = posestack.m_85850_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        float zFightFix = 0.0f;
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, zFightFix), new Vector3f(-1.0f, 1.0f, zFightFix), new Vector3f(1.0f, 1.0f, zFightFix), new Vector3f(1.0f, -1.0f, zFightFix)};
        float f4 = this.size;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i].add(0.0f, 0.2f * (float)Math.sin(((float)this.f_107224_ + partialTick) * 0.1f), 0.0f);
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        int j = 240;
        vertexConsumer1.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(f8, f6).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer1.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(f8, f5).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer1.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(f7, f5).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer1.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(f7, f6).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        multibuffersource$buffersource.m_109911_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VoidBeingCloudParticle(worldIn, x, y, z, (int)xSpeed, (int)ySpeed, (int)zSpeed);
        }
    }
}

