/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.NotorEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class NotorModel
extends AdvancedEntityModel<NotorEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox propeller;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox blades;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox lleg;

    public NotorModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 20.0f, 0.0f);
        this.body.setTextureOffset(0, 4).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f, false);
        this.propeller = new AdvancedModelBox((AdvancedEntityModel)this);
        this.propeller.setRotationPoint(0.0f, -2.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.propeller);
        this.propeller.setTextureOffset(0, 0).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 3.0f, 0.0f, 0.0f, false);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(0.0f, -1.0f, 0.0f);
        this.propeller.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, 0.0f, -1.5708f, 0.0f);
        this.cube_r1.setTextureOffset(0, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 3.0f, 0.0f, 0.0f, false);
        this.blades = new AdvancedModelBox((AdvancedEntityModel)this);
        this.blades.setRotationPoint(0.0f, -1.0f, 0.0f);
        this.propeller.addChild((BasicModelPart)this.blades);
        this.blades.setTextureOffset(0, 0).addBox(-9.0f, 0.0f, -2.0f, 18.0f, 0.0f, 4.0f, 0.0f, false);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(-1.5f, 2.0f, 2.0f);
        this.body.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(4, 12).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, 0.0f, false);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(1.5f, 2.0f, 2.0f);
        this.body.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(4, 12).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(1.5f, 2.0f, -2.0f);
        this.body.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(4, 12).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, 0.0f, false);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(-1.5f, 2.0f, -2.0f);
        this.body.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(4, 12).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.propeller, (Object)this.cube_r1, (Object)this.blades, (Object)this.rarm, (Object)this.larm, (Object)this.rleg, (Object)this.lleg);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public void setupAnim(NotorEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float landProgress = entity.getGroundProgress(partialTick);
        float flyProgress = 1.0f - landProgress;
        float bodyYaw = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTick;
        float bodyIdleBob = Math.abs(ACMath.walkValue(ageInTicks, landProgress, 0.1f, 0.0f, 1.0f, false));
        float bodyFlyBob = ACMath.walkValue(ageInTicks, flyProgress, 0.2f, 1.0f, 1.2f, false) - 1.2f * flyProgress;
        this.body.rotationPointY += bodyIdleBob + bodyFlyBob;
        this.larm.rotationPointY -= bodyIdleBob * 0.8f;
        this.rarm.rotationPointY -= bodyIdleBob * 0.8f;
        this.lleg.rotationPointY -= bodyIdleBob * 0.8f;
        this.rleg.rotationPointY -= bodyIdleBob * 0.8f;
        this.flap(this.propeller, 0.2f, 0.1f, false, 1.0f, 0.0f, ageInTicks, landProgress);
        this.walk(this.larm, 0.2f, 0.3f, false, 0.0f, 0.2f, ageInTicks, landProgress);
        this.walk(this.rarm, 0.2f, 0.3f, false, 0.0f, 0.2f, ageInTicks, landProgress);
        this.walk(this.lleg, 0.2f, 0.3f, true, 0.0f, 0.2f, ageInTicks, landProgress);
        this.walk(this.rleg, 0.2f, 0.3f, true, 0.0f, 0.2f, ageInTicks, landProgress);
        this.walk(this.larm, 0.2f, 0.3f, false, 1.0f, 0.2f, ageInTicks, flyProgress);
        this.walk(this.rarm, 0.2f, 0.3f, false, 1.0f, 0.2f, ageInTicks, flyProgress);
        this.walk(this.lleg, 0.2f, 0.3f, false, 2.0f, 0.2f, ageInTicks, flyProgress);
        this.walk(this.rleg, 0.2f, 0.3f, false, 2.0f, 0.2f, ageInTicks, flyProgress);
        this.propeller.rotateAngleY += (float)Math.toRadians(entity.getPropellerAngle(partialTick) - bodyYaw * flyProgress);
        float flyForwards = limbSwingAmount * flyProgress;
        this.walk(this.body, 0.2f, 0.1f, false, 2.0f, 0.2f, limbSwing, flyForwards);
        this.flap(this.body, 0.4f, 0.05f, false, -1.0f, 0.0f, ageInTicks, flyProgress);
        this.walk(this.propeller, 0.2f, 0.1f, true, 2.0f, 0.2f, limbSwing, flyForwards);
    }

    public Vec3 getChainPosition(Vec3 offsetIn) {
        PoseStack armStack = new PoseStack();
        armStack.m_85836_();
        this.body.translateAndRotate(armStack);
        Vector4f armOffsetVec = new Vector4f((float)offsetIn.f_82479_, (float)offsetIn.f_82480_, (float)offsetIn.f_82481_, 1.0f);
        armOffsetVec.mul((Matrix4fc)armStack.m_85850_().m_252922_());
        Vec3 vec3 = new Vec3((double)armOffsetVec.x(), (double)(-armOffsetVec.y()), (double)armOffsetVec.z());
        armStack.m_85849_();
        return vec3.m_82520_(0.0, 1.5, 0.0);
    }
}

