/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui.book.widget;

import com.github.alexmodguy.alexscaves.client.gui.book.widget.BookWidget;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityWidget
extends BookWidget {
    @Expose
    @SerializedName(value="entity_id")
    private String entityId;
    @Expose
    private String nbt;
    @Expose
    private boolean sepia;
    @Expose
    @SerializedName(value="rot_x")
    private float rotX;
    @Expose
    @SerializedName(value="rot_y")
    private float rotY;
    @Expose
    @SerializedName(value="rot_z")
    private float rotZ;
    @Expose(serialize=false, deserialize=false)
    private Entity actualRenderEntity = null;

    public EntityWidget(int displayPage, String entityId, boolean sepia, String entityNBT, int x, int y, float scale) {
        this(displayPage, BookWidget.Type.ENTITY, entityId, sepia, entityNBT, x, y, scale);
    }

    public EntityWidget(int displayPage, BookWidget.Type type, String entityId, boolean sepia, String entityNBT, int x, int y, float scale) {
        super(displayPage, type, x, y, scale);
        this.entityId = entityId;
        this.sepia = sepia;
        this.nbt = entityNBT;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, boolean onFlippingPage) {
        Entity entity;
        EntityType type;
        if (this.actualRenderEntity == null && (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(this.entityId))) != null && (entity = (this.actualRenderEntity = type.m_20615_((Level)Minecraft.m_91087_().f_91073_))) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.nbt != null && !this.nbt.isEmpty()) {
                try {
                    living.m_7378_(TagParser.m_129359_((String)this.nbt));
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        float entityScale = 100.0f * this.getScale();
        float entityBBSize = Math.max(this.actualRenderEntity.m_20205_(), this.actualRenderEntity.m_20206_());
        if ((double)entityBBSize > 1.0) {
            entityScale /= entityBBSize * 1.5f;
        }
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.getX(), (float)this.getY(), 120.0f);
        poseStack.m_85841_(entityScale, entityScale, entityScale);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.rotX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotY));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(this.rotZ));
        Lighting.m_166384_();
        this.renderEntityInSepia(this.actualRenderEntity, 0.0f, partialTicks, poseStack, (MultiBufferSource)bufferSource, 240);
        Lighting.m_84931_();
        poseStack.m_85849_();
    }

    protected boolean isSepia() {
        return this.sepia;
    }

    private void renderEntityInSepia(Entity entityIn, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        EntityRenderer render = null;
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        try {
            render = manager.m_114382_(entityIn);
            if (entityIn instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entityIn;
                if (render instanceof CustomBookEntityRenderer) {
                    CustomBookEntityRenderer customBookEntityRenderer = (CustomBookEntityRenderer)render;
                    if (this.sepia) {
                        customBookEntityRenderer.setSepiaFlag(true);
                    }
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    RenderSystem.runAsFancy(() -> manager.m_114384_(entityIn, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, bufferIn, packedLight));
                    if (this.sepia) {
                        customBookEntityRenderer.setSepiaFlag(false);
                    }
                } else if (render instanceof LivingEntityRenderer) {
                    LivingEntityRenderer renderer = (LivingEntityRenderer)render;
                    EntityModel model = renderer.m_7200_();
                    VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getBookWidget(render.m_5478_(entityIn), this.sepia));
                    matrixStack.m_85836_();
                    boolean shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
                    model.f_102610_ = living.m_6162_();
                    model.f_102609_ = shouldSit;
                    model.m_6973_((Entity)living, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                    matrixStack.m_85841_(living.m_6134_(), living.m_6134_(), living.m_6134_());
                    model.m_7695_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    matrixStack.m_85849_();
                }
            }
            Minecraft.m_91087_().m_91385_().m_83947_(true);
        }
        catch (Throwable throwable3) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
            entityIn.m_7976_(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
            crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
            crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
            crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
            throw new ReportedException(crashreport);
        }
    }
}

