/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.data.server.modifiers;

import com.teamabnormals.incubation.core.other.tags.IncubationBiomeTags;
import com.teamabnormals.incubation.core.registry.IncubationFeatures;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class IncubationBiomeModifierProvider {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        IncubationBiomeModifierProvider.addFeature(context, "chicken_nest", IncubationBiomeTags.HAS_CHICKEN_NEST, GenerationStep.Decoration.VEGETAL_DECORATION, IncubationFeatures.IncubationPlacedFeatures.NEST_CHICKEN);
        IncubationBiomeModifierProvider.addFeature(context, "duck_nest", IncubationBiomeTags.HAS_DUCK_NEST, GenerationStep.Decoration.VEGETAL_DECORATION, IncubationFeatures.IncubationPlacedFeatures.NEST_DUCK);
        IncubationBiomeModifierProvider.addFeature(context, "turkey_nest", IncubationBiomeTags.HAS_TURKEY_NEST, GenerationStep.Decoration.VEGETAL_DECORATION, IncubationFeatures.IncubationPlacedFeatures.NEST_TURKEY);
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        IncubationBiomeModifierProvider.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), IncubationBiomeModifierProvider.featureSet(context, features), step));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(key -> context.m_255420_(Registries.f_256988_).m_255043_(key)).collect(Collectors.toList()));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("incubation", name)), (Object)modifier.get());
    }
}

