/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item;

import dev.murad.shipping.entity.custom.vessel.tug.VehicleFrontPart;
import dev.murad.shipping.util.LinkableEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpringItem
extends Item {
    private static final Logger log = LogManager.getLogger(SpringItem.class);
    private Component springInfo = Component.m_237115_((String)"item.littlelogistics.spring.description");

    public SpringItem(Item.Properties properties) {
        super(properties);
    }

    public void onUsedOnEntity(ItemStack stack, Player player, Level world, Entity target) {
        if (target instanceof VehicleFrontPart) {
            target = ((VehicleFrontPart)target).getParent();
        }
        if (world.f_46443_) {
            return;
        }
        switch (SpringItem.getState(stack)) {
            case WAITING_NEXT: {
                this.createSpringHelper(stack, player, world, target);
                break;
            }
            default: {
                this.setDominant(world, stack, target);
            }
        }
    }

    private void createSpringHelper(ItemStack stack, Player player, Level world, Entity target) {
        LinkableEntity d;
        Entity dominant = this.getDominant(world, stack);
        if (dominant == null) {
            return;
        }
        if (dominant == target) {
            player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.notToSelf"), true);
        } else if (dominant instanceof LinkableEntity && (d = (LinkableEntity)dominant).linkEntities(player, target) && !player.m_7500_()) {
            stack.m_41774_(1);
        }
        this.resetLinked(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.springInfo);
    }

    private void setDominant(Level worldIn, ItemStack stack, Entity entity) {
        stack.m_41784_().m_128405_("linked", entity.m_19879_());
    }

    @Nullable
    private Entity getDominant(Level worldIn, ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("linked")) {
            int id = stack.m_41783_().m_128451_("linked");
            return worldIn.m_6815_(id);
        }
        this.resetLinked(stack);
        return null;
    }

    private void resetLinked(ItemStack itemstack) {
        itemstack.m_41749_("linked");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        this.resetLinked(playerIn.m_21120_(handIn));
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public static State getState(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("linked")) {
            return State.WAITING_NEXT;
        }
        return State.READY;
    }

    public static enum State {
        WAITING_NEXT,
        READY;

    }
}

