/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.common.levelgen.configs.EndergeticPatchConfig;
import com.teamabnormals.endergetic.common.levelgen.configs.MultiPatchConfig;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class EumusPatchFeature
extends Feature<MultiPatchConfig> {
    private static final Set<Block> TRANSFORMABLE_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.f_50259_, (Block)EEBlocks.END_CORROCK_BLOCK.get(), (Block)EEBlocks.SPECKLED_END_CORROCK.get()});
    private static final BlockState EUMUS = ((Block)EEBlocks.EUMUS.get()).m_49966_();

    public EumusPatchFeature(Codec<MultiPatchConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<MultiPatchConfig> context) {
        BlockPos down;
        WorldGenLevel level = context.m_159774_();
        Block downBlock = level.m_8055_(down = EndergeticPatchConfig.getPos(level, context.m_159777_(), false).m_7495_()).m_60734_();
        if (downBlock == EEBlocks.END_CORROCK_BLOCK.get()) {
            RandomSource rand = context.m_225041_();
            MultiPatchConfig config = (MultiPatchConfig)context.m_159778_();
            int extraPatches = 1 + rand.m_188503_(config.getMaxExtraPatches() + 1);
            int maxExtraRadius = config.getMaxExtraRadius();
            EumusPatchFeature.generatePatch(level, down, rand, maxExtraRadius);
            for (int i = 0; i < extraPatches; ++i) {
                EumusPatchFeature.generatePatch(level, down.m_7918_(rand.m_188503_(2) - rand.m_188503_(2), 0, rand.m_188503_(2) - rand.m_188503_(2)), rand, maxExtraRadius);
            }
            return true;
        }
        return false;
    }

    private static void generatePatch(WorldGenLevel world, BlockPos origin, RandomSource rand, int maxExtraRadius) {
        int radius = 1 + rand.m_188503_(maxExtraRadius);
        int radiusSquared = radius * radius;
        int originX = origin.m_123341_();
        int originY = origin.m_123342_();
        int originZ = origin.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos pos;
                int distanceY;
                int distanceSq = x * x + z * z - rand.m_188503_(2);
                if (distanceSq > radiusSquared || (distanceY = Math.abs(originY - (pos = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, (BlockPos)mutable.m_122178_(originX + x, originY, originZ + z)).m_7495_()).m_123342_())) > 1 || !TRANSFORMABLE_BLOCKS.contains(world.m_8055_(pos).m_60734_())) continue;
                world.m_7731_(pos, EUMUS, 2);
            }
        }
    }
}

