/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid.ai;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.AbstractPurpoidTeleportGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidTeleportToFlowerGoal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class PurpTeleportToPlantGoal
extends AbstractPurpoidTeleportGoal {
    private Direction side = Direction.DOWN;

    public PurpTeleportToPlantGoal(Purpoid purpoid) {
        super(purpoid);
    }

    @Override
    public boolean m_8036_() {
        return !this.purpoid.hasRestCooldown() && super.m_8036_();
    }

    @Override
    protected void beginTeleportation(Purpoid purpoid, BlockPos pos) {
        super.beginTeleportation(purpoid, pos);
        Direction side = this.side;
        purpoid.setRestingPos(pos.m_5484_(side, -3));
        purpoid.setRestingSide(side);
    }

    @Override
    @Nullable
    protected BlockPos generateTeleportPos(Purpoid purpoid, RandomSource random) {
        BlockPos pos = purpoid.m_20183_();
        int sizeXZ = 12;
        if (purpoid.forcedRelativeTeleportingPos != null) {
            pos = purpoid.forcedRelativeTeleportingPos;
            sizeXZ = 3;
        }
        int originX = pos.m_123341_();
        int originY = pos.m_123342_();
        int originZ = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Level level = purpoid.m_9236_();
        ArrayList<Pair> sidedTeleportPositions = new ArrayList<Pair>();
        List shuffledHorizontals = Direction.Plane.HORIZONTAL.m_235694_(random);
        for (int x = originX - sizeXZ; x <= originX + sizeXZ; ++x) {
            for (int y = originY - 12; y <= originY + 12; ++y) {
                block2: for (int z = originZ - sizeXZ; z <= originZ + sizeXZ; ++z) {
                    mutable.m_122178_(x, y, z);
                    BlockPos chorusPlantPos = mutable.m_7949_();
                    if (level.m_8055_((BlockPos)mutable).m_60734_() != Blocks.f_50490_) continue;
                    for (Direction direction : shuffledHorizontals) {
                        boolean airInPath = true;
                        for (int forwardIndex = 0; forwardIndex < 3; ++forwardIndex) {
                            mutable.m_122173_(direction);
                            if (level.m_8055_((BlockPos)mutable).m_60795_()) continue;
                            airInPath = false;
                            break;
                        }
                        if (airInPath && PurpoidTeleportToFlowerGoal.isRestingPosNotBlocked(purpoid, Vec3.m_82539_((Vec3i)mutable), chorusPlantPos, direction)) {
                            sidedTeleportPositions.add(Pair.of((Object)mutable.m_7949_(), (Object)direction));
                            mutable.m_122178_(x, y, z);
                            continue block2;
                        }
                        mutable.m_122178_(x, y, z);
                    }
                }
            }
        }
        if (sidedTeleportPositions.isEmpty()) {
            return null;
        }
        Pair sidedTeleportPosition = (Pair)sidedTeleportPositions.get(random.m_188503_(sidedTeleportPositions.size()));
        this.side = (Direction)sidedTeleportPosition.getSecond();
        return (BlockPos)sidedTeleportPosition.getFirst();
    }

    @Override
    public boolean m_183429_() {
        return true;
    }
}

