/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity;

import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EESoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PoiseClusterEntity
extends LivingEntity {
    private static final int MAX_BLOCKS_TO_MOVE_UP = 30;
    private static final EntityDataAccessor<BlockPos> ORIGIN = SynchedEntityData.m_135353_(PoiseClusterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> BLOCKS_TO_MOVE_UP = SynchedEntityData.m_135353_(PoiseClusterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TIMES_HIT = SynchedEntityData.m_135353_(PoiseClusterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ASCEND = SynchedEntityData.m_135353_(PoiseClusterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean playedSound;

    public PoiseClusterEntity(EntityType<? extends PoiseClusterEntity> cluster, Level worldIn) {
        super((EntityType)EEEntityTypes.POISE_CLUSTER.get(), worldIn);
    }

    public PoiseClusterEntity(Level worldIn, BlockPos origin, double x, double y, double z) {
        this((EntityType<? extends PoiseClusterEntity>)((EntityType)EEEntityTypes.POISE_CLUSTER.get()), worldIn);
        this.m_21153_(100.0f);
        this.setOrigin(new BlockPos((Vec3i)origin));
        this.m_6034_(x + 0.5, y, z + 0.5);
        this.m_20242_(true);
        this.f_20884_ = 180.0f;
        this.f_20883_ = 180.0f;
        this.m_146922_(180.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ORIGIN, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(BLOCKS_TO_MOVE_UP, (Object)0);
        this.f_19804_.m_135372_(TIMES_HIT, (Object)0);
        this.f_19804_.m_135372_(ASCEND, (Object)true);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128356_("OriginPos", this.getOrigin().m_121878_());
        nbt.m_128405_("BlocksToMoveUp", this.getBlocksToMoveUp());
        nbt.m_128405_("TimesHit", this.getTimesHit());
        nbt.m_128379_("IsAscending", this.isAscending());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setOrigin(BlockPos.m_122022_((long)nbt.m_128454_("OriginPos")));
        this.setBlocksToMoveUp(nbt.m_128451_("BlocksToMoveUp"));
        this.setTimesHit(nbt.m_128451_("TimesHit"));
        this.setAscending(nbt.m_128471_("IsAscending"));
    }

    public void m_8119_() {
        boolean hasEntity;
        super.m_8119_();
        if (this.isAscending()) {
            this.moveEntitiesUp();
        }
        this.f_20884_ = 180.0f;
        this.f_20883_ = 180.0f;
        this.f_19859_ = 180.0f;
        this.m_146922_(180.0f);
        if (this.m_20186_() + 1.0 < (double)(this.getOrigin().m_123342_() + this.getBlocksToMoveUp()) && this.isAscending()) {
            this.m_20334_(0.0, 0.05f, 0.0);
        }
        if (this.m_20186_() + 1.0 >= (double)(this.getOrigin().m_123342_() + this.getBlocksToMoveUp())) {
            if (!this.m_9236_().f_46443_) {
                this.setAscending(false);
            }
            this.setBlocksToMoveUp(0);
        }
        if (!this.isAscending()) {
            if (this.m_20186_() > (double)this.getOrigin().m_123342_()) {
                this.m_20334_(0.0, -0.05f, 0.0);
            } else if (Math.ceil(this.m_20186_()) == (double)this.getOrigin().m_123342_() && this.f_19797_ > 10) {
                for (int i = 0; i < 8; ++i) {
                    double offsetX = MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.25f), (RandomSource)this.f_19796_);
                    double offsetZ = MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.25f), (RandomSource)this.f_19796_);
                    double x = (double)this.getOrigin().m_123341_() + 0.5 + offsetX;
                    double y = (double)this.getOrigin().m_123342_() + 0.5 + (double)(this.f_19796_.m_188501_() * 0.05f);
                    double z = (double)this.getOrigin().m_123343_() + 0.5 + offsetZ;
                    if (!this.m_21515_()) continue;
                    NetworkUtil.spawnParticle((String)"endergetic:short_poise_bubble", (double)x, (double)y, (double)z, (double)(MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.1f), (RandomSource)this.f_19796_) + (double)0.025f), (double)(this.f_19796_.m_188501_() * 0.15f + 0.1f), (double)(MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.1f), (RandomSource)this.f_19796_) + (double)0.025f));
                }
                this.m_9236_().m_46597_(this.getOrigin(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
                this.m_146870_();
            }
            if (this.isBlockBlockingPath(true) && this.f_19797_ > 10) {
                BlockPos pos = this.m_20183_();
                for (int i = 0; i < 8; ++i) {
                    double offsetX = MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.25f), (RandomSource)this.f_19796_);
                    double offsetZ = MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.25f), (RandomSource)this.f_19796_);
                    double x = (double)pos.m_123341_() + 0.5 + offsetX;
                    double y = (double)pos.m_123342_() + 0.5 + (double)(this.f_19796_.m_188501_() * 0.05f);
                    double z = (double)pos.m_123343_() + 0.5 + offsetZ;
                    if (!this.m_21515_()) continue;
                    NetworkUtil.spawnParticle((String)"endergetic:short_poise_bubble", (double)x, (double)y, (double)z, (double)(MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.1f), (RandomSource)this.f_19796_) + (double)0.025f), (double)(this.f_19796_.m_188501_() * 0.15f + 0.1f), (double)(MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.1f), (RandomSource)this.f_19796_) + (double)0.025f));
                }
                this.m_9236_().m_46597_(pos, ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
                this.m_146870_();
            }
        }
        AABB bb = this.m_20191_().m_82386_(0.0, 1.0, 0.0);
        List entities = this.m_20193_().m_45976_(Entity.class, bb);
        int entityCount = entities.size();
        boolean bl = hasEntity = entityCount > 0;
        if (hasEntity && this.isAscending()) {
            for (Entity entity : entities) {
                if (entity instanceof PoiseClusterEntity) {
                    if (!this.m_9236_().f_46443_) {
                        this.setAscending(false);
                    }
                    this.setBlocksToMoveUp(0);
                }
                entity.f_19789_ = 0.0f;
            }
        }
        if (this.isAscending()) {
            if (this.f_19855_ == this.m_20186_() && this.isBlockBlockingPath(false)) {
                this.beingDescending();
            }
            if (this.f_19855_ == this.m_20186_() && this.f_19797_ % 25 == 0 && this.m_20186_() + 1.0 >= (double)(this.getOrigin().m_123342_() + this.getBlocksToMoveUp())) {
                this.beingDescending();
            }
        }
        if (this.getBlocksToMoveUp() > 30) {
            this.setBlocksToMoveUp(30);
        }
        this.m_21219_();
        this.m_20095_();
        if (this.m_21223_() != 0.0f) {
            this.m_21153_(100.0f);
        }
        if (!this.m_9236_().f_46443_ && !this.playedSound) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
            this.playedSound = true;
        }
    }

    public boolean m_7313_(Entity entityIn) {
        this.setTimesHit(this.getTimesHit() + 1);
        if (this.getTimesHit() >= 3) {
            if (!this.m_9236_().f_46443_) {
                Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)EEBlocks.POISE_CLUSTER.get()));
                this.m_216990_((SoundEvent)EESoundEvents.CLUSTER_BREAK.get());
            } else {
                Level level = this.m_9236_();
                if (level instanceof ClientLevel) {
                    ClientLevel clientLevel = (ClientLevel)level;
                    BlockState state = ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_();
                    VoxelShape voxelshape = state.m_60808_((BlockGetter)this.m_9236_(), this.m_20183_());
                    voxelshape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                        double d1 = Math.min(1.0, x2 - x1);
                        double d2 = Math.min(1.0, y2 - y1);
                        double d3 = Math.min(1.0, z2 - z1);
                        int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
                        int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
                        int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
                        for (int l = 0; l < i; ++l) {
                            for (int i1 = 0; i1 < j; ++i1) {
                                for (int j1 = 0; j1 < k; ++j1) {
                                    double d4 = ((double)l + 0.5) / (double)i;
                                    double d5 = ((double)i1 + 0.5) / (double)j;
                                    double d6 = ((double)j1 + 0.5) / (double)k;
                                    double d7 = d4 * d1 + x1;
                                    double d8 = d5 * d2 + y1;
                                    double d9 = d6 * d3 + z1;
                                    Minecraft.m_91087_().f_91061_.m_107344_(new TerrainParticle(clientLevel, this.m_20185_() + d7 - 0.5, this.m_20186_() + d8, this.m_20189_() + d9 - 0.5, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, this.m_20183_()).updateSprite(state, this.m_20183_()));
                                }
                            }
                        }
                    });
                }
            }
            this.m_146870_();
            return true;
        }
        this.setAscending(true);
        this.setBlocksToMoveUp((int)(Math.ceil(this.m_20186_()) - (double)this.getOrigin().m_123342_()) + 10);
        return false;
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.m_269533_(DamageTypeTags.f_268524_)) {
            this.setTimesHit(this.getTimesHit() + 1);
            if (this.getTimesHit() >= 3) {
                if (!this.m_20193_().f_46443_) {
                    Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)EEBlocks.POISE_CLUSTER.get()));
                }
                this.m_146870_();
            }
            if ((int)(Math.ceil(this.m_20186_()) - (double)this.getOrigin().m_123342_()) + 10 < 30) {
                this.setAscending(true);
                this.setBlocksToMoveUp((int)(Math.ceil(this.m_20186_()) - (double)this.getOrigin().m_123342_()) + 10);
            } else {
                this.m_146870_();
            }
        }
        super.m_6475_(damageSrc, damageAmount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 1) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PoiseClusterSound(this));
        } else {
            super.m_7822_(id);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EESoundEvents.CLUSTER_BREAK.get();
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource source) {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || super.m_6673_(source);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_;
    }

    private boolean isBlockBlockingPath(boolean down) {
        Vec3 eyePos = down ? this.m_20182_() : this.m_20299_(1.0f);
        return this.m_9236_().m_45547_(new ClipContext(eyePos, eyePos.m_82549_(this.m_20184_()), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this)).m_6662_() != HitResult.Type.MISS;
    }

    private void moveEntitiesUp() {
        if (this.m_20184_().m_82553_() > 0.0 && this.isAscending()) {
            AABB clusterBB = this.m_20191_().m_82386_(0.0, (double)0.01f, 0.0);
            List entitiesAbove = this.m_9236_().m_45933_((Entity)this, clusterBB);
            if (!entitiesAbove.isEmpty()) {
                for (Entity entity : entitiesAbove) {
                    if (entity.m_20159_() || entity instanceof PoiseClusterEntity || entity.m_7752_() == PushReaction.IGNORE) continue;
                    AABB entityBB = entity.m_20191_();
                    double distanceMotion = clusterBB.f_82292_ - entityBB.f_82289_ + (double)(entity instanceof Player ? 0.0225f : 0.02f);
                    if (entity instanceof Player) {
                        entity.m_6478_(MoverType.PISTON, new Vec3(0.0, distanceMotion, 0.0));
                    } else {
                        entity.m_6478_(MoverType.SELF, new Vec3(0.0, distanceMotion, 0.0));
                    }
                    entity.m_6853_(true);
                }
            }
        }
    }

    private void beingDescending() {
        if (!this.m_9236_().f_46443_) {
            this.setAscending(false);
        }
        this.setBlocksToMoveUp(0);
    }

    public void setOrigin(BlockPos pos) {
        this.f_19804_.m_135381_(ORIGIN, (Object)pos);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.f_19804_.m_135370_(ORIGIN);
    }

    public void setBlocksToMoveUp(int value) {
        this.f_19804_.m_135381_(BLOCKS_TO_MOVE_UP, (Object)value);
    }

    public int getBlocksToMoveUp() {
        return (Integer)this.f_19804_.m_135370_(BLOCKS_TO_MOVE_UP);
    }

    protected void setTimesHit(int hits) {
        this.f_19804_.m_135381_(TIMES_HIT, (Object)hits);
    }

    protected int getTimesHit() {
        return (Integer)this.f_19804_.m_135370_(TIMES_HIT);
    }

    protected void setAscending(boolean acscending) {
        this.f_19804_.m_135381_(ASCEND, (Object)acscending);
    }

    public boolean isAscending() {
        return (Boolean)this.f_19804_.m_135370_(ASCEND);
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    protected void m_7324_(Entity entityIn) {
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6051_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    @Nullable
    public AABB getCollisionBox(Entity entityIn) {
        return entityIn.m_6094_() ? entityIn.m_20191_() : null;
    }

    @Nullable
    public AABB getCollisionBoundingBox() {
        return this.m_20191_();
    }

    protected float m_6108_() {
        return 0.0f;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return true;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_7998_(Entity entityIn, boolean force) {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_20254_(int seconds) {
    }

    public Iterable<ItemStack> m_6168_() {
        return NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class PoiseClusterSound
    extends AbstractTickableSoundInstance {
        private final PoiseClusterEntity cluster;
        private int ticksRemoved;

        private PoiseClusterSound(PoiseClusterEntity cluster) {
            super((SoundEvent)EESoundEvents.POISE_CLUSTER_AMBIENT.get(), SoundSource.NEUTRAL, cluster.f_19796_);
            this.cluster = cluster;
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 1.0f;
            this.f_119575_ = (float)cluster.m_20185_();
            this.f_119576_ = (float)cluster.m_20186_();
            this.f_119577_ = (float)cluster.m_20189_();
            this.f_119574_ = cluster.m_217043_().m_188501_() * 0.3f + 0.8f;
        }

        public boolean m_7784_() {
            return true;
        }

        public void m_7788_() {
            if (this.cluster.m_6084_()) {
                this.f_119575_ = (float)this.cluster.m_20185_();
                this.f_119576_ = (float)this.cluster.m_20186_();
                this.f_119577_ = (float)this.cluster.m_20189_();
            } else {
                ++this.ticksRemoved;
                if (this.ticksRemoved > 10) {
                    this.m_119609_();
                }
            }
            this.f_119573_ = Math.max(0.0f, this.f_119573_ - (float)this.ticksRemoved / 10.0f);
        }
    }
}

