/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.data.server;

import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.core.api.conditions.BlueprintAndCondition;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.woodworks.core.WoodworksConfig;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import com.teamabnormals.woodworks.core.registry.WoodworksRecipes;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodworksRecipeProvider
extends BlueprintRecipeProvider
implements IConditionBuilder {
    public static final ModLoadedCondition WOODWORKS_LOADED = new ModLoadedCondition("woodworks");
    public static final ConfigValueCondition SAWMILL_ENABLED = WoodworksRecipeProvider.config(WoodworksConfig.COMMON.sawmill, "sawmill");
    public static final ConfigValueCondition WOODEN_BOOKSHELVES = WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenBookshelves, "wooden_bookshelves");
    public static final ConfigValueCondition WOODEN_LADDERS = WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenLadders, "wooden_ladders");
    public static final ConfigValueCondition WOODEN_BEEHIVES = WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenBeehives, "wooden_beehives");
    public static final ConfigValueCondition WOODEN_CHESTS = WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenChests, "wooden_chests");
    public static final ConfigValueCondition WOODEN_BOARDS = WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenBoards, "wooden_boards");
    public static final ConfigValueCondition LEAF_PILES = WoodworksRecipeProvider.config(WoodworksConfig.COMMON.leafPiles, "leaf_piles");

    public WoodworksRecipeProvider(PackOutput output) {
        super("woodworks", output);
    }

    public void m_245200_(Consumer<FinishedRecipe> consumer) {
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)SAWMILL_ENABLED, RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)WoodworksBlocks.SAWMILL.get())).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('#'), ItemTags.f_13168_).m_206416_(Character.valueOf('S'), ItemTags.f_13175_).m_126130_("#I").m_126130_("# ").m_126130_("#S").m_126132_("has_planks", (CriterionTriggerInstance)WoodworksRecipeProvider.m_206406_((TagKey)ItemTags.f_13168_)));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenBookshelves, "wooden_bookshelves", true), RecipeCategory.BUILDING_BLOCKS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50078_).m_206416_(Character.valueOf('#'), ItemTags.f_13168_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42517_).m_126130_("###").m_126130_("XXX").m_126130_("###").m_126132_("has_book", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42517_)));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenBookshelves, "wooden_bookshelves", true), RecipeCategory.BUILDING_BLOCKS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_244299_).m_206416_(Character.valueOf('#'), ItemTags.f_13168_).m_206416_(Character.valueOf('X'), ItemTags.f_13175_).m_126130_("###").m_126130_("XXX").m_126130_("###").m_126132_("has_book", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42517_)));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenLadders, "wooden_ladders", true), RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50155_, (int)3).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126130_("# #").m_126130_("###").m_126130_("# #").m_126132_("has_stick", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42398_)));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenBeehives, "wooden_beehives", true), RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50718_).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42784_).m_126130_("PPP").m_126130_("HHH").m_126130_("PPP").m_126132_("has_honeycomb", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42784_)));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenChests, "wooden_chests", true), RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50087_).m_206416_(Character.valueOf('#'), ItemTags.f_13168_).m_126130_("###").m_126130_("# #").m_126130_("###").m_126132_("has_lots_of_items", (CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.m_55386_((int)10), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, new ItemPredicate[0])));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)WoodworksRecipeProvider.config(WoodworksConfig.COMMON.woodenChests, "wooden_chests", true), RecipeCategory.REDSTONE, (RecipeBuilder)ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.f_50325_).m_206419_(Tags.Items.CHESTS_WOODEN).m_126209_((ItemLike)Blocks.f_50266_).m_126132_("has_tripwire_hook", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Blocks.f_50266_)));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)WOODEN_CHESTS, RecipeCategory.REDSTONE, (RecipeBuilder)ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.f_50325_).m_126209_((ItemLike)Blocks.f_50087_).m_126209_((ItemLike)Blocks.f_50266_).m_126132_("has_tripwire_hook", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Blocks.f_50266_)), new ResourceLocation("woodworks", "trapped_chest"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.f_50624_).m_206416_(Character.valueOf('S'), ItemTags.f_13175_).m_206416_(Character.valueOf('B'), Tags.Items.BOOKSHELVES).m_126130_("SSS").m_126130_(" B ").m_126130_(" S ").m_126132_("has_book", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_176498_(consumer);
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_50705_, Blocks.f_50398_, (Block)WoodworksBlocks.OAK_BOARDS.get(), Blocks.f_50078_, Blocks.f_244299_, Blocks.f_50155_, Blocks.f_50718_, (Block)WoodworksBlocks.OAK_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_OAK_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_50741_, Blocks.f_50399_, (Block)WoodworksBlocks.SPRUCE_BOARDS.get(), (Block)WoodworksBlocks.SPRUCE_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_SPRUCE_BOOKSHELF.get(), (Block)WoodworksBlocks.SPRUCE_LADDER.get(), (Block)WoodworksBlocks.SPRUCE_BEEHIVE.get(), (Block)WoodworksBlocks.SPRUCE_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_SPRUCE_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_50742_, Blocks.f_50400_, (Block)WoodworksBlocks.BIRCH_BOARDS.get(), (Block)WoodworksBlocks.BIRCH_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_BIRCH_BOOKSHELF.get(), (Block)WoodworksBlocks.BIRCH_LADDER.get(), (Block)WoodworksBlocks.BIRCH_BEEHIVE.get(), (Block)WoodworksBlocks.BIRCH_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_BIRCH_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_50743_, Blocks.f_50401_, (Block)WoodworksBlocks.JUNGLE_BOARDS.get(), (Block)WoodworksBlocks.JUNGLE_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_JUNGLE_BOOKSHELF.get(), (Block)WoodworksBlocks.JUNGLE_LADDER.get(), (Block)WoodworksBlocks.JUNGLE_BEEHIVE.get(), (Block)WoodworksBlocks.JUNGLE_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_JUNGLE_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_50744_, Blocks.f_50402_, (Block)WoodworksBlocks.ACACIA_BOARDS.get(), (Block)WoodworksBlocks.ACACIA_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_ACACIA_BOOKSHELF.get(), (Block)WoodworksBlocks.ACACIA_LADDER.get(), (Block)WoodworksBlocks.ACACIA_BEEHIVE.get(), (Block)WoodworksBlocks.ACACIA_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_ACACIA_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_50745_, Blocks.f_50403_, (Block)WoodworksBlocks.DARK_OAK_BOARDS.get(), (Block)WoodworksBlocks.DARK_OAK_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_DARK_OAK_BOOKSHELF.get(), (Block)WoodworksBlocks.DARK_OAK_LADDER.get(), (Block)WoodworksBlocks.DARK_OAK_BEEHIVE.get(), (Block)WoodworksBlocks.DARK_OAK_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_DARK_OAK_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_220865_, Blocks.f_220851_, (Block)WoodworksBlocks.MANGROVE_BOARDS.get(), (Block)WoodworksBlocks.MANGROVE_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_MANGROVE_BOOKSHELF.get(), (Block)WoodworksBlocks.MANGROVE_LADDER.get(), (Block)WoodworksBlocks.MANGROVE_BEEHIVE.get(), (Block)WoodworksBlocks.MANGROVE_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_MANGROVE_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_271304_, Blocks.f_271301_, (Block)WoodworksBlocks.CHERRY_BOARDS.get(), (Block)WoodworksBlocks.CHERRY_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_CHERRY_BOOKSHELF.get(), (Block)WoodworksBlocks.CHERRY_LADDER.get(), (Block)WoodworksBlocks.CHERRY_BEEHIVE.get(), (Block)WoodworksBlocks.CHERRY_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_CHERRY_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_244477_, Blocks.f_244004_, null, (Block)WoodworksBlocks.BAMBOO_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_BAMBOO_BOOKSHELF.get(), (Block)WoodworksBlocks.BAMBOO_LADDER.get(), (Block)WoodworksBlocks.BAMBOO_BEEHIVE.get(), (Block)WoodworksBlocks.BAMBOO_CLOSET.get(), (Block)WoodworksBlocks.TRAPPED_BAMBOO_CLOSET.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_50655_, Blocks.f_50657_, (Block)WoodworksBlocks.CRIMSON_BOARDS.get(), (Block)WoodworksBlocks.CRIMSON_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_CRIMSON_BOOKSHELF.get(), (Block)WoodworksBlocks.CRIMSON_LADDER.get(), (Block)WoodworksBlocks.CRIMSON_BEEHIVE.get(), (Block)WoodworksBlocks.CRIMSON_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_CRIMSON_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(consumer, Blocks.f_50656_, Blocks.f_50658_, (Block)WoodworksBlocks.WARPED_BOARDS.get(), (Block)WoodworksBlocks.WARPED_BOOKSHELF.get(), (Block)WoodworksBlocks.CHISELED_WARPED_BOOKSHELF.get(), (Block)WoodworksBlocks.WARPED_LADDER.get(), (Block)WoodworksBlocks.WARPED_BEEHIVE.get(), (Block)WoodworksBlocks.WARPED_CHEST.get(), (Block)WoodworksBlocks.TRAPPED_WARPED_CHEST.get());
        WoodworksRecipeProvider.alternateStickRecipes(consumer, Blocks.f_244477_, Blocks.f_244641_, Blocks.f_244313_, (Block)WoodworksBlocks.BAMBOO_LADDER.get(), Items.f_41911_);
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_50050_, (Block)WoodworksBlocks.OAK_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_50051_, (Block)WoodworksBlocks.SPRUCE_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_50052_, (Block)WoodworksBlocks.BIRCH_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_50053_, (Block)WoodworksBlocks.JUNGLE_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_50054_, (Block)WoodworksBlocks.ACACIA_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_50055_, (Block)WoodworksBlocks.DARK_OAK_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_220838_, (Block)WoodworksBlocks.MANGROVE_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_271115_, (Block)WoodworksBlocks.CHERRY_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_152470_, (Block)WoodworksBlocks.AZALEA_LEAF_PILE.get());
        WoodworksRecipeProvider.leafPileRecipes(consumer, Blocks.f_152471_, (Block)WoodworksBlocks.FLOWERING_AZALEA_LEAF_PILE.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_175910_, (TagKey<Item>)ItemTags.f_13184_, (Block)WoodworksBlocks.OAK_BOARDS.get(), Blocks.f_50155_);
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_175912_, (TagKey<Item>)ItemTags.f_13188_, (Block)WoodworksBlocks.SPRUCE_BOARDS.get(), (Block)WoodworksBlocks.SPRUCE_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_175907_, (TagKey<Item>)ItemTags.f_13185_, (Block)WoodworksBlocks.BIRCH_BOARDS.get(), (Block)WoodworksBlocks.BIRCH_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_175909_, (TagKey<Item>)ItemTags.f_13187_, (Block)WoodworksBlocks.JUNGLE_BOARDS.get(), (Block)WoodworksBlocks.JUNGLE_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_175896_, (TagKey<Item>)ItemTags.f_13186_, (Block)WoodworksBlocks.ACACIA_BOARDS.get(), (Block)WoodworksBlocks.ACACIA_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_175911_, (TagKey<Item>)ItemTags.f_13183_, (Block)WoodworksBlocks.DARK_OAK_BOARDS.get(), (Block)WoodworksBlocks.DARK_OAK_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_235985_, (TagKey<Item>)ItemTags.f_215869_, (Block)WoodworksBlocks.MANGROVE_BOARDS.get(), (Block)WoodworksBlocks.MANGROVE_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_271218_, (TagKey<Item>)ItemTags.f_271202_, (Block)WoodworksBlocks.CHERRY_BOARDS.get(), (Block)WoodworksBlocks.CHERRY_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_244546_, (TagKey<Item>)ItemTags.f_256904_, Blocks.f_244489_, (Block)WoodworksBlocks.BAMBOO_LADDER.get(), true);
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_244520_, null, null, null);
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_175908_, (TagKey<Item>)ItemTags.f_13189_, (Block)WoodworksBlocks.CRIMSON_BOARDS.get(), (Block)WoodworksBlocks.CRIMSON_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(consumer, BlockFamilies.f_175913_, (TagKey<Item>)ItemTags.f_13190_, (Block)WoodworksBlocks.WARPED_BOARDS.get(), (Block)WoodworksBlocks.WARPED_LADDER.get());
    }

    public static void baseRecipes(Consumer<FinishedRecipe> consumer, Block planks, Block slab, Block boards, Block bookshelf, Block chiseledBookshelf, Block ladder, Block beehive, Block chest, Block trappedChest) {
        WoodworksRecipeProvider.baseRecipes(consumer, planks, slab, boards, bookshelf, chiseledBookshelf, ladder, beehive, chest, trappedChest, "woodworks");
    }

    public static void baseRecipes(Consumer<FinishedRecipe> consumer, Block planks, Block slab, Block boards, Block bookshelf, Block chiseledBookshelf, Block ladder, Block beehive, Block chest, Block trappedChest, String modid) {
        String prefix;
        boolean compat = !modid.equals("woodworks");
        ConfigValueCondition boardsCondition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, WOODEN_BOARDS}) : WOODEN_BOARDS;
        ConfigValueCondition bookshelfCondition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, WOODEN_BOOKSHELVES}) : WOODEN_BOOKSHELVES;
        ConfigValueCondition ladderCondition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, WOODEN_LADDERS}) : WOODEN_LADDERS;
        ConfigValueCondition beehiveCondition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, WOODEN_BEEHIVES}) : WOODEN_BEEHIVES;
        ConfigValueCondition chestCondition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, WOODEN_CHESTS}) : WOODEN_CHESTS;
        String string = prefix = planks == Blocks.f_50705_ ? "oak_" : "";
        if (boards != null) {
            WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)boardsCondition, RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)boards).m_126127_(Character.valueOf('#'), (ItemLike)slab).m_126130_("#").m_126130_("#").m_126145_("wooden_boards").m_126132_(WoodworksRecipeProvider.m_176602_((ItemLike)slab), (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)slab)));
        }
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)bookshelfCondition, RecipeCategory.BUILDING_BLOCKS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bookshelf).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42517_).m_126130_("###").m_126130_("XXX").m_126130_("###").m_126145_("wooden_bookshelf").m_126132_("has_book", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42517_)), new ResourceLocation(modid, prefix + ForgeRegistries.BLOCKS.getKey((Object)bookshelf).m_135815_()));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)bookshelfCondition, RecipeCategory.BUILDING_BLOCKS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)chiseledBookshelf).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126127_(Character.valueOf('X'), (ItemLike)slab).m_126130_("###").m_126130_("XXX").m_126130_("###").m_126145_("chiseled_wooden_bookshelf").m_126132_("has_book", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42517_)), new ResourceLocation(modid, prefix + ForgeRegistries.BLOCKS.getKey((Object)chiseledBookshelf).m_135815_()));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)ladderCondition, RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladder, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("S S").m_126130_("S#S").m_126130_("S S").m_126145_("wooden_ladder").m_126132_("has_stick", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42398_)), new ResourceLocation(modid, prefix + ForgeRegistries.BLOCKS.getKey((Object)ladder).m_135815_()));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)beehiveCondition, RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)beehive).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42784_).m_126130_("###").m_126130_("HHH").m_126130_("###").m_126145_("wooden_beehive").m_126132_("has_honeycomb", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_42784_)), new ResourceLocation(modid, prefix + ForgeRegistries.BLOCKS.getKey((Object)beehive).m_135815_()));
        if (chest != null) {
            WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)chestCondition, RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)chest).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126130_("###").m_126130_("# #").m_126130_("###").m_126145_("wooden_chest").m_126132_("has_lots_of_items", (CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.m_55386_((int)10), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, new ItemPredicate[0])));
        }
        if (trappedChest != null) {
            WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)chestCondition, RecipeCategory.REDSTONE, (RecipeBuilder)ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)trappedChest).m_126209_((ItemLike)chest).m_126209_((ItemLike)Blocks.f_50266_).m_126145_("wooden_trapped_chest").m_126132_("has_tripwire_hook", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Blocks.f_50266_)));
        }
    }

    public static void alternateStickRecipes(Consumer<FinishedRecipe> consumer, Block planks, Block fence, Block fenceGate, Block ladder, Item stick) {
        WoodworksRecipeProvider.alternateStickRecipes(consumer, planks, fence, fenceGate, ladder, stick, "woodworks");
    }

    public static void alternateStickRecipes(Consumer<FinishedRecipe> consumer, Block planks, Block fence, Block fenceGate, Block ladder, Item stick, String modid) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)3).m_126127_(Character.valueOf('W'), (ItemLike)planks).m_126127_(Character.valueOf('#'), (ItemLike)stick).m_126130_("W#W").m_126130_("W#W").m_126145_("wooden_custom_fence").m_126132_("has_planks", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)planks)).m_126140_(consumer, WoodworksRecipeProvider.getModConversionRecipeName(modid, (ItemLike)fence, (ItemLike)stick));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate).m_126127_(Character.valueOf('#'), (ItemLike)stick).m_126127_(Character.valueOf('W'), (ItemLike)planks).m_126130_("#W#").m_126130_("#W#").m_126145_("wooden_custom_fence_gate").m_126132_("has_planks", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)planks)).m_126140_(consumer, WoodworksRecipeProvider.getModConversionRecipeName(modid, (ItemLike)fenceGate, (ItemLike)stick));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)WOODEN_LADDERS, RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladder, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126127_(Character.valueOf('S'), (ItemLike)stick).m_126130_("S S").m_126130_("S#S").m_126130_("S S").m_126145_("wooden_ladder").m_126132_("has_bamboo", (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)Items.f_41911_)), WoodworksRecipeProvider.getModConversionRecipeName(modid, (ItemLike)ladder, (ItemLike)stick));
    }

    public static void sawmillRecipes(Consumer<FinishedRecipe> consumer, BlockFamily family, TagKey<Item> logs, Block boards, Block ladder) {
        WoodworksRecipeProvider.sawmillRecipes(consumer, family, logs, boards, ladder, false);
    }

    public static void sawmillRecipes(Consumer<FinishedRecipe> consumer, BlockFamily family, TagKey<Item> logs, Block boards, Block ladder, boolean half) {
        WoodworksRecipeProvider.sawmillRecipes(consumer, family, logs, boards, ladder, "woodworks", half);
    }

    public static void sawmillRecipes(Consumer<FinishedRecipe> consumer, BlockFamily family, TagKey<Item> logs, Block boards, Block ladder, String modid) {
        WoodworksRecipeProvider.sawmillRecipes(consumer, family, logs, boards, ladder, modid, false);
    }

    public static void sawmillRecipes(Consumer<FinishedRecipe> consumer, BlockFamily family, TagKey<Item> logs, Block boards, Block ladder, String modid, boolean half) {
        Block fenceGate;
        boolean compat = !modid.equals("woodworks");
        boolean full = !half;
        Block planks = family.m_175951_();
        Block button = family.m_175952_(BlockFamily.Variant.BUTTON);
        Block door = family.m_175952_(BlockFamily.Variant.DOOR);
        Block fence = family.m_175952_(BlockFamily.Variant.FENCE);
        if (fence == null) {
            fence = family.m_175952_(BlockFamily.Variant.CUSTOM_FENCE);
        }
        if ((fenceGate = family.m_175952_(BlockFamily.Variant.FENCE_GATE)) == null) {
            fenceGate = family.m_175952_(BlockFamily.Variant.CUSTOM_FENCE_GATE);
        }
        Block pressurePlate = family.m_175952_(BlockFamily.Variant.PRESSURE_PLATE);
        Block sign = family.m_175952_(BlockFamily.Variant.SIGN);
        Block slab = family.m_175952_(BlockFamily.Variant.SLAB);
        Block stairs = family.m_175952_(BlockFamily.Variant.STAIRS);
        Block trapdoor = family.m_175952_(BlockFamily.Variant.TRAPDOOR);
        ConfigValueCondition sawmillCondition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, SAWMILL_ENABLED}) : SAWMILL_ENABLED;
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, logs, (ItemLike)planks, full ? 4 : 2, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, (ItemLike)planks, (ItemLike)button, 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)button, full ? 4 : 2, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)door, full ? 2 : 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.DECORATIONS, (ItemLike)planks, (ItemLike)fence, 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.DECORATIONS, logs, (ItemLike)fence, full ? 4 : 2, "", modid);
        if (full) {
            WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)fenceGate, 1, "", modid);
        }
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)pressurePlate, full ? 2 : 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.DECORATIONS, logs, (ItemLike)sign, full ? 2 : 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (ItemLike)slab, 2, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, logs, (ItemLike)slab, full ? 8 : 4, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (ItemLike)stairs, 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, logs, (ItemLike)stairs, full ? 4 : 2, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)trapdoor, full ? 2 : 1, "", modid);
        if (boards != null) {
            BlueprintAndCondition boardsCondition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, SAWMILL_ENABLED, WOODEN_BOARDS}) : new BlueprintAndCondition(new ICondition[]{SAWMILL_ENABLED, WOODEN_BOARDS});
            WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)boardsCondition, RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (ItemLike)boards, 1, "", modid);
            WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)boardsCondition, RecipeCategory.BUILDING_BLOCKS, logs, (ItemLike)boards, full ? 4 : 2, "", modid);
        }
        if (ladder != null) {
            BlueprintAndCondition ladderCondition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, SAWMILL_ENABLED, WOODEN_LADDERS}) : new BlueprintAndCondition(new ICondition[]{SAWMILL_ENABLED, WOODEN_LADDERS});
            String prefix = planks == Blocks.f_50705_ ? "oak_" : "";
            WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)ladderCondition, RecipeCategory.DECORATIONS, (ItemLike)planks, (ItemLike)ladder, 1, prefix, modid);
            WoodworksRecipeProvider.sawmillRecipe(consumer, (ICondition)ladderCondition, RecipeCategory.DECORATIONS, logs, (ItemLike)ladder, full ? 4 : 2, prefix, modid);
        }
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, RecipeBuilder recipe) {
        WoodworksRecipeProvider.conditionalRecipe(consumer, condition, recipeCategory, recipe, RecipeBuilder.m_176493_((ItemLike)recipe.m_142372_()));
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, RecipeBuilder recipe, ResourceLocation id) {
        ConditionalRecipe.builder().addCondition(condition).addRecipe(consumer1 -> recipe.m_126140_(consumer1, id)).generateAdvancement(new ResourceLocation(id.m_135827_(), "recipes/" + recipeCategory.m_247710_() + "/" + id.m_135815_())).build(consumer, id);
    }

    public static void sawmillRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, ItemLike input, ItemLike output, int count) {
        WoodworksRecipeProvider.sawmillRecipe(consumer, condition, recipeCategory, input, output, count, "");
    }

    public static void sawmillRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, ItemLike input, ItemLike output, int count, String prefix) {
        WoodworksRecipeProvider.sawmillRecipe(consumer, condition, recipeCategory, input, output, count, prefix, "woodworks");
    }

    public static void sawmillRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, ItemLike input, ItemLike output, int count, String prefix, String modid) {
        if (input != null && output != null) {
            ResourceLocation id = new ResourceLocation(modid, prefix + WoodworksRecipeProvider.m_176517_((ItemLike)output, (ItemLike)input) + "_sawing");
            SingleItemRecipeBuilder recipe = WoodworksRecipeProvider.sawmillResultFromBase(recipeCategory, output, input, count);
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> WoodworksRecipeProvider.lambda$sawmillRecipe$1((RecipeBuilder)recipe, id, arg_0)).generateAdvancement(new ResourceLocation(id.m_135827_(), "recipes/" + recipeCategory.m_247710_() + "/" + id.m_135815_())).build(consumer, id);
        }
    }

    public static void sawmillRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, TagKey<Item> input, ItemLike output, int count) {
        WoodworksRecipeProvider.sawmillRecipe(consumer, condition, recipeCategory, input, output, count, "");
    }

    public static void sawmillRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, TagKey<Item> input, ItemLike output, int count, String prefix) {
        WoodworksRecipeProvider.sawmillRecipe(consumer, condition, recipeCategory, input, output, count, prefix, "woodworks");
    }

    public static void sawmillRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, TagKey<Item> input, ItemLike output, int count, String prefix, String modid) {
        if (input != null && output != null) {
            ResourceLocation id = new ResourceLocation(modid, prefix + WoodworksRecipeProvider.getConversionRecipeName(output, input) + "_sawing");
            SingleItemRecipeBuilder recipe = WoodworksRecipeProvider.sawmillResultFromBase(recipeCategory, output, input, count);
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> WoodworksRecipeProvider.lambda$sawmillRecipe$2((RecipeBuilder)recipe, id, arg_0)).generateAdvancement(new ResourceLocation(id.m_135827_(), "recipes/" + recipeCategory.m_247710_() + "/" + id.m_135815_())).build(consumer, id);
        }
    }

    public static void leafPileRecipes(Consumer<FinishedRecipe> consumer, Block leaves, Block leafPile) {
        WoodworksRecipeProvider.leafPileRecipes(consumer, leaves, leafPile, "woodworks");
    }

    public static void leafPileRecipes(Consumer<FinishedRecipe> consumer, Block leaves, Block leafPile, String modid) {
        boolean compat = !modid.equals("woodworks");
        ConfigValueCondition condition = compat ? new BlueprintAndCondition(new ICondition[]{WOODWORKS_LOADED, LEAF_PILES}) : LEAF_PILES;
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)condition, RecipeCategory.DECORATIONS, (RecipeBuilder)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leafPile, (int)4).m_126211_((ItemLike)leaves, 1).m_126145_("leaf_pile").m_126132_(WoodworksRecipeProvider.m_176602_((ItemLike)leaves), (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)leaves)));
        WoodworksRecipeProvider.conditionalRecipe(consumer, (ICondition)condition, RecipeCategory.DECORATIONS, (RecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leaves, (int)1).m_126127_(Character.valueOf('#'), (ItemLike)leafPile).m_126130_("##").m_126130_("##").m_126145_("leaves").m_126132_(WoodworksRecipeProvider.m_176602_((ItemLike)leafPile), (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)leafPile)), new ResourceLocation(modid, ForgeRegistries.BLOCKS.getKey((Object)leaves).m_135815_() + "_from_leaf_piles"));
    }

    public static ConfigValueCondition config(ForgeConfigSpec.ConfigValue<?> value, String key, boolean inverted) {
        return new ConfigValueCondition(new ResourceLocation("woodworks", "config"), value, key, (Map)Maps.newHashMap(), inverted);
    }

    public static ConfigValueCondition config(ForgeConfigSpec.ConfigValue<?> value, String key) {
        return WoodworksRecipeProvider.config(value, key, false);
    }

    public static SingleItemRecipeBuilder sawing(RecipeCategory recipeCategory, Ingredient ingredient, ItemLike item, int count) {
        return new SingleItemRecipeBuilder(recipeCategory, (RecipeSerializer)WoodworksRecipes.WoodworksRecipeSerializers.SAWMILL.get(), ingredient, item, count);
    }

    protected static SingleItemRecipeBuilder sawmillResultFromBase(RecipeCategory recipeCategory, ItemLike output, ItemLike input, int count) {
        return WoodworksRecipeProvider.sawing(recipeCategory, Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), output, count).m_126132_(WoodworksRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)WoodworksRecipeProvider.m_125977_((ItemLike)input));
    }

    protected static SingleItemRecipeBuilder sawmillResultFromBase(RecipeCategory recipeCategory, ItemLike output, TagKey<Item> input, int count) {
        return WoodworksRecipeProvider.sawing(recipeCategory, Ingredient.m_204132_(input), output, count).m_126132_("has_" + input.f_203868_().m_135815_(), (CriterionTriggerInstance)WoodworksRecipeProvider.m_206406_(input));
    }

    protected static String getConversionRecipeName(ItemLike output, TagKey<Item> input) {
        return WoodworksRecipeProvider.m_176632_((ItemLike)output) + "_from_" + input.f_203868_().m_135815_();
    }

    public static ResourceLocation getModConversionRecipeName(String modid, ItemLike output, ItemLike input) {
        return new ResourceLocation(modid, WoodworksRecipeProvider.m_176517_((ItemLike)output, (ItemLike)input));
    }

    private static /* synthetic */ void lambda$sawmillRecipe$2(RecipeBuilder recipe, ResourceLocation id, Consumer consumer1) {
        recipe.m_126140_(consumer1, id);
    }

    private static /* synthetic */ void lambda$sawmillRecipe$1(RecipeBuilder recipe, ResourceLocation id, Consumer consumer1) {
        recipe.m_126140_(consumer1, id);
    }
}

