/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.common.block.entity;

import com.teamabnormals.woodworks.common.block.ClosetBlock;
import com.teamabnormals.woodworks.core.registry.WoodworksBlockEntityTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ClosetBlockEntity
extends ChestBlockEntity {
    public static final String CONTAINER_CLOSET = "container.woodworks.closet";
    public static final String CONTAINER_CLOSET_DOUBLE = "container.woodworks.closetDouble";
    private final ContainerOpenersCounter newOpenersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            ClosetBlockEntity.playSound(level, pos, state, (SoundEvent)WoodworksSounds.BAMBOO_WOOD_CLOSET_OPEN.get());
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            ClosetBlockEntity.playSound(level, pos, state, (SoundEvent)WoodworksSounds.BAMBOO_WOOD_CLOSET_CLOSE.get());
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int num1, int num2) {
            ClosetBlockEntity.this.m_142151_(level, pos, state, num1, num2);
        }

        protected boolean m_142718_(Player player) {
            CompoundContainer compoundContainer;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (!(abstractContainerMenu instanceof ChestMenu)) {
                return false;
            }
            ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
            Container container = chestMenu.m_39261_();
            return container == ClosetBlockEntity.this || container instanceof CompoundContainer && (compoundContainer = (CompoundContainer)container).m_18927_((Container)ClosetBlockEntity.this);
        }
    };

    public static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent event) {
        ChestType chesttype = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.5;
            double d2 = (double)pos.m_123343_() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ClosetBlock.getConnectedDirection(state);
                d1 += (double)direction.m_122430_() * 0.5;
            }
            level.m_6263_(null, d0, d1, d2, event, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    protected ClosetBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public ClosetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)WoodworksBlockEntityTypes.CLOSET.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        BlockPos worldPos = this.f_58858_;
        int x = worldPos.m_123341_();
        int y = worldPos.m_123342_();
        int z = worldPos.m_123343_();
        return new AABB((double)(x - 1), (double)y, (double)(z - 1), (double)(x + 2), (double)(y + 2), (double)(z + 2));
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)CONTAINER_CLOSET);
    }

    public boolean m_7525_(Player player) {
        return ClosetBlockEntity.canUnlock(player, this.f_58621_, this.m_5446_());
    }

    public static boolean canUnlock(Player player, LockCode code, Component component) {
        if (!player.m_5833_() && !code.m_19107_(player.m_21205_())) {
            player.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{component}), true);
            player.m_6330_((SoundEvent)WoodworksSounds.BAMBOO_WOOD_CLOSET_LOCKED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }
}

