/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.buzzier_bees.core.data.server.modifiers;

import com.teamabnormals.buzzier_bees.core.other.tags.BBBiomeTags;
import com.teamabnormals.buzzier_bees.core.registry.BBEntityTypes;
import com.teamabnormals.buzzier_bees.core.registry.BBFeatures;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class BBBiomeModifierProvider {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        BBBiomeModifierProvider.removeSpawn(context, "remove_animal/cow", BBBiomeTags.HAS_MOOBLOOM, EntityType.f_20557_);
        BBBiomeModifierProvider.addSpawn(context, "add_animal/moobloom", BBBiomeTags.HAS_MOOBLOOM, new MobSpawnSettings.SpawnerData((EntityType)BBEntityTypes.MOOBLOOM.get(), 12, 4, 4));
        BBBiomeModifierProvider.addFeature(context, "add_feature/buttercup", BBBiomeTags.HAS_BUTTERCUP, GenerationStep.Decoration.VEGETAL_DECORATION, BBFeatures.BBPlacedFeatures.FLOWER_BUTTERCUP);
        BBBiomeModifierProvider.addFeature(context, "add_feature/white_clover", BBBiomeTags.HAS_WHITE_CLOVER, GenerationStep.Decoration.VEGETAL_DECORATION, BBFeatures.BBPlacedFeatures.FLOWER_WHITE_CLOVER);
        BBBiomeModifierProvider.addFeature(context, "add_feature/pink_clover", BBBiomeTags.HAS_PINK_CLOVER, GenerationStep.Decoration.VEGETAL_DECORATION, BBFeatures.BBPlacedFeatures.FLOWER_PINK_CLOVER);
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        BBBiomeModifierProvider.register(context, name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), BBBiomeModifierProvider.featureSet(context, features), step));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        BBBiomeModifierProvider.register(context, name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), List.of(spawns)));
    }

    private static void removeSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, EntityType<?> ... types) {
        BBBiomeModifierProvider.register(context, name, () -> new ForgeBiomeModifiers.RemoveSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet)HolderSet.m_205800_(Stream.of(types).map(type -> (Holder)ForgeRegistries.ENTITY_TYPES.getHolder(type).get()).collect(Collectors.toList()))));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("buzzier_bees", "add_feature/" + name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(placedFeatureKey -> context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)).collect(Collectors.toList()));
    }
}

