/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class IconWidget
extends Widget {
    private final ResourceLocation BG = new ResourceLocation("inventoryhud", "textures/gui/tf_bg.png");
    private TextureAtlasSprite effectSprite;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public IconWidget(int x, int y, int width, int height, String effectName) {
        super(x, y, width, height, "");
        this.setEffectAtlasSprite(effectName);
    }

    public void setEffectAtlasSprite(String effectName) {
        String[] splitName = effectName.split("[/:]");
        MobEffect effect = splitName.length > 1 ? (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(splitName[0], splitName[1])) : (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
        this.effectSprite = effect == null ? null : this.minecraft.m_91306_().m_118732_(effect);
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float pt) {
        super.render(gui, mouseX, mouseY, pt);
        gui.m_280168_().m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.renderBackground(gui);
        this.renderIcon(gui);
        RenderSystem.disableBlend();
        gui.m_280168_().m_85849_();
    }

    private void renderIcon(GuiGraphics gui) {
        if (this.effectSprite == null) {
            return;
        }
        gui.m_280159_(this.x + 2, this.y + 2, 0, 16, 16, this.effectSprite);
    }

    private void renderBackground(GuiGraphics gui) {
        gui.m_280411_(this.BG, this.x, this.y, 2, 2, 16.0f, 0.0f, 2, 2, 32, 32);
        gui.m_280411_(this.BG, this.x + this.width - 2, this.y, 2, 2, 30.0f, 0.0f, 2, 2, 32, 32);
        gui.m_280411_(this.BG, this.x, this.y + this.height - 2, 2, 2, 16.0f, 14.0f, 2, 2, 32, 32);
        gui.m_280411_(this.BG, this.x + this.width - 2, this.y + this.height - 2, 2, 2, 30.0f, 14.0f, 2, 2, 32, 32);
        gui.m_280411_(this.BG, this.x + 2, this.y, this.width - 4, 2, 18.0f, 0.0f, 12, 2, 32, 32);
        gui.m_280411_(this.BG, this.x + this.width - 2, this.y + 2, 2, this.height - 4, 30.0f, 2.0f, 2, 12, 32, 32);
        gui.m_280411_(this.BG, this.x + 2, this.y + this.height - 2, this.width - 4, 2, 18.0f, 14.0f, 12, 2, 32, 32);
        gui.m_280411_(this.BG, this.x, this.y + 2, 2, this.height - 4, 16.0f, 2.0f, 2, 12, 32, 32);
        gui.m_280411_(this.BG, this.x + 2, this.y + 2, this.width - 4, this.height - 4, 18.0f, 2.0f, 12, 12, 32, 32);
    }
}

