/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class BlockArmorRenderer
extends ArmorRenderer {
    private boolean right;

    public BlockArmorRenderer(Minecraft mc) {
        super(mc);
    }

    public void changeOffset() {
        this.right = this.getRight(this.armX, this.ArmAligns.HorAlign);
    }

    @Override
    public void render(GuiGraphics gui, int width, int height) {
        int x = this.getX(width, (int)(90.0f * this.armScale), this.armX, this.ArmAligns.HorAlign);
        int y = this.getY(height, (int)(70.0f * this.armScale), this.armY, this.ArmAligns.VertAlign);
        this.preRender(gui, x, y);
        gui.m_280168_().m_85841_(this.armScale, this.armScale, 1.0f);
        this.renderItems(gui, this.right);
        this.postRender(gui);
    }

    private void renderItems(GuiGraphics gui, boolean right) {
        int yOffset;
        int i = 5;
        int seed = 40;
        int xOffsetT = right ? 75 : 0;
        for (ItemStack item : this.mc.f_91074_.m_20158_()) {
            int damage;
            if (!this.showMain && i == 5) {
                --i;
                continue;
            }
            if (!this.showOff && i == 4) {
                --i;
                continue;
            }
            if (!this.showArmor && i < 4) {
                --i;
                continue;
            }
            yOffset = i % 4 * 18;
            if (i == 4 && this.showMain) {
                yOffset += 18;
            }
            if (i == 5) {
                yOffset -= 18;
            }
            int xOffset = xOffsetT;
            if (i > 3 && this.showArmor) {
                int n = xOffset = right ? xOffset - 42 : xOffset + 42;
            }
            if ((damage = ArmorStatus.getDamage(item)) >= 0 && damage <= this.armAbove) {
                String text = this.getText(item, damage);
                this.renderElementInBlock(gui, xOffset, yOffset, !right, null, item, text, this.armBars, seed++);
            } else if (damage == -2) {
                String t = null;
                boolean over = true;
                if ((i == 5 || i == 4) && this.showCount) {
                    t = "" + this.getItemCount(item);
                    over = false;
                }
                this.renderElementInBlock(gui, xOffset, yOffset, !right, null, item, t, over, seed++);
            } else if (this.showEmpty) {
                this.renderElementInBlock(gui, xOffset, yOffset, !right, this.armorRL[i], null, null, false, 0);
            }
            --i;
        }
        if (this.showArrows || this.showInv) {
            int[] values = this.getFreeAndAmmo();
            int xOffset = xOffsetT;
            yOffset = 36;
            if (this.showArmor) {
                int n = xOffset = right ? xOffset - 42 : xOffset + 42;
            }
            if (!this.showMain) {
                yOffset -= 18;
            }
            if (!this.showOff) {
                yOffset -= 18;
            }
            if (this.showInv) {
                this.renderElementInBlock(gui, xOffset, yOffset, !right, this.armorRL[6], null, "" + values[0], false, 0);
                yOffset += 18;
            }
            if (this.showArrows()) {
                this.renderElementInBlock(gui, xOffset, yOffset, !right, this.armorRL[7], null, "" + values[1], false, 0);
            }
        }
    }
}

