/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders;

import com.mrcrayfish.goblintraders.Bootstrap;
import com.mrcrayfish.goblintraders.client.ClientBootstrap;
import com.mrcrayfish.goblintraders.core.ModEntities;
import com.mrcrayfish.goblintraders.datagen.GoblinTradeProvider;
import com.mrcrayfish.goblintraders.datagen.PlatformLootTableProvider;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="goblintraders")
public class GoblinTraders {
    public GoblinTraders() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(this::onGatherData);
        bus.addListener(this::onEntityAttributeCreation);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListener);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(Bootstrap::init);
    }

    private void onClientSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ClientBootstrap::init);
    }

    public void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new PlatformLootTableProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new GoblinTradeProvider(output, lookupProvider));
    }

    private void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.GOBLIN_TRADER.get(), AbstractGoblinEntity.createAttributes().m_22265_());
        event.put((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), AbstractGoblinEntity.createAttributes().m_22265_());
    }

    public void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)TradeManager.instance());
    }
}

