/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.RovingCube;

public class CubeMoveToRedstoneSymbolsGoal
extends Goal {
    private final RovingCube myCube;
    private final double speed;
    private BlockPos targetPos;

    public CubeMoveToRedstoneSymbolsGoal(RovingCube cube, double speed) {
        this.myCube = cube;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.myCube.m_217043_().m_188503_(20) != 0) {
            return false;
        }
        BlockPos pos = this.searchForRedstoneSymbol(this.myCube);
        if (pos == null) {
            return false;
        }
        this.targetPos = pos;
        return true;
    }

    public boolean m_8045_() {
        return !this.myCube.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.myCube.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), this.speed);
    }

    @Nullable
    private BlockPos searchForRedstoneSymbol(RovingCube cube) {
        BlockPos curPos = new BlockPos((Vec3i)cube.m_20183_());
        for (int x = -16; x < 16; ++x) {
            for (int z = -16; z < 16; ++z) {
                for (int y = -5; y < 5; ++y) {
                    if (!this.isRedstoneSymbol(curPos.m_7918_(x, y, z))) continue;
                    this.myCube.hasFoundSymbol = true;
                    this.myCube.symbolX = curPos.m_123341_() + x;
                    this.myCube.symbolY = curPos.m_123342_() + y;
                    this.myCube.symbolZ = curPos.m_123343_() + z;
                    return curPos.m_7918_(x, y, z);
                }
            }
        }
        return null;
    }

    private boolean isRedstoneSymbol(BlockPos pos) {
        if (!this.myCube.m_9236_().m_46805_(pos) || !this.myCube.m_9236_().m_46859_(pos)) {
            return false;
        }
        for (Direction e : Direction.values()) {
            if (this.myCube.m_9236_().m_8055_(pos.m_121945_(e)).m_60734_() == Blocks.f_50088_) continue;
            return false;
        }
        return true;
    }
}

