/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei.categories;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;
import twilightforest.TwilightForestMod;
import twilightforest.compat.jei.JEICompat;
import twilightforest.compat.jei.renderers.EntityRenderer;
import twilightforest.init.TFItems;
import twilightforest.item.recipe.TransformPowderRecipe;

public class TransformationPowderCategory
implements IRecipeCategory<TransformPowderRecipe> {
    public static final RecipeType<TransformPowderRecipe> TRANSFORMATION = RecipeType.create((String)"twilightforest", (String)"transformation", TransformPowderRecipe.class);
    public static final int WIDTH = 116;
    public static final int HEIGHT = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable doubleArrow;
    private final Component localizedName;
    private final EntityRenderer entityRenderer = new EntityRenderer(32);

    public TransformationPowderCategory(IGuiHelper helper) {
        ResourceLocation location = TwilightForestMod.getGuiTexture("transformation_jei.png");
        this.background = helper.createDrawable(location, 0, 0, 116, 54);
        this.arrow = helper.createDrawable(location, 116, 0, 23, 15);
        this.doubleArrow = helper.createDrawable(location, 116, 16, 23, 15);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)TFItems.TRANSFORMATION_POWDER.get()).m_7968_());
        this.localizedName = Component.m_237115_((String)"gui.twilightforest.transformation_jei");
    }

    public RecipeType<TransformPowderRecipe> getRecipeType() {
        return TRANSFORMATION;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(TransformPowderRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        if (recipe.isReversible()) {
            this.doubleArrow.draw(graphics, 46, 19);
        } else {
            this.arrow.draw(graphics, 46, 19);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TransformPowderRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 8, 11).setCustomRenderer(JEICompat.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredient(JEICompat.ENTITY_TYPE, recipe.input());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType(recipe.input())));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 11).setCustomRenderer(JEICompat.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredient(JEICompat.ENTITY_TYPE, recipe.result());
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType(recipe.result())));
    }
}

