/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.common.item;

import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ArmorTiers {

    public static enum ArmorTierEnum implements ArmorMaterial
    {
        SPIRIT_HUNTER("malum:spirit_hunter", 16, new int[]{1, 3, 4, 2}, 16, () -> SoundEvents.f_11678_, (Supplier<Item>)ItemRegistry.SPIRIT_FABRIC, 0.0f),
        SOUL_STAINED_STEEL("malum:soul_stained_steel", 24, new int[]{2, 6, 7, 3}, 16, () -> SoundEvents.f_11677_, (Supplier<Item>)ItemRegistry.SOUL_STAINED_STEEL_PLATING, 2.0f),
        MALIGNANT_ALLOY("malum:malignant_alloy", 32, new int[]{3, 6, 8, 3}, 24, () -> SoundEvents.f_11679_, (Supplier<Item>)ItemRegistry.MALIGNANT_PEWTER_PLATING, 2.0f, 0.1f);

        private static final int[] MAX_DAMAGE_ARRAY;
        private final String name;
        private final int durabilityMultiplier;
        private final int[] damageReduction;
        private final int enchantability;
        private final Supplier<SoundEvent> equipSound;
        private final Supplier<Item> repairItem;
        private final float toughness;
        private final float knockbackResistance;

        private ArmorTierEnum(String name, int durabilityMultiplier, int[] damageReduction, int enchantability, Supplier<SoundEvent> equipSound, Supplier<Item> repairItem, float toughness) {
            this(name, durabilityMultiplier, damageReduction, enchantability, equipSound, repairItem, toughness, 0.0f);
        }

        private ArmorTierEnum(String name, int durabilityMultiplier, int[] damageReduction, int enchantability, Supplier<SoundEvent> equipSound, Supplier<Item> repairItem, float toughness, float knockbackResistance) {
            this.name = name;
            this.durabilityMultiplier = durabilityMultiplier;
            this.damageReduction = damageReduction;
            this.enchantability = enchantability;
            this.equipSound = equipSound;
            this.repairItem = repairItem;
            this.toughness = toughness;
            this.knockbackResistance = knockbackResistance;
        }

        public int m_266425_(ArmorItem.Type slot) {
            return this.durabilityMultiplier * MAX_DAMAGE_ARRAY[slot.m_266308_().m_20749_()];
        }

        public int m_7366_(ArmorItem.Type slot) {
            return this.damageReduction[slot.m_266308_().m_20749_()];
        }

        public int m_6646_() {
            return this.enchantability;
        }

        @Nonnull
        public SoundEvent m_7344_() {
            return this.equipSound.get();
        }

        @Nonnull
        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.repairItem.get()});
        }

        @Nonnull
        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return this.knockbackResistance;
        }

        static {
            MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
        }
    }
}

