/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.block;

import com.google.common.collect.ImmutableSet;
import com.sammy.malum.common.block.ether.EtherBlock;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlock;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.block.LodestoneBlockProperties;

public class MalumBlockLootTables
extends LootTableProvider {
    private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    private static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_285888_(HAS_SILK_TOUCH);
    private static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    private static final Set<Item> EXPLOSION_RESISTANT = (Set)Stream.of(Blocks.f_50260_, Blocks.f_50273_, Blocks.f_50569_, Blocks.f_50310_, Blocks.f_50312_, Blocks.f_50316_, Blocks.f_50314_, Blocks.f_50318_, Blocks.f_50320_, Blocks.f_50456_, Blocks.f_50525_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50466_, Blocks.f_50464_, Blocks.f_50523_, Blocks.f_50460_, Blocks.f_50465_, Blocks.f_50462_, Blocks.f_50459_, Blocks.f_50458_, Blocks.f_50463_, Blocks.f_50520_, Blocks.f_50524_, Blocks.f_50457_, Blocks.f_50461_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
    private static final float[] MAGIC_SAPLING_DROP_CHANCE = new float[]{0.015f, 0.0225f, 0.033333335f, 0.05f};

    public MalumBlockLootTables(PackOutput pOutput) {
        super(pOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlocksLoot::new, LootContextParamSets.f_81421_)));
    }

    public static class BlocksLoot
    extends BlockLootSubProvider {
        protected BlocksLoot() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected Iterable<Block> getKnownBlocks() {
            return BlockRegistry.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }

        protected void m_245660_() {
            HashSet blocks = new HashSet(BlockRegistry.BLOCKS.getEntries());
            DataHelper.takeAll(blocks, b -> ((Block)b.get()).f_60439_ instanceof LodestoneBlockProperties && ((LodestoneBlockProperties)((Block)b.get()).f_60439_).getDatagenData().hasInheritedLootTable);
            DataHelper.takeAll(blocks, (Object[])new RegistryObject[]{BlockRegistry.RUNEWOOD_LEAVES, BlockRegistry.HANGING_RUNEWOOD_LEAVES}).forEach(b -> this.m_247577_((Block)b.get(), this.m_246047_((Block)b.get(), (Block)BlockRegistry.RUNEWOOD_SAPLING.get(), MAGIC_SAPLING_DROP_CHANCE)));
            DataHelper.takeAll(blocks, (Object[])new RegistryObject[]{BlockRegistry.AZURE_RUNEWOOD_LEAVES, BlockRegistry.HANGING_AZURE_RUNEWOOD_LEAVES}).forEach(b -> this.m_247577_((Block)b.get(), this.m_246047_((Block)b.get(), (Block)BlockRegistry.AZURE_RUNEWOOD_SAPLING.get(), MAGIC_SAPLING_DROP_CHANCE)));
            DataHelper.takeAll(blocks, (Object[])new RegistryObject[]{BlockRegistry.SOULWOOD_LEAVES, BlockRegistry.BUDDING_SOULWOOD_LEAVES, BlockRegistry.HANGING_SOULWOOD_LEAVES}).forEach(b -> this.m_247577_((Block)b.get(), this.m_246047_((Block)b.get(), (Block)BlockRegistry.SOULWOOD_GROWTH.get(), MAGIC_SAPLING_DROP_CHANCE)));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.BLIGHTED_SOULWOOD)).get(), this.m_245514_((Block)BlockRegistry.BLIGHTED_SOULWOOD.get(), (ItemLike)ItemRegistry.SOULWOOD_LOG.get()));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.BLIGHTED_SOIL)).get(), this.createBlightedDrop((Block)BlockRegistry.BLIGHTED_SOIL.get(), 4));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.BLIGHTED_EARTH)).get(), this.createBlightedDrop((Block)BlockRegistry.BLIGHTED_EARTH.get(), 4).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)BlockRegistry.BLIGHTED_EARTH.get(), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Blocks.f_50493_)))));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.BLIGHTED_GROWTH)).get(), this.createBlightedPlantDrop((Block)BlockRegistry.BLIGHTED_GROWTH.get(), 1));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.BRILLIANT_STONE)).get(), this.m_246109_((Block)BlockRegistry.BRILLIANT_STONE.get(), (Item)ItemRegistry.CLUSTER_OF_BRILLIANCE.get()));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.BRILLIANT_DEEPSLATE)).get(), this.m_246109_((Block)BlockRegistry.BRILLIANT_DEEPSLATE.get(), (Item)ItemRegistry.CLUSTER_OF_BRILLIANCE.get()));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.SOULSTONE_ORE)).get(), this.m_246109_((Block)BlockRegistry.SOULSTONE_ORE.get(), (Item)ItemRegistry.RAW_SOULSTONE.get()));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.DEEPSLATE_SOULSTONE_ORE)).get(), this.m_246109_((Block)BlockRegistry.DEEPSLATE_SOULSTONE_ORE.get(), (Item)ItemRegistry.RAW_SOULSTONE.get()));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.BLAZING_QUARTZ_ORE)).get(), this.m_246109_((Block)BlockRegistry.BLAZING_QUARTZ_ORE.get(), (Item)ItemRegistry.BLAZING_QUARTZ.get()));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.NATURAL_QUARTZ_ORE)).get(), this.m_246109_((Block)BlockRegistry.NATURAL_QUARTZ_ORE.get(), (Item)ItemRegistry.NATURAL_QUARTZ.get()));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.DEEPSLATE_QUARTZ_ORE)).get(), this.m_246109_((Block)BlockRegistry.DEEPSLATE_QUARTZ_ORE.get(), (Item)ItemRegistry.NATURAL_QUARTZ.get()));
            this.m_247577_((Block)((RegistryObject)DataHelper.take(blocks, BlockRegistry.CTHONIC_GOLD_ORE)).get(), this.createCthonicGoldOreDrop((Block)BlockRegistry.CTHONIC_GOLD_ORE.get()));
            DataHelper.takeAll(blocks, b -> b.get() instanceof SaplingBlock).forEach(b -> this.m_247577_((Block)b.get(), this.m_247033_((ItemLike)((Block)b.get()).m_5456_())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof DoublePlantBlock).forEach(b -> this.m_247577_((Block)b.get(), this.createSingleItemTableWithSilkTouchOrShears((Block)b.get(), (ItemLike)((Block)b.get()).m_5456_())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof BushBlock).forEach(b -> this.m_247577_((Block)b.get(), this.createSingleItemTableWithSilkTouchOrShears((Block)b.get(), (ItemLike)((Block)b.get()).m_5456_())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof GrassBlock).forEach(b -> this.m_247577_((Block)b.get(), this.m_245514_((Block)b.get(), (ItemLike)Items.f_42329_)));
            DataHelper.takeAll(blocks, b -> b.get() instanceof SlabBlock).forEach(b -> this.m_247577_((Block)b.get(), this.m_247233_((Block)b.get())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(b -> this.m_247577_((Block)b.get(), this.m_247398_((Block)b.get())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof EtherBlock).forEach(b -> this.m_247577_((Block)b.get(), this.createEtherDrop((Block)b.get())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof SpiritJarBlock).forEach(b -> this.m_247577_((Block)b.get(), this.createJarDrop((Block)b.get())));
            DataHelper.takeAll(blocks, b -> true).forEach(b -> this.m_247577_((Block)b.get(), this.m_247033_((ItemLike)((Block)b.get()).m_5456_())));
        }

        protected LootTable.Builder createCthonicGoldOreDrop(Block block) {
            return BlocksLoot.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.CTHONIC_GOLD_FRAGMENT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)4.0f))))));
        }

        protected LootTable.Builder createBlightedDrop(Block block, int gunkAmount) {
            return BlocksLoot.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)ItemRegistry.BLIGHTED_GUNK.get(), (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.BLIGHTED_GUNK.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)gunkAmount))))));
        }

        protected LootTable.Builder createBlightedPlantDrop(Block block, int gunkAmount) {
            return BlocksLoot.m_246160_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)ItemRegistry.BLIGHTED_GUNK.get(), (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.BLIGHTED_GUNK.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)gunkAmount))))));
        }

        protected LootTable.Builder createEtherDrop(Block block) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("firstColor", "display.firstColor").m_80279_("secondColor", "display.secondColor")))));
        }

        protected LootTable.Builder createJarDrop(Block block) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("spirit", "spirit").m_80279_("count", "count")))));
        }

        protected LootTable.Builder createSingleItemTableWithSilkTouchOrShears(Block p_124258_, ItemLike p_124259_) {
            return BlocksLoot.m_246160_((Block)p_124258_, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)p_124258_, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)p_124259_))));
        }
    }
}

