/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.spiritrite.BlockAffectingRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EldritchAqueousRiteType
extends TotemicRiteType {
    public EldritchAqueousRiteType() {
        super("greater_aqueous_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.AQUEOUS_SPIRIT, SpiritTypeRegistry.AQUEOUS_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new BlockAffectingRiteEffect(){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyBlocks(totemBase, PointedDripstoneBlock.class).forEach(p -> {
                    if (level.f_46441_.m_188501_() < 0.1f) {
                        for (int i = 0; i < 4 + level.f_46441_.m_188503_(2); ++i) {
                            level.m_8055_(p).m_222972_(level, p, level.f_46441_);
                        }
                        ParticleEffectTypeRegistry.DRIPPING_SMOKE.createPositionedEffect((Level)level, new PositionEffectData((BlockPos)p), new ColorEffectData(SpiritTypeRegistry.AQUEOUS_SPIRIT.getPrimaryColor()));
                    }
                });
            }

            @Override
            public boolean canAffectBlock(TotemBaseBlockEntity totemBase, BlockState state, BlockPos pos) {
                return super.canAffectBlock(totemBase, state, pos) && PointedDripstoneBlock.m_154203_((BlockState)state, (LevelReader)totemBase.m_58904_(), (BlockPos)pos);
            }

            @Override
            public int getRiteEffectVerticalRadius() {
                return 4;
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, Zombie.class).filter(z -> !(z instanceof Drowned)).forEach(e -> {
                    if (!e.m_34329_()) {
                        e.m_34278_(100);
                        ParticleEffectTypeRegistry.HEXING_SMOKE.createEntityEffect((Entity)e, new ColorEffectData(SpiritTypeRegistry.AQUEOUS_SPIRIT.getPrimaryColor()));
                    }
                });
            }
        };
    }
}

