/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.packets.particle.curiosities.rite.AerialBlockFallRiteEffectPacket;
import com.sammy.malum.common.spiritrite.BlockAffectingRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.block.BlockTagRegistry;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class EldritchAerialRiteType
extends TotemicRiteType {
    private static final List<Item> TOOLS = List.of(Items.f_42395_, Items.f_42396_, Items.f_42394_, Items.f_42397_);

    public EldritchAerialRiteType() {
        super("greater_aerial_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.AERIAL_SPIRIT, SpiritTypeRegistry.AERIAL_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new BlockAffectingRiteEffect(){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                BlockPos pos = totemBase.m_58899_();
                this.getBlocksAhead(totemBase).forEach(p -> {
                    BlockState state;
                    BlockState stateBelow = level.m_8055_(p.m_7495_());
                    if ((FallingBlock.m_53241_((BlockState)stateBelow) || !stateBelow.m_60815_() || stateBelow.m_204336_(BlockTags.f_13031_)) && !(state = level.m_8055_(p)).m_60795_() && level.m_7702_(p) == null && EldritchAerialRiteType.canSilkTouch(level, pos, state)) {
                        FallingBlockEntity.m_201971_((Level)level, (BlockPos)p, (BlockState)state);
                        level.m_5594_(null, p, (SoundEvent)SoundRegistry.AERIAL_FALL.get(), SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
                        PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new AerialBlockFallRiteEffectPacket(SpiritTypeRegistry.AERIAL_SPIRIT.getPrimaryColor(), (BlockPos)p));
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, ServerPlayer.class).forEach(p -> {
                    ServerStatsCounter stats = p.m_8951_();
                    Stat sleepStat = Stats.f_12988_.m_12902_((Object)Stats.f_12992_);
                    int value = stats.m_13015_(sleepStat);
                    stats.m_6085_((Player)p, sleepStat, Math.max(0, value - 1000));
                    ParticleEffectTypeRegistry.HEXING_SMOKE.createEntityEffect((Entity)p, new ColorEffectData(SpiritTypeRegistry.AERIAL_SPIRIT));
                });
            }
        };
    }

    private static ItemStack getToolForState(BlockState state) {
        if (!state.m_60834_()) {
            return new ItemStack((ItemLike)Items.f_42395_);
        }
        for (Item item : TOOLS) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (!stack.m_41735_(state)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static boolean canSilkTouch(ServerLevel level, BlockPos pos, BlockState state) {
        if (state.m_204336_(BlockTagRegistry.GREATER_AERIAL_WHITELIST)) {
            return true;
        }
        ItemStack harvestToolStack = EldritchAerialRiteType.getToolForState(state);
        if (harvestToolStack.m_41619_()) {
            return false;
        }
        harvestToolStack.m_41663_(Enchantments.f_44985_, 1);
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, null, null, (ItemStack)harvestToolStack);
        Item blockItem = state.m_60734_().m_5456_();
        return drops.stream().anyMatch(s -> s.m_41720_() == blockItem);
    }
}

