/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.curiosities.blight;

import com.sammy.malum.common.packets.particle.base.spirit.SpiritBasedParticleEffectPacket;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.LodestoneClientPacket;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;

public class BlightTransformItemParticlePacket
extends SpiritBasedParticleEffectPacket {
    public BlightTransformItemParticlePacket(List<String> spirits, Vec3 pos) {
        this(spirits, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public BlightTransformItemParticlePacket(List<String> spirits, double posX, double posY, double posZ) {
        super(spirits, posX, posY, posZ);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context) {
        super.execute(context);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RandomSource rand = level.f_46441_;
        for (int i = 0; i < 3; ++i) {
            float multiplier = Mth.m_216267_((RandomSource)rand, (float)0.4f, (float)1.0f);
            float timeMultiplier = Mth.m_216267_((RandomSource)rand, (float)0.9f, (float)1.4f);
            Color color = new Color((int)(31.0f * multiplier), (int)(19.0f * multiplier), (int)(31.0f * multiplier));
            boolean spinDirection = rand.m_188499_();
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.4f, (float)1.0f, (float)0.0f).build()).setLifetime((int)(45.0f * timeMultiplier)).setSpinData(SpinParticleData.create((float)(0.2f * (float)(spinDirection ? 1 : -1))).build()).setScaleData(GenericParticleData.create((float)0.15f, (float)0.2f, (float)0.0f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)color, (Color)color).build()).enableNoClip().setRandomOffset((double)0.1f, (double)0.1f).setRandomMotion((double)0.01f, (double)0.02f).addMotion(0.0, (double)0.01f, 0.0).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).repeat((Level)level, this.posX, this.posY, this.posZ, 2);
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.35f, (float)0.55f, (float)0.0f).build()).setLifetime((int)(50.0f * timeMultiplier)).setSpinData(SpinParticleData.create((float)(0.1f * (float)(spinDirection ? 1 : -1))).build()).setScaleData(GenericParticleData.create((float)0.35f, (float)0.4f, (float)0.0f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)color, (Color)color).build()).setRandomOffset((double)0.2f, 0.0).enableNoClip().setRandomMotion((double)0.015f, (double)0.015f).addMotion(0.0, (double)0.01f, 0.0).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).repeat((Level)level, this.posX, this.posY, this.posZ, 3);
            color = new Color((int)(80.0f * multiplier), (int)(40.0f * multiplier), (int)(80.0f * multiplier));
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.15f, (float)0.0f).build()).setLifetime((int)(50.0f * timeMultiplier)).setSpinData(SpinParticleData.create((float)(0.1f * (float)(spinDirection ? 1 : -1))).build()).setScaleData(GenericParticleData.create((float)0.35f, (float)0.4f, (float)0.0f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)color, (Color)color).build()).setRandomOffset((double)0.2f, 0.0).enableNoClip().setRandomMotion((double)0.02f, (double)0.01f).addMotion(0.0, (double)0.01f, 0.0).repeat((Level)level, this.posX, this.posY, this.posZ, 2);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context, MalumSpiritType spiritType) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RandomSource rand = level.f_46441_;
        Color color = spiritType.getPrimaryColor();
        for (int i = 0; i < 3; ++i) {
            int spinDirection = rand.m_188499_() ? 1 : -1;
            int spinOffset = rand.m_188503_(360);
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.TWINKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.4f, (float)0.8f, (float)0.0f).build()).setLifetime(20).setSpinData(SpinParticleData.create((float)(0.7f * (float)spinDirection), (float)0.0f).setSpinOffset((float)spinOffset).setSpinOffset(1.25f).setEasing(Easing.CUBIC_IN).build()).setScaleData(GenericParticleData.create((float)0.075f, (float)0.15f, (float)0.0f).setCoefficient(0.8f).setEasing(Easing.QUINTIC_OUT, Easing.EXPO_IN_OUT).build()).setColorData(ColorParticleData.create((Color)ColorHelper.brighter((Color)color, (int)2), (Color)color).build()).enableNoClip().setRandomOffset((double)0.6f).setGravityStrength(1.1f).addMotion(0.0, (double)(0.28f + rand.m_188501_() * 0.15f), 0.0).disableNoClip().setRandomMotion((double)0.1f, (double)0.15f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeat((Level)level, this.posX, this.posY, this.posZ, 2);
        }
        int spinOffset = rand.m_188503_(360);
        for (int i = 0; i < 3; ++i) {
            int spinDirection = rand.m_188499_() ? 1 : -1;
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.12f, (float)0.06f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.125f + rand.m_188501_() * 0.075f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)0.85f, (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)color.brighter(), (Color)color.darker()).build()).setLifetime(30).setRandomOffset((double)0.4f).enableNoClip().setRandomMotion((double)0.01f, (double)0.01f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeat((Level)level, this.posX, this.posY, this.posZ, 5);
        }
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, BlightTransformItemParticlePacket.class, SpiritBasedParticleEffectPacket::encode, BlightTransformItemParticlePacket::decode, LodestoneClientPacket::handle);
    }

    public static BlightTransformItemParticlePacket decode(FriendlyByteBuf buf) {
        return BlightTransformItemParticlePacket.decode(BlightTransformItemParticlePacket::new, buf);
    }
}

