/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.base.spirit;

import com.sammy.malum.common.packets.particle.base.PositionBasedParticleEffectPacket;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public abstract class SpiritBasedParticleEffectPacket
extends PositionBasedParticleEffectPacket {
    protected final List<String> spirits;

    public SpiritBasedParticleEffectPacket(List<String> spirits, double posX, double posY, double posZ) {
        super(posX, posY, posZ);
        this.spirits = spirits;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.m_130070_(string);
        }
        super.encode(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context) {
        for (String string : this.spirits) {
            this.execute(context, SpiritHarvestHandler.getSpiritType(string));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void execute(Supplier<NetworkEvent.Context> var1, MalumSpiritType var2);

    public static <T extends SpiritBasedParticleEffectPacket> T decode(PacketProvider<T> provider, FriendlyByteBuf buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.m_130277_());
        }
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return provider.getPacket(spirits, posX, posY, posZ);
    }

    public static interface PacketProvider<T extends SpiritBasedParticleEffectPacket> {
        public T getPacket(List<String> var1, double var2, double var4, double var6);
    }
}

