/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.weeping;

import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.common.entity.activator.SpiritCollectionActivatorEntity;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.helpers.RandomHelper;

public class CurioWatcherNecklace
extends MalumCurioItem
implements IMalumEventResponderItem,
IVoidItem {
    public CurioWatcherNecklace(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(CurioWatcherNecklace.positiveEffect("full_health_fake_collection", new Object[0]));
    }

    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (target.m_21223_() >= target.m_21233_() * 0.9875f) {
            MalumLivingEntityDataCapability.getCapabilityOptional(target).ifPresent(c -> {
                if (c.watcherNecklaceCooldown == 0) {
                    float speed = 0.4f;
                    Level level = attacker.m_9236_();
                    RandomSource random = level.m_213780_();
                    Vec3 position = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
                    int amount = target instanceof Player ? 5 : 2;
                    for (int i = 0; i < amount; ++i) {
                        SpiritCollectionActivatorEntity entity = new SpiritCollectionActivatorEntity(level, attacker.m_20148_(), position.f_82479_, position.f_82480_, position.f_82481_, RandomHelper.randomBetween((RandomSource)random, (float)(-speed), (float)speed), RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.06f), RandomHelper.randomBetween((RandomSource)random, (float)(-speed), (float)speed));
                        level.m_7967_((Entity)entity);
                    }
                    c.watcherNecklaceCooldown = 100;
                }
            });
        }
    }

    public static void entityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        MalumLivingEntityDataCapability.getCapabilityOptional(entity).ifPresent(c -> {
            if (c.watcherNecklaceCooldown > 0) {
                --c.watcherNecklaceCooldown;
            }
        });
    }
}

