/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.enchantment.scythe;

import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.common.item.curiosities.TemporarilyDisabledItem;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.EnchantmentRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;

public class ReboundEnchantment
extends Enchantment {
    public ReboundEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentRegistry.SCYTHE_ONLY, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
    }

    protected boolean m_5975_(Enchantment pOther) {
        return !pOther.equals(EnchantmentRegistry.ASCENSION.get()) && super.m_5975_(pOther);
    }

    public int m_6586_() {
        return 3;
    }

    public static void throwScythe(Level level, Player player, InteractionHand hand, ItemStack scythe) {
        int slot;
        int n = slot = hand == InteractionHand.OFF_HAND ? player.m_150109_().m_6643_() - 1 : player.m_150109_().f_35977_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean isEnhanced = !MalumScytheItem.canSweep((LivingEntity)player);
            float baseDamage = (float)player.m_21204_().m_22181_(Attributes.f_22281_);
            float magicDamage = (float)player.m_21204_().m_22181_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get());
            float velocity = isEnhanced ? 3.0f : 1.75f;
            Vec3 position = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() * 0.5f), 0.0);
            if (isEnhanced) {
                int angle = hand == InteractionHand.MAIN_HAND ? 225 : 90;
                double radians = Math.toRadians((float)angle - player.f_20885_);
                position = player.m_20182_().m_82549_(player.m_20154_().m_82490_(0.5)).m_82520_(0.75 * Math.sin(radians), (double)(player.m_20206_() * 0.9f), 0.75 * Math.cos(radians));
                baseDamage *= 1.5f;
                magicDamage *= 1.5f;
            }
            ScytheBoomerangEntity entity = new ScytheBoomerangEntity(level, position.f_82479_, position.f_82480_, position.f_82481_);
            entity.setData((Entity)player, baseDamage, magicDamage, slot, 8);
            entity.m_37446_(scythe);
            entity.setEnhanced(isEnhanced);
            entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity, 0.0f);
            level.m_7967_((Entity)entity);
            SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)SoundRegistry.SCYTHE_THROW.get()), (float)2.0f, (float)RandomHelper.randomBetween((RandomSource)level.m_213780_(), (float)0.75f, (float)1.25f));
            TemporarilyDisabledItem.disable(serverPlayer, slot);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)scythe.m_41720_()));
            player.m_21011_(hand, true);
        }
    }

    public static void pickupScythe(ScytheBoomerangEntity entity, ItemStack scythe, ServerPlayer player) {
        int enchantmentLevel;
        if (!player.m_7500_() && (enchantmentLevel = scythe.getEnchantmentLevel((Enchantment)EnchantmentRegistry.REBOUND.get())) < 4) {
            int duration = 100 - 25 * (enchantmentLevel - 1);
            if (entity.enemiesHit > 0) {
                duration -= (entity.enemiesHit + 1) * 20;
            }
            if (duration > 0) {
                player.m_36335_().m_41524_(scythe.m_41720_(), duration);
            }
        }
        TemporarilyDisabledItem.enable(player, entity.slot);
    }
}

