/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.weeping_well;

import com.sammy.malum.common.recipe.FavorOfTheVoidRecipe;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.RadiantParticleEffects;
import com.sammy.malum.visual_effects.WeepingWellParticleEffects;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class VoidConduitBlockEntity
extends LodestoneBlockEntity {
    public final List<ItemStack> eatenItems = new ArrayList<ItemStack>();
    public int progress;
    public int streak;
    public int lingeringRadiance;

    public VoidConduitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.VOID_CONDUIT.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        if (!this.eatenItems.isEmpty()) {
            compound.m_128405_("itemCount", this.eatenItems.size());
            for (int i = 0; i < this.eatenItems.size(); ++i) {
                CompoundTag itemTag = new CompoundTag();
                ItemStack stack = this.eatenItems.get(i);
                stack.m_41739_(itemTag);
                compound.m_128365_("item_" + i, (Tag)itemTag);
            }
        }
        compound.m_128405_("progress", this.progress);
        compound.m_128405_("streak", this.streak);
        compound.m_128405_("lingeringRadiance", this.lingeringRadiance);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.eatenItems.clear();
        for (int i = 0; i < compound.m_128451_("itemCount"); ++i) {
            CompoundTag itemTag = compound.m_128469_("item_" + i);
            this.eatenItems.add(ItemStack.m_41712_((CompoundTag)itemTag));
        }
        this.progress = compound.m_128451_("progress");
        this.streak = compound.m_128451_("streak");
        this.lingeringRadiance = compound.m_128451_("lingeringRadiance");
        super.m_142466_(compound);
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.lingeringRadiance > 0) {
            --this.lingeringRadiance;
        }
        if ((level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.m_46467_() % 100L == 0L) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.UNCANNY_VALLEY.get(), SoundSource.HOSTILE, 1.0f, Mth.m_216267_((RandomSource)this.f_58857_.m_213780_(), (float)0.55f, (float)1.75f));
            }
            if (serverLevel.m_46467_() % 20L == 0L) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.VOID_HEARTBEAT.get(), SoundSource.HOSTILE, 1.5f, Mth.m_216267_((RandomSource)this.f_58857_.m_213780_(), (float)0.95f, (float)1.15f));
            }
            if (serverLevel.m_46467_() % 40L == 0L) {
                this.eatItems(serverLevel);
            }
            if (!this.eatenItems.isEmpty()) {
                ++this.progress;
                if (this.progress >= 80) {
                    int resultingProgress = 60;
                    ParticleEffectType particleEffectType = ParticleEffectTypeRegistry.WEEPING_WELL_REACTS;
                    ItemStack stack = this.eatenItems.get(this.eatenItems.size() - 1);
                    if (stack.m_41720_().equals(ItemRegistry.BLIGHTED_GUNK.get())) {
                        resultingProgress = (int)((float)resultingProgress + (float)this.streak / 2.0f);
                        ++this.streak;
                        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.VOID_EATS_GUNK.get(), SoundSource.PLAYERS, 0.7f, 0.6f + this.f_58857_.f_46441_.m_188501_() * 0.3f + (float)this.streak * 0.05f);
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.7f, 0.6f + this.f_58857_.f_46441_.m_188501_() * 0.2f + (float)this.streak * 0.05f);
                    } else {
                        Item result = this.spitOutItem(stack);
                        if (result.equals(ItemRegistry.FUSED_CONSCIOUSNESS.get())) {
                            this.lingeringRadiance = 400;
                            particleEffectType = ParticleEffectTypeRegistry.WEEPING_WELL_EMITS_RADIANCE;
                        }
                    }
                    this.progress = resultingProgress;
                    this.eatenItems.remove(this.eatenItems.size() - 1);
                    particleEffectType.createPositionedEffect(this.f_58857_, new PositionEffectData((float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.6f, (float)this.f_58858_.m_123343_() + 0.5f));
                    BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                }
                if (this.eatenItems.isEmpty()) {
                    this.progress = 0;
                }
            } else if (this.streak != 0) {
                this.streak = 0;
            }
        } else if (this.lingeringRadiance <= 100) {
            WeepingWellParticleEffects.passiveWeepingWellParticles(this);
        } else {
            RadiantParticleEffects.radiantWeepingWellParticles(this);
        }
    }

    public void eatItems(ServerLevel serverLevel) {
        List<ItemEntity> items = serverLevel.m_45976_(ItemEntity.class, new AABB(this.f_58858_.m_7918_(1, -3, 1), this.f_58858_.m_7918_(-1, -1, -1)).m_82400_(1.0)).stream().sorted(Comparator.comparingInt(itemEntity -> itemEntity.f_31985_)).toList();
        for (ItemEntity entity : items) {
            ItemStack item = entity.m_32055_();
            if (item.m_41720_().equals(ItemRegistry.BLIGHTED_GUNK.get())) {
                this.progress += 20;
            }
            this.eatenItems.add(item);
            entity.m_146870_();
        }
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public Item spitOutItem(ItemStack stack) {
        FavorOfTheVoidRecipe recipe = FavorOfTheVoidRecipe.getRecipe(this.f_58857_, stack);
        float pitch = Mth.m_216267_((RandomSource)this.f_58857_.m_213780_(), (float)0.85f, (float)1.35f) + (float)this.streak * 0.1f;
        if (recipe != null) {
            int count;
            ++this.streak;
            for (int amount = recipe.output.m_41613_() * stack.m_41613_(); amount > 0; amount -= count) {
                count = Math.min(64, amount);
                ItemStack outputStack = new ItemStack((ItemLike)recipe.output.m_41720_(), count);
                outputStack.m_41751_(recipe.output.m_41783_());
                ItemEntity entity = new ItemEntity(this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), outputStack);
                entity.m_20334_(0.0, (double)0.65f, (double)0.15f);
                this.f_58857_.m_7967_((Entity)entity);
            }
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.VOID_TRANSMUTATION.get(), SoundSource.HOSTILE, 2.0f, pitch);
            return recipe.output.m_41720_();
        }
        ItemEntity entity = new ItemEntity(this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), stack);
        entity.m_20334_(0.0, (double)0.65f, (double)0.15f);
        this.f_58857_.m_7967_((Entity)entity);
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.VOID_REJECTION.get(), SoundSource.HOSTILE, 2.0f, pitch);
        return stack.m_41720_();
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.f_58858_;
        return new AABB((double)(pos.m_123341_() - 3), (double)(pos.m_123342_() - 1), (double)(pos.m_123343_() - 3), (double)(pos.m_123341_() + 4), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 4));
    }
}

