/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_crucible;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.AugmentBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleAccelerationData;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleSoundInstance;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleTuning;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICatalyzerAccelerationTarget;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICrucibleAccelerator;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import com.sammy.malum.common.item.augment.core.AbstractCoreAugmentItem;
import com.sammy.malum.common.item.impetus.ImpetusItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.SpiritCrucibleParticleEffects;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class SpiritCrucibleCoreBlockEntity
extends MultiBlockCoreEntity
implements ICatalyzerAccelerationTarget,
IMalumSpecialItemAccessPoint {
    private static final Vec3 CRUCIBLE_ITEM_OFFSET = new Vec3(0.5, (double)1.6f, 0.5);
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)BlockRegistry.SPIRIT_CRUCIBLE_COMPONENT.get()).m_49966_())});
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public LodestoneBlockEntityInventory augmentInventory;
    public LodestoneBlockEntityInventory coreAugmentInventory;
    public SpiritFocusingRecipe recipe;
    public float spiritAmount;
    public float spiritSpin;
    public float progress;
    public int queuedCracks;
    public int crackTimer;
    public CrucibleAccelerationData acceleratorData = CrucibleAccelerationData.DEFAULT;
    public CrucibleTuning.CrucibleAttributeType tuningType = CrucibleTuning.CrucibleAttributeType.NONE;
    private final LazyOptional<IItemHandler> combinedInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory}));

    public SpiritCrucibleCoreBlockEntity(BlockEntityType<? extends SpiritCrucibleCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 1, t -> !(t.m_41720_() instanceof SpiritShardItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((Level)SpiritCrucibleCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCrucibleCoreBlockEntity.this.f_58858_);
            }
        };
        this.spiritInventory = new MalumBlockEntityInventory(4, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.needsSync = true;
                SpiritCrucibleCoreBlockEntity.this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.15f, (float)SpiritCrucibleCoreBlockEntity.this.spiritAmount, (float)(this.nonEmptyItemAmount + 1)));
                BlockHelper.updateAndNotifyState((Level)SpiritCrucibleCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCrucibleCoreBlockEntity.this.f_58858_);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                Item item = stack.m_41720_();
                if (!(item instanceof SpiritShardItem)) {
                    return false;
                }
                SpiritShardItem spiritItem = (SpiritShardItem)item;
                for (int i = 0; i < this.getSlots(); ++i) {
                    ItemStack stackInSlot;
                    if (i == slot || (stackInSlot = this.getStackInSlot(i)).m_41619_() || stackInSlot.m_41720_() != spiritItem) continue;
                    return false;
                }
                return true;
            }
        };
        this.augmentInventory = new AugmentBlockEntityInventory(4, 1){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((Level)SpiritCrucibleCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCrucibleCoreBlockEntity.this.f_58858_);
            }
        };
        this.coreAugmentInventory = new AugmentBlockEntityInventory(1, 1, t -> t.m_41720_() instanceof AbstractCoreAugmentItem){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((Level)SpiritCrucibleCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCrucibleCoreBlockEntity.this.f_58858_);
            }
        };
    }

    public SpiritCrucibleCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritCrucibleCoreBlockEntity>)((BlockEntityType)BlockEntityRegistry.SPIRIT_CRUCIBLE.get()), STRUCTURE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.spiritAmount != 0.0f) {
            compound.m_128350_("spiritAmount", this.spiritAmount);
        }
        if (this.progress != 0.0f) {
            compound.m_128350_("progress", this.progress);
        }
        if (this.queuedCracks != 0) {
            compound.m_128405_("queuedCracks", this.queuedCracks);
        }
        compound.m_128405_("tuningType", this.tuningType.ordinal());
        this.acceleratorData.save(compound);
        this.inventory.save(compound);
        this.spiritInventory.save(compound, "spiritInventory");
        this.augmentInventory.save(compound, "augmentInventory");
        this.coreAugmentInventory.save(compound, "coreAugmentInventory");
    }

    public void m_142466_(CompoundTag compound) {
        this.spiritAmount = compound.m_128457_("spiritAmount");
        this.progress = compound.m_128457_("progress");
        this.queuedCracks = compound.m_128451_("queuedCracks");
        this.tuningType = CrucibleTuning.CrucibleAttributeType.values()[Mth.m_14045_((int)compound.m_128451_("tuningType"), (int)0, (int)(CrucibleTuning.CrucibleAttributeType.values().length - 1))];
        this.acceleratorData = CrucibleAccelerationData.load(this.f_58857_, this, compound);
        this.inventory.load(compound);
        this.spiritInventory.load(compound, "spiritInventory");
        this.augmentInventory.load(compound, "augmentInventory");
        this.coreAugmentInventory.load(compound, "coreAugmentInventory");
        super.m_142466_(compound);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            ItemStack stack;
            ItemStack heldStack = player.m_21205_();
            if (heldStack.m_41720_().equals(ItemRegistry.TUNING_FORK.get())) {
                this.tuningType = this.tuningType.next(this.tuningType, this);
                this.recalibrateAccelerators(this.f_58857_, this.f_58858_);
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TUNING_FORK_TINKERS.get(), SoundSource.BLOCKS, 1.25f + this.f_58857_.f_46441_.m_188501_() * 0.5f, 0.75f + this.f_58857_.f_46441_.m_188501_() * 0.5f);
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                return InteractionResult.SUCCESS;
            }
            boolean augmentOnly = heldStack.m_41720_() instanceof AbstractAugmentItem;
            boolean isEmpty = heldStack.m_41619_();
            if (augmentOnly || isEmpty && this.inventory.isEmpty() && this.spiritInventory.isEmpty()) {
                boolean isCoreAugment = heldStack.m_41720_() instanceof AbstractCoreAugmentItem;
                if ((augmentOnly && !isCoreAugment || isEmpty) && !(stack = this.augmentInventory.interact(player.m_9236_(), player, hand)).m_41619_()) {
                    this.recalibrateAccelerators(this.f_58857_, this.f_58858_);
                    return InteractionResult.SUCCESS;
                }
                if ((augmentOnly && isCoreAugment || isEmpty) && !(stack = this.coreAugmentInventory.interact(player.m_9236_(), player, hand)).m_41619_()) {
                    this.recalibrateAccelerators(this.f_58857_, this.f_58858_);
                    return InteractionResult.SUCCESS;
                }
            }
            this.recalibrateAccelerators(this.f_58857_, this.f_58858_);
            if (!augmentOnly) {
                ItemStack spiritStack = this.spiritInventory.interact(this.f_58857_, player, hand);
                if (!spiritStack.m_41619_()) {
                    return InteractionResult.SUCCESS;
                }
                if (!(heldStack.m_41720_() instanceof SpiritShardItem) && !(stack = this.inventory.interact(this.f_58857_, player, hand)).m_41619_()) {
                    return InteractionResult.SUCCESS;
                }
            }
            if (isEmpty) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.onUse(player, hand);
    }

    public void onBreak(@Nullable Player player) {
        this.inventory.dumpItems(this.f_58857_, this.f_58858_);
        this.spiritInventory.dumpItems(this.f_58857_, this.f_58858_);
        this.augmentInventory.dumpItems(this.f_58857_, this.f_58858_);
        super.onBreak(player);
    }

    public void init() {
        if (this.f_58857_.f_46443_ && this.recipe == null) {
            CrucibleSoundInstance.playSound(this);
        }
        this.recipe = SpiritFocusingRecipe.getRecipe(this.f_58857_, this.inventory.getStackInSlot(0), this.spiritInventory.nonEmptyItemStacks);
    }

    public void tick() {
        super.tick();
        this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.nonEmptyItemAmount));
        if (this.queuedCracks > 0) {
            ++this.crackTimer;
            if (this.crackTimer % 5 == 0) {
                if (this.crackTimer >= 15) {
                    this.crackTimer = 0;
                }
                float pitch = 0.95f + (float)(this.crackTimer - 8) * 0.015f + this.f_58857_.f_46441_.m_188501_() * 0.05f;
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.IMPETUS_CRACK.get(), SoundSource.BLOCKS, 0.7f, pitch);
                --this.queuedCracks;
                if (this.queuedCracks == 0) {
                    this.crackTimer = 0;
                }
            }
        }
        float speed = this.acceleratorData.focusingSpeed.getValue(this.acceleratorData);
        if (!this.f_58857_.f_46443_) {
            if (this.recipe != null) {
                boolean needsRecalibration;
                boolean bl = needsRecalibration = !this.acceleratorData.accelerators.stream().allMatch(ICrucibleAccelerator::canContinueAccelerating);
                if (needsRecalibration) {
                    this.recalibrateAccelerators(this.f_58857_, this.f_58858_);
                    BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                }
                this.progress += speed;
                if (this.progress >= (float)this.recipe.time) {
                    this.craft();
                }
            } else {
                this.progress = 0.0f;
            }
        } else {
            this.spiritSpin += 1.0f + speed * 0.1f;
            SpiritCrucibleParticleEffects.passiveCrucibleParticles(this);
        }
    }

    public void craft() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        ItemStack outputStack = this.recipe.output.m_41777_();
        Vec3 itemPos = this.getItemPos();
        RandomSource random = this.f_58857_.f_46441_;
        float processingSpeed = this.acceleratorData.focusingSpeed.getValue(this.acceleratorData);
        float damageChance = this.acceleratorData.damageChance.getValue(this.acceleratorData);
        float bonusYieldChance = this.acceleratorData.bonusYieldChance.getValue(this.acceleratorData);
        float instantCompletionChance = this.acceleratorData.chainFocusingChance.getValue(this.acceleratorData);
        float completeDamageNegationChance = this.acceleratorData.damageAbsorptionChance.getValue(this.acceleratorData);
        float restorationChance = this.acceleratorData.restorationChance.getValue(this.acceleratorData);
        if (random.m_188501_() < restorationChance) {
            stack.m_41721_(Math.max(stack.m_41773_() - this.recipe.durabilityCost * 4, 0));
        }
        if (completeDamageNegationChance == 0.0f || random.m_188501_() < completeDamageNegationChance) {
            if (this.recipe.durabilityCost != 0 && stack.m_41763_()) {
                Item item;
                int durabilityCost = this.recipe.durabilityCost;
                if (damageChance > 0.0f && random.m_188501_() < damageChance) {
                    durabilityCost *= 2;
                }
                this.queuedCracks += durabilityCost;
                boolean success = stack.m_220157_(durabilityCost, random, null);
                if (success && (item = stack.m_41720_()) instanceof ImpetusItem) {
                    ImpetusItem impetusItem = (ImpetusItem)item;
                    this.inventory.setStackInSlot(0, impetusItem.getCrackedVariant().m_7968_());
                }
            }
        } else {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.SHIELDING_APPARATUS_SHIELDS.get(), SoundSource.BLOCKS, 0.5f, 0.25f + random.m_188501_() * 0.25f);
        }
        block0: for (SpiritWithCount spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.m_41774_(spirit.count);
                continue block0;
            }
        }
        this.spiritInventory.updateData();
        boolean instantCompletion = instantCompletionChance > 0.0f && random.m_188501_() < instantCompletionChance;
        float f = this.progress = instantCompletion ? (float)this.recipe.time - 10.0f * processingSpeed : 0.0f;
        if (instantCompletion) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.WARPING_ENGINE_REVERBERATES.get(), SoundSource.BLOCKS, 1.5f, 1.0f + random.m_188501_() * 0.25f);
        }
        this.acceleratorData.globalAttributeModifier = instantCompletion ? this.acceleratorData.globalAttributeModifier + 0.2f : 0.0f;
        ParticleEffectTypeRegistry.SPIRIT_CRUCIBLE_CRAFTS.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), ColorEffectData.fromRecipe(this.recipe.spirits));
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.CRUCIBLE_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 0.75f + random.m_188501_() * 0.5f);
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, outputStack));
        while (bonusYieldChance > 0.0f) {
            if (bonusYieldChance >= 1.0f || random.m_188501_() < bonusYieldChance) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, outputStack.m_41777_()));
            }
            bonusYieldChance -= 1.0f;
        }
        this.recipe = SpiritFocusingRecipe.getRecipe(this.f_58857_, stack, this.spiritInventory.nonEmptyItemStacks);
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    @Override
    public Vec3 getAccelerationPoint() {
        return this.getItemPos();
    }

    @Override
    public List<ItemStack> getAugments() {
        return this.augmentInventory.nonEmptyItemStacks;
    }

    @Override
    public ItemStack getCoreAugment() {
        return this.coreAugmentInventory.getStackInSlot(0);
    }

    @Override
    public boolean canBeAccelerated() {
        return !this.m_58901_() && this.recipe != null;
    }

    @Override
    public CrucibleAccelerationData getAccelerationData() {
        return this.acceleratorData;
    }

    @Override
    public void setAccelerationData(CrucibleAccelerationData data) {
        this.acceleratorData = data;
    }

    @Override
    public CrucibleTuning.CrucibleAttributeType getTuningType() {
        return this.tuningType;
    }

    @Override
    public MalumSpiritType getActiveSpiritType() {
        int spiritCount = this.spiritInventory.nonEmptyItemAmount;
        Item currentItem = this.spiritInventory.getStackInSlot(0).m_41720_();
        if (spiritCount > 1) {
            float duration = 60.0f * (float)spiritCount;
            float gameTime = (float)this.m_58904_().m_46467_() % duration / 60.0f;
            currentItem = this.spiritInventory.getStackInSlot(Mth.m_14143_((float)gameTime)).m_41720_();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem.type;
    }

    @Override
    public Vec3 getItemPos(float partialTicks) {
        BlockPos blockPos = this.m_58899_();
        Vec3 offset = this.getCentralItemOffset();
        return new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
    }

    @Override
    public BlockPos getAccessPointBlockPos() {
        return this.m_58899_();
    }

    @Override
    public LodestoneBlockEntityInventory getSuppliedInventory() {
        return this.inventory;
    }

    public Vec3 getCentralItemOffset() {
        return CRUCIBLE_ITEM_OFFSET;
    }

    public Vec3 getSpiritItemOffset(int slot, float partialTicks) {
        float distance = 0.75f + (float)Math.sin((this.spiritSpin + partialTicks) % 6.28f / 20.0f) * 0.025f;
        float height = 1.8f;
        return DataHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (long)((long)(this.spiritSpin + partialTicks)), (float)360.0f);
    }

    public Vec3 getAugmentItemOffset(int slot, float partialTicks) {
        float distance = 0.6f + (float)Math.sin((this.spiritSpin + partialTicks) % 6.28f / 20.0f) * 0.025f;
        float height = 1.6f;
        return DataHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.augmentInventory.slotCount, (long)((long)(this.spiritSpin + partialTicks)), (float)240.0f);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.combinedInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.f_58858_;
        return new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 4), (double)(pos.m_123343_() + 1));
    }
}

