/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Vector3f;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class RenderUtils {
    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, Color primaryColor, Color secondaryColor, float effectScalar, float partialTicks) {
        RenderUtils.renderEntityTrail(poseStack, builder, trailPointBuilder, entity, (Float t) -> primaryColor, (Float t) -> secondaryColor, effectScalar, effectScalar, partialTicks);
    }

    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, Function<Float, Color> primaryColor, Function<Float, Color> secondaryColor, float effectScalar, float partialTicks) {
        RenderUtils.renderEntityTrail(poseStack, builder, trailPointBuilder, entity, primaryColor, secondaryColor, effectScalar, effectScalar, partialTicks);
    }

    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, Color primaryColor, Color secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        RenderUtils.renderEntityTrail(poseStack, builder, trailPointBuilder, entity, (Float t) -> primaryColor, (Float t) -> secondaryColor, scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, Function<Float, Color> primaryColor, Function<Float, Color> secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        List spinningTrailPoints = trailPointBuilder.getTrailPoints();
        poseStack.m_85836_();
        float trailOffsetX = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        float trailOffsetY = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
        float trailOffsetZ = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        if (spinningTrailPoints.size() >= 2) {
            poseStack.m_252880_(-trailOffsetX, -trailOffsetY, -trailOffsetZ);
            for (int i = 0; i < 2; ++i) {
                float size = (0.2f + (float)i * 0.2f) * scaleScalar;
                float alpha = (0.7f - (float)i * 0.35f) * alphaScalar;
                builder.setAlpha(alpha).renderTrail(poseStack, spinningTrailPoints, f -> Float.valueOf(size), f -> builder.setAlpha(alpha * f.floatValue()).setColor(ColorHelper.colorLerp((Easing)Easing.SINE_IN, (float)(f.floatValue() * 2.0f), (Color)((Color)secondaryColor.apply((Float)f)), (Color)((Color)primaryColor.apply((Float)f))))).renderTrail(poseStack, spinningTrailPoints, f -> Float.valueOf(1.5f * size), f -> builder.setAlpha(alpha * f.floatValue() / 2.0f).setColor(ColorHelper.colorLerp((Easing)Easing.SINE_IN, (float)(f.floatValue() * 1.5f), (Color)((Color)secondaryColor.apply((Float)f)), (Color)((Color)primaryColor.apply((Float)f))))).renderTrail(poseStack, spinningTrailPoints, f -> Float.valueOf(size * 2.5f), f -> builder.setAlpha(alpha * f.floatValue() / 4.0f).setColor(ColorHelper.colorLerp((Easing)Easing.SINE_IN, (float)(f.floatValue() * 1.5f), (Color)((Color)secondaryColor.apply((Float)f)), (Color)((Color)primaryColor.apply((Float)f)))));
            }
            poseStack.m_252880_(trailOffsetX, trailOffsetY, trailOffsetZ);
        }
        poseStack.m_85849_();
    }

    public static void drawCube(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, float scale, CubeVertexData cubeVertexData) {
        RenderUtils.drawCube(poseStack, builder, builder, scale, cubeVertexData);
    }

    public static void drawCube(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, VFXBuilders.WorldVFXBuilder sideBuilder, float scale, CubeVertexData cubeVertexData) {
        Vector3f[] bottomVertices = cubeVertexData.bottomVertices;
        Vector3f[] topVertices = cubeVertexData.topVertices;
        Collection<Vector3f[]> offsetMap = cubeVertexData.offsetMap;
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        for (Vector3f[] offsets : offsetMap) {
            RenderUtils.drawSide(poseStack, sideBuilder, offsets);
        }
        RenderUtils.drawSide(poseStack, builder, new Vector3f[]{bottomVertices[3], bottomVertices[2], bottomVertices[1], bottomVertices[0]});
        RenderUtils.drawSide(poseStack, builder, topVertices);
        poseStack.m_85849_();
    }

    public static void drawSide(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, Vector3f[] offsets) {
        builder.renderQuad(poseStack, offsets, 1.0f);
    }

    public static CubeVertexData makeCubePositions(float scale) {
        return RenderUtils.makeCubePositions(scale, scale);
    }

    public static CubeVertexData makeCubePositions(float xScale, float yScale) {
        float half = 0.5f;
        float xOffset = xScale / 2.0f;
        float yOffset = yScale / 2.0f;
        float xStart = -xOffset + half;
        float xEnd = xOffset + half;
        float yStart = -yOffset + half;
        float yEnd = yOffset + half;
        Vector3f[] bottomVertices = new Vector3f[]{new Vector3f(xStart, yStart, xStart), new Vector3f(xStart, yStart, xEnd), new Vector3f(xEnd, yStart, xEnd), new Vector3f(xEnd, yStart, xStart)};
        Vector3f[] topVertices = new Vector3f[]{new Vector3f(xStart, yEnd, xStart), new Vector3f(xStart, yEnd, xEnd), new Vector3f(xEnd, yEnd, xEnd), new Vector3f(xEnd, yEnd, xStart)};
        ArrayList<Vector3f[]> offsetMap = new ArrayList<Vector3f[]>();
        for (int i = 0; i < 4; ++i) {
            offsetMap.add(new Vector3f[]{bottomVertices[i], bottomVertices[(i + 1) % 4], topVertices[(i + 1) % 4], topVertices[i % 4]});
        }
        return new CubeVertexData(bottomVertices, topVertices, offsetMap);
    }

    public record CubeVertexData(Vector3f[] bottomVertices, Vector3f[] topVertices, Collection<Vector3f[]> offsetMap) {
        public CubeVertexData applyWobble(float sineOffset, float strength) {
            return this.applyWobble(sineOffset, sineOffset, strength);
        }

        public CubeVertexData applyWobble(float bottomSineOffset, float topSineOffset, float strength) {
            this.applyWobble(this.bottomVertices, bottomSineOffset, strength);
            this.applyWobble(this.topVertices, topSineOffset, strength);
            return this.applyWobble(this.bottomVertices, bottomSineOffset, strength).applyWobble(this.topVertices, topSineOffset, strength);
        }

        public CubeVertexData applyWobble(Vector3f[] offsets, float sineOffset, float strength) {
            float offset = sineOffset;
            for (Vector3f vector3f : offsets) {
                double time = (double)((float)Minecraft.m_91087_().f_91073_.m_46467_() / 40.0f) % Math.PI * 2.0;
                float sine = Mth.m_14031_((float)((float)(time + (double)offset * Math.PI * 2.0))) * strength;
                vector3f.add(sine, -sine, sine);
                offset += 0.25f;
            }
            return this;
        }

        public CubeVertexData stretch(float scale) {
            return this.stretch(scale, scale);
        }

        public CubeVertexData stretch(float width, float height) {
            return this.stretch(width, height, width);
        }

        public CubeVertexData stretch(float x, float y, float z) {
            for (int i = 0; i < this.bottomVertices.length; ++i) {
                this.bottomVertices[i].mul(x, y, z);
                this.topVertices[i].mul(x, y, z);
            }
            return this;
        }

        public CubeVertexData constrict(float scale) {
            return this.constrict(scale, scale);
        }

        public CubeVertexData constrict(float width, float height) {
            return this.constrict(width, height, width);
        }

        public CubeVertexData constrict(float x, float y, float z) {
            for (int i = 0; i < this.bottomVertices.length; ++i) {
                this.bottomVertices[i].div(x, y, z);
                this.topVertices[i].div(x, y, z);
            }
            return this;
        }

        public CubeVertexData offset(float x, float y, float z) {
            for (int i = 0; i < this.bottomVertices.length; ++i) {
                this.bottomVertices[i].add(x, y, z);
                this.topVertices[i].add(x, y, z);
            }
            return this;
        }
    }
}

