/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.shield;

import com.google.common.collect.Multimap;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.shield.ApplyBannerSchematic;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldRenderer;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.properties.TetraAttributes;

@ParametersAreNonnullByDefault
public class ModularShieldItem
extends ItemModularHandheld {
    public static final String plateKey = "shield/plate";
    public static final String gripKey = "shield/grip";
    public static final String bossKey = "shield/boss";
    public static final String identifier = "modular_shield";
    public static final String bannerImprovementKey = "shield/banner";
    @ObjectHolder(registryName="item", value="tetra:modular_shield")
    public static ModularShieldItem instance;

    public ModularShieldItem() {
        super(new Item.Properties().m_41487_(1).m_41486_());
        this.majorModuleKeys = new String[]{plateKey, gripKey};
        this.minorModuleKeys = new String[]{bossKey};
        this.requiredModules = new String[]{plateKey, gripKey};
        this.updateConfig((Integer)ConfigHandler.honeShieldBase.get(), (Integer)ConfigHandler.honeShieldIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this, identifier));
        SchematicRegistry.instance.registerSchematic(new ApplyBannerSchematic());
        ItemUpgradeRegistry.instance.registerReplacementHook(this::copyBanner);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        final NonNullLazy renderer = NonNullLazy.of(() -> new ModularShieldRenderer(Minecraft.m_91087_()));
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)renderer.get();
            }
        });
    }

    @Override
    public void commonInit(PacketHandler packetHandler) {
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.synergyData.getOrdered("shield/");
        });
    }

    @Override
    public void clientInit() {
        super.clientInit();
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("blocking"), (itemStack, world, entity, i) -> this.isBlocking(itemStack, entity) ? 1.0f : 0.0f);
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("throwing"), (itemStack, world, entity, i) -> this.isThrowing(itemStack, entity) ? 1.0f : 0.0f);
    }

    private ItemStack copyBanner(ItemStack original, ItemStack replacement) {
        if (this.equals(replacement.m_41720_())) {
            Optional.ofNullable(original.m_41737_("BlockEntityTag")).ifPresent(tag -> {
                replacement.m_41784_().m_128365_("BlockEntityTag", (Tag)tag);
                CastOptional.cast((Object)this.getModuleFromSlot(replacement, plateKey), ItemModuleMajor.class).filter(module -> module.acceptsImprovement(bannerImprovementKey)).ifPresent(module -> module.addImprovement(replacement, bannerImprovementKey, 0));
            });
        }
        return replacement;
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack itemStack) {
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            return this.getAttributeModifiersCached(itemStack);
        }
        return AttributeHelper.emptyMap;
    }

    @Override
    public double getAbilityBaseDamage(ItemStack itemStack) {
        return this.getAttributeValue(itemStack, (Attribute)TetraAttributes.abilityDamage.get());
    }

    @Override
    public double getCooldownBase(ItemStack itemStack) {
        return this.getAttributeValue(itemStack, (Attribute)TetraAttributes.abilityCooldown.get());
    }
}

