/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.aspect;

import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.tuple.Pair;
import se.mickelus.tetra.aspect.ItemAspect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;

public class TetraEnchantmentHelper {
    private static final Map<ItemAspect, EnchantmentRules> aspectMap = HashBiMap.create();

    public static void init() {
        aspectMap.put(ItemAspect.armor, new EnchantmentRules("additions/armor", "exclusions/armor", EnchantmentCategory.ARMOR));
        aspectMap.put(ItemAspect.armorFeet, new EnchantmentRules("additions/armor_feet", "exclusions/armor_feet", EnchantmentCategory.ARMOR_FEET));
        aspectMap.put(ItemAspect.armorLegs, new EnchantmentRules("additions/armor_legs", "exclusions/armor_legs", EnchantmentCategory.ARMOR_LEGS));
        aspectMap.put(ItemAspect.armorChest, new EnchantmentRules("additions/armor_chest", "exclusions/armor_chest", EnchantmentCategory.ARMOR_CHEST));
        aspectMap.put(ItemAspect.armorHead, new EnchantmentRules("additions/armor_head", "exclusions/armor_head", EnchantmentCategory.ARMOR_HEAD));
        aspectMap.put(ItemAspect.edgedWeapon, new EnchantmentRules("additions/edged_weapon", "exclusions/edged_weapon", EnchantmentCategory.WEAPON, TetraEnchantmentHelper.fromName("SWORD_OR_AXE")));
        aspectMap.put(ItemAspect.bluntWeapon, new EnchantmentRules("additions/blunt_weapon", "exclusions/blunt_weapon", EnchantmentCategory.WEAPON));
        aspectMap.put(ItemAspect.pointyWeapon, new EnchantmentRules("additions/pointy_weapon", "exclusions/pointy_weapon", EnchantmentCategory.TRIDENT));
        aspectMap.put(ItemAspect.throwable, new EnchantmentRules("additions/throwable", "exclusions/throwable", new EnchantmentCategory[]{null}));
        aspectMap.put(ItemAspect.blockBreaker, new EnchantmentRules("additions/block_breaker", "exclusions/block_breaker", EnchantmentCategory.DIGGER));
        aspectMap.put(ItemAspect.fishingRod, new EnchantmentRules("additions/fishing_rod", "exclusions/fishing_rod", EnchantmentCategory.FISHING_ROD));
        aspectMap.put(ItemAspect.breakable, new EnchantmentRules("additions/breakable", "exclusions/breakable", EnchantmentCategory.BREAKABLE));
        aspectMap.put(ItemAspect.bow, new EnchantmentRules("additions/bow", "exclusions/bow", EnchantmentCategory.BOW));
        aspectMap.put(ItemAspect.wearable, new EnchantmentRules("additions/wearable", "exclusions/wearable", EnchantmentCategory.WEARABLE));
        aspectMap.put(ItemAspect.crossbow, new EnchantmentRules("additions/crossbow", "exclusions/crossbow", EnchantmentCategory.CROSSBOW));
        aspectMap.put(ItemAspect.vanishable, new EnchantmentRules("additions/vanishable", "exclusions/vanishable", EnchantmentCategory.VANISHABLE));
    }

    private static EnchantmentCategory fromName(String enchantmentCategoryName) {
        try {
            return EnchantmentCategory.valueOf((String)enchantmentCategoryName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static void registerMapping(ItemAspect aspect, @Nullable EnchantmentCategory category, String additions, String exclusions) {
        TetraEnchantmentHelper.registerMapping(aspect, new EnchantmentRules(additions, exclusions, category));
    }

    public static void registerMapping(ItemAspect aspect, EnchantmentRules rules) {
        aspectMap.put(aspect, rules);
    }

    public static boolean isApplicableForAspects(Enchantment enchantment, boolean fromTable, Map<ItemAspect, Integer> aspects) {
        int requiredLevel = fromTable ? 2 : 1;
        return aspects.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= requiredLevel).filter(entry -> aspectMap.containsKey(entry.getKey())).anyMatch(entry -> aspectMap.get(entry.getKey()).isApplicable(enchantment));
    }

    public static EnchantmentCategory[] getEnchantmentCategories(ItemAspect aspect) {
        return TetraEnchantmentHelper.aspectMap.get((Object)aspect).categories;
    }

    public static ItemStack removeAllEnchantments(ItemStack itemStack) {
        itemStack.m_41749_("Enchantments");
        itemStack.m_41749_("StoredEnchantments");
        itemStack.m_41749_("EnchantmentMapping");
        IModularItem.updateIdentifier(itemStack);
        return itemStack;
    }

    public static ItemStack transferReplacementEnchantments(ItemStack original, ItemStack replacementStack) {
        Optional.ofNullable(original.m_41783_()).map(tag -> tag.m_128437_("Enchantments", 10)).filter(enchantments -> enchantments.size() > 0).ifPresent(enchantments -> {
            replacementStack.m_41784_().m_128365_("Enchantments", (Tag)enchantments.m_6426_());
            TetraEnchantmentHelper.mapEnchantments(replacementStack);
        });
        return replacementStack;
    }

    public static void applyEnchantment(ItemStack itemStack, String slot, Enchantment enchantment, int level) {
        itemStack.m_41663_(enchantment, level);
        TetraEnchantmentHelper.mapEnchantment(itemStack, slot, enchantment);
    }

    public static void mapEnchantment(ItemStack itemStack, String slot, Enchantment enchantment) {
        CompoundTag map = itemStack.m_41698_("EnchantmentMapping");
        map.m_128359_(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString(), slot);
    }

    public static void mapEnchantments(ItemStack itemStack) {
        CompoundTag mappings = itemStack.m_41698_("EnchantmentMapping");
        Map mapped = Optional.of(mappings).map(CompoundTag::m_128431_).stream().flatMap(Collection::stream).collect(Collectors.toMap(Function.identity(), arg_0 -> ((CompoundTag)mappings).m_128461_(arg_0)));
        Map<String, Integer> capacity = Arrays.stream(((IModularItem)itemStack.m_41720_()).getMajorModules(itemStack)).filter(Objects::nonNull).collect(Collectors.toMap(ItemModule::getSlot, module -> module.getMagicCapacity(itemStack)));
        List<Pair> unmapped = Optional.of(itemStack.m_41785_()).stream().flatMap(Collection::stream).map(nbt -> (CompoundTag)nbt).map(nbt -> Pair.of((Object)nbt.m_128461_("id"), (Object)nbt.m_128451_("lvl"))).filter(pair -> !mapped.containsKey(pair.getKey())).collect(Collectors.toList());
        ItemModuleMajor[] modules = ((IModularItem)itemStack.m_41720_()).getMajorModules(itemStack);
        unmapped.forEach(pair -> {
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation((String)pair.getKey()));
            if (enchantment != null) {
                Arrays.stream(modules).filter(Objects::nonNull).filter(module -> module.acceptsEnchantment(itemStack, enchantment, false)).map(ItemModule::getSlot).max(Comparator.comparing(slot -> capacity.getOrDefault(slot, 0))).ifPresent(slot -> {
                    TetraEnchantmentHelper.mapEnchantment(itemStack, slot, enchantment);
                    int cost = TetraEnchantmentHelper.getEnchantmentCapacityCost(enchantment, (Integer)pair.getRight());
                    capacity.merge((String)slot, cost, Integer::sum);
                });
            }
        });
    }

    @Nullable
    public static Pair<String, Integer> getEnchantmentPrimitive(CompoundTag nbt) {
        return Pair.of((Object)nbt.m_128461_("id"), (Object)nbt.m_128451_("lvl"));
    }

    @Nullable
    public static Pair<Enchantment, Integer> getEnchantment(CompoundTag nbt) {
        return Optional.ofNullable((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(nbt.m_128461_("id")))).map(enchantment -> Pair.of((Object)enchantment, (Object)nbt.m_128451_("lvl"))).orElse(null);
    }

    public static int getEnchantmentCapacityCost(Enchantment enchantment, int level) {
        return -(enchantment.m_6175_(level) + enchantment.m_6183_(level)) / 2;
    }

    public static void removeEnchantment(ItemStack itemStack, Enchantment enchantment) {
        Optional.ofNullable(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment)).ifPresent(enchantmentKey -> TetraEnchantmentHelper.removeEnchantment(itemStack, enchantmentKey.toString()));
    }

    public static void removeEnchantment(ItemStack itemStack, String enchantment) {
        Optional.ofNullable(itemStack.m_41737_("EnchantmentMapping")).ifPresent(map -> map.m_128473_(enchantment));
        Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128437_("Enchantments", 10)).ifPresent(enchantments -> enchantments.removeIf(nbt -> enchantment.equals(((CompoundTag)nbt).m_128461_("id"))));
    }

    public static void removeEnchantments(ItemStack itemStack, String slot) {
        CompoundTag map = itemStack.m_41737_("EnchantmentMapping");
        ListTag enchantments = Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128437_("Enchantments", 10)).orElse(null);
        if (map != null && enchantments != null) {
            Set<String> matchingEnchantments = map.m_128431_().stream().filter(ench -> slot.equals(map.m_128461_(ench))).collect(Collectors.toSet());
            enchantments.removeIf(nbt -> matchingEnchantments.contains(((CompoundTag)nbt).m_128461_("id")));
            matchingEnchantments.forEach(arg_0 -> ((CompoundTag)map).m_128473_(arg_0));
        }
    }

    public static String getEnchantmentTooltip(Enchantment enchantment, int level, boolean clearFormatting) {
        if (clearFormatting) {
            return ChatFormatting.m_126649_((String)TetraEnchantmentHelper.getEnchantmentName(enchantment, level));
        }
        return TetraEnchantmentHelper.getEnchantmentName(enchantment, level);
    }

    public static String getEnchantmentName(Enchantment enchantment, int level) {
        return enchantment.m_44700_(level).getString();
    }

    public static String getEnchantmentDescription(Enchantment enchantment) {
        return Optional.of(enchantment.m_44704_() + ".desc").filter(I18n::m_118936_).map(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0])).orElse(null);
    }

    public static class EnchantmentRules {
        EnchantmentCategory[] categories;
        TagKey<Enchantment> exclusions;
        TagKey<Enchantment> additions;

        public EnchantmentRules(String additions, String exclusions, EnchantmentCategory ... categories) {
            this.categories = (EnchantmentCategory[])Arrays.stream(categories).filter(Objects::nonNull).toArray(EnchantmentCategory[]::new);
            ITagManager tags = ForgeRegistries.ENCHANTMENTS.tags();
            this.additions = tags.createTagKey(new ResourceLocation("tetra", additions));
            this.exclusions = tags.createTagKey(new ResourceLocation("tetra", exclusions));
        }

        public boolean isApplicable(Enchantment enchantment) {
            ITagManager tags = ForgeRegistries.ENCHANTMENTS.tags();
            return (Arrays.asList(this.categories).contains(enchantment.f_44672_) || tags.getTag(this.additions).contains((Object)enchantment)) && !tags.getTag(this.exclusions).contains((Object)enchantment);
        }
    }
}

