/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.util;

import com.obscuria.obscureapi.api.ClassManager;
import com.obscuria.obscureapi.api.common.classes.Ability;
import com.obscuria.obscureapi.api.common.classes.Bonus;
import com.obscuria.obscureapi.api.common.classes.ClassAbility;
import com.obscuria.obscureapi.api.common.classes.ClassBonus;
import com.obscuria.obscureapi.api.common.classes.ClassItem;
import com.obscuria.obscureapi.api.common.classes.ObscureClass;
import com.obscuria.obscureapi.api.common.classes.ObscureType;
import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ClassUtils {
    public static boolean isClassItem(ItemStack stack) {
        return ByAnnotation.isClassItem(stack.m_41720_()) || ByTag.isClassItem(stack);
    }

    public static boolean isClassItem(Item item) {
        return ByAnnotation.isClassItem(item);
    }

    public static boolean isClassItem(Class<? extends Item> item) {
        return ByAnnotation.isClassItem(item);
    }

    public static ObscureClass getItemClass(ItemStack stack) {
        if (ByAnnotation.isClassItem(stack.m_41720_())) {
            return ByAnnotation.getItemClass(stack.m_41720_());
        }
        if (ByTag.isClassItem(stack)) {
            return ByTag.getItemClass(stack);
        }
        return ClassManager.BLANK;
    }

    public static ObscureClass getItemClass(Item item) {
        if (ByAnnotation.isClassItem(item)) {
            return ByAnnotation.getItemClass(item);
        }
        return ClassManager.BLANK;
    }

    public static ObscureClass getItemClass(Class<? extends Item> item) {
        if (ByAnnotation.isClassItem(item)) {
            return ByAnnotation.getItemClass(item);
        }
        return ClassManager.BLANK;
    }

    public static ObscureType getItemType(ItemStack stack) {
        if (ByAnnotation.isClassItem(stack.m_41720_())) {
            return ByAnnotation.getItemType(stack.m_41720_());
        }
        if (ByTag.isClassItem(stack)) {
            return ByTag.getItemType(stack);
        }
        return ObscureType.create("null");
    }

    public static ObscureType getItemType(Item item) {
        if (ByAnnotation.isClassItem(item)) {
            return ByAnnotation.getItemType(item);
        }
        return ObscureType.create("null");
    }

    public static ObscureType getItemType(Class<? extends Item> item) {
        if (ByAnnotation.isClassItem(item)) {
            return ByAnnotation.getItemType(item);
        }
        return ObscureType.create("null");
    }

    public static boolean hasBonuses(ItemStack stack) {
        return ByAnnotation.isClassItem(stack.m_41720_()) && !ByAnnotation.getBonuses(stack.m_41720_()).isEmpty();
    }

    public static boolean hasBonuses(Item item) {
        return ByAnnotation.isClassItem(item) && !ByAnnotation.getBonuses(item).isEmpty();
    }

    public static boolean hasVisibleBonuses(ItemStack stack) {
        return ByAnnotation.isClassItem(stack.m_41720_()) && !ByAnnotation.getVisibleBonuses(stack.m_41720_()).isEmpty();
    }

    public static boolean hasVisibleBonuses(Item item) {
        return ByAnnotation.isClassItem(item) && !ByAnnotation.getVisibleBonuses(item).isEmpty();
    }

    public static List<Bonus> getBonuses(ItemStack stack) {
        return ByAnnotation.getBonuses(stack.m_41720_());
    }

    public static List<Bonus> getBonuses(Item item) {
        return ByAnnotation.getBonuses(item);
    }

    public static List<Bonus> getVisibleBonuses(ItemStack stack) {
        return ByAnnotation.getVisibleBonuses(stack.m_41720_());
    }

    public static List<Bonus> getVisibleBonuses(Item item) {
        return ByAnnotation.getVisibleBonuses(item);
    }

    public static boolean hasAbilities(Item item) {
        return ByAnnotation.isClassItem(item) && !ByAnnotation.getAbilities(item).isEmpty();
    }

    public static boolean hasVisibleAbilities(Item item) {
        return ByAnnotation.isClassItem(item) && !ByAnnotation.getVisibleAbilities(item).isEmpty();
    }

    public static List<Ability> getAbilities(Item item) {
        return ByAnnotation.getAbilities(item);
    }

    public static List<Ability> getVisibleAbilities(Item item) {
        return ByAnnotation.getVisibleAbilities(item);
    }

    protected static class ByAnnotation {
        protected ByAnnotation() {
        }

        public static boolean isClassItem(Item item) {
            return item.getClass().isAnnotationPresent(ClassItem.class);
        }

        public static boolean isClassItem(Class<? extends Item> item) {
            return item.isAnnotationPresent(ClassItem.class);
        }

        public static ObscureClass getItemClass(Item item) {
            return ExceptionFilter.getNoNull(ClassManager.BLANK, () -> ClassManager.get(new ResourceLocation(item.getClass().getAnnotation(ClassItem.class).clazz())));
        }

        public static ObscureClass getItemClass(Class<? extends Item> item) {
            return ExceptionFilter.getNoNull(ClassManager.BLANK, () -> ClassManager.get(new ResourceLocation(item.getAnnotation(ClassItem.class).clazz())));
        }

        public static ObscureType getItemType(Item item) {
            return ExceptionFilter.getNoNull(ObscureType.create("null"), () -> ObscureType.create(item.getClass().getAnnotation(ClassItem.class).type()));
        }

        public static ObscureType getItemType(Class<? extends Item> item) {
            return ExceptionFilter.getNoNull(ObscureType.create("null"), () -> ObscureType.create(item.getAnnotation(ClassItem.class).type()));
        }

        public static List<Bonus> getBonuses(Item item) {
            ArrayList<Bonus> bonuses = new ArrayList<Bonus>();
            for (Field field : item.getClass().getFields()) {
                if (!field.isAnnotationPresent(ClassBonus.class) || !field.getType().isAssignableFrom(Bonus.class)) continue;
                try {
                    bonuses.add(0, (Bonus)field.get(item));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return bonuses;
        }

        public static List<Bonus> getVisibleBonuses(Item item) {
            ArrayList<Bonus> bonuses = new ArrayList<Bonus>();
            for (Field field : item.getClass().getFields()) {
                if (!field.isAnnotationPresent(ClassBonus.class) || !field.getAnnotation(ClassBonus.class).visible() || !field.getType().isAssignableFrom(Bonus.class)) continue;
                try {
                    bonuses.add(0, (Bonus)field.get(item));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return bonuses;
        }

        public static List<Ability> getAbilities(Item item) {
            ArrayList<Ability> abilities = new ArrayList<Ability>();
            for (Field field : item.getClass().getFields()) {
                if (!field.isAnnotationPresent(ClassAbility.class) || !field.getType().isAssignableFrom(Ability.class)) continue;
                try {
                    abilities.add(0, (Ability)field.get(item));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return abilities;
        }

        public static List<Ability> getVisibleAbilities(Item item) {
            ArrayList<Ability> abilities = new ArrayList<Ability>();
            for (Field field : item.getClass().getFields()) {
                if (!field.isAnnotationPresent(ClassAbility.class) || !field.getAnnotation(ClassAbility.class).visible() || !field.getType().isAssignableFrom(Ability.class)) continue;
                try {
                    abilities.add(0, (Ability)field.get(item));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return abilities;
        }
    }

    protected static class ByTag {
        protected ByTag() {
        }

        public static boolean isClassItem(ItemStack stack) {
            return ExceptionFilter.equals(true, () -> stack.m_41783_().m_128441_("ObscureClass"));
        }

        public static ObscureClass getItemClass(ItemStack stack) {
            return ExceptionFilter.getNoNull(ClassManager.BLANK, () -> ClassManager.get(new ResourceLocation(stack.m_41783_().m_128469_("ObscureClass").m_128461_("Name"))));
        }

        public static ObscureType getItemType(ItemStack stack) {
            return ExceptionFilter.getNoNull(ObscureType.create("null"), () -> ObscureType.create(stack.m_41783_().m_128469_("ObscureClass").m_128461_("Type")));
        }
    }
}

