/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.renderer;

import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shadow.hypherionmc.mcdiscordformatter.minecraft.MinecraftSerializerOptions;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.TextStyle;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.Node;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.StyleNode;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.TextNode;
import shadow.hypherionmc.mcdiscordformatter.renderer.MinecraftNodeRenderer;
import shadow.hypherionmc.mcdiscordformatter.rules.DiscordMarkdownRules;

public interface MinecraftRenderer
extends MinecraftNodeRenderer {
    @Override
    default public MutableComponent render(MutableComponent MutableComponent2, Node<Object> node, MinecraftSerializerOptions<MutableComponent> serializerOptions, Function<Node<Object>, MutableComponent> renderWithChildren) {
        if (node instanceof TextNode) {
            MutableComponent2 = Component.m_237113_((String)((TextNode)node).getContent());
        } else if (node instanceof StyleNode) {
            ArrayList styles = new ArrayList(((StyleNode)node).getStyles());
            for (TextStyle style : styles) {
                switch (style.getType()) {
                    case STRIKETHROUGH: {
                        MutableComponent2 = this.strikethrough(MutableComponent2);
                        break;
                    }
                    case UNDERLINE: {
                        MutableComponent2 = this.underline(MutableComponent2);
                        break;
                    }
                    case ITALICS: {
                        MutableComponent2 = this.italics(MutableComponent2);
                        break;
                    }
                    case BOLD: {
                        MutableComponent2 = this.bold(MutableComponent2);
                        break;
                    }
                    case CODE_STRING: {
                        MutableComponent2 = this.codeString(MutableComponent2);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case CODE_BLOCK: {
                        MutableComponent2 = this.codeBlock(MutableComponent2);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case QUOTE: {
                        MutableComponent content = Component.m_237119_();
                        for (Node<Object> objectNode : serializerOptions.getParser().parse(style.getExtra().get("content"), new DiscordMarkdownRules.QuoteState(true), serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = content.m_7220_((Component)renderWithChildren.apply(objectNode));
                        }
                        MutableComponent2 = this.appendQuote(MutableComponent2, content);
                        break;
                    }
                    case SPOILER: {
                        MutableComponent content = Component.m_237119_();
                        for (Node<Object> objectNode : serializerOptions.getParser().parse(style.getExtra().get("content"), null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = content.m_7220_((Component)renderWithChildren.apply(objectNode));
                        }
                        MutableComponent2 = this.appendSpoiler(MutableComponent2, content);
                        break;
                    }
                    case MENTION_EMOJI: {
                        MutableComponent2 = this.appendEmoteMention(MutableComponent2, style.getExtra().get("name"), style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_CHANNEL: {
                        MutableComponent2 = this.appendChannelMention(MutableComponent2, style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_USER: {
                        MutableComponent2 = this.appendUserMention(MutableComponent2, style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_ROLE: {
                        MutableComponent2 = this.appendRoleMention(MutableComponent2, style.getExtra().get("id"));
                        break;
                    }
                }
            }
        }
        return MutableComponent2;
    }

    @Nullable
    public MutableComponent strikethrough(@NotNull MutableComponent var1);

    @Nullable
    public MutableComponent underline(@NotNull MutableComponent var1);

    @Nullable
    public MutableComponent italics(@NotNull MutableComponent var1);

    @Nullable
    public MutableComponent bold(@NotNull MutableComponent var1);

    @Nullable
    public MutableComponent codeString(@NotNull MutableComponent var1);

    @Nullable
    public MutableComponent codeBlock(@NotNull MutableComponent var1);

    @Nullable
    public MutableComponent appendSpoiler(@NotNull MutableComponent var1, @NotNull MutableComponent var2);

    @Nullable
    public MutableComponent appendQuote(@NotNull MutableComponent var1, @NotNull MutableComponent var2);

    @Nullable
    public MutableComponent appendEmoteMention(@NotNull MutableComponent var1, @NotNull String var2, @NotNull String var3);

    @Nullable
    public MutableComponent appendChannelMention(@NotNull MutableComponent var1, @NotNull String var2);

    @Nullable
    public MutableComponent appendUserMention(@NotNull MutableComponent var1, @NotNull String var2);

    @Nullable
    public MutableComponent appendRoleMention(@NotNull MutableComponent var1, @NotNull String var2);
}

