/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity;

import com.stal111.forbidden_arcanus.common.entity.CustomBoat;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class ModBoat
extends Boat
implements CustomBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_WOOD_TYPE = SynchedEntityData.m_135353_(ModBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public ModBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)ModEntities.BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_WOOD_TYPE, (Object)0);
    }

    protected void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Type", 8)) {
            this.setWoodType(Type.byName(tag.m_128461_("Type")));
        }
    }

    protected void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Type", this.getWoodType().m_7912_());
    }

    @Nonnull
    public Item m_38369_() {
        return (Item)this.getWoodType().getBoatItem().get();
    }

    @Override
    public Type getWoodType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_WOOD_TYPE));
    }

    @Override
    public void setWoodType(Type type) {
        this.f_19804_.m_135381_(DATA_ID_WOOD_TYPE, (Object)type.ordinal());
    }

    @Nonnull
    protected Component m_5677_() {
        return EntityType.f_20552_.m_20676_();
    }

    public static enum Type implements StringRepresentable
    {
        AURUM("aurum", (Supplier<BoatItem>)ModItems.AURUM_BOAT, (Supplier<BoatItem>)ModItems.AURUM_CHEST_BOAT),
        EDELWOOD("edelwood", (Supplier<BoatItem>)ModItems.EDELWOOD_BOAT, (Supplier<BoatItem>)ModItems.EDELWOOD_CHEST_BOAT);

        private final String name;
        private final Supplier<BoatItem> boatItem;
        private final Supplier<BoatItem> chestBoatItem;

        private Type(String name, Supplier<BoatItem> boatItem, Supplier<BoatItem> chestBoatItem) {
            this.name = name;
            this.boatItem = boatItem;
            this.chestBoatItem = chestBoatItem;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public Supplier<BoatItem> getBoatItem() {
            return this.boatItem;
        }

        public Supplier<BoatItem> getChestBoatItem() {
            return this.chestBoatItem;
        }

        public ResourceLocation getTexture(boolean hasChest) {
            if (hasChest) {
                return new ResourceLocation("forbidden_arcanus", "textures/entity/chest_boat/" + this.name + ".png");
            }
            return new ResourceLocation("forbidden_arcanus", "textures/entity/boat/" + this.name + ".png");
        }

        public String getModelLocation() {
            return "boat/" + this.name;
        }

        public String getChestModelLocation() {
            return "chest_boat/" + this.name;
        }

        public static Type byId(int id) {
            Type[] values = Type.values();
            if (id < 0 || id >= values.length) {
                id = 0;
            }
            return values[id];
        }

        public static Type byName(String name) {
            Type[] values;
            for (Type value : values = Type.values()) {
                if (!value.m_7912_().equals(name)) continue;
                return value;
            }
            return values[0];
        }
    }
}

