/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElementHelper;

public enum BrewingStandProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!accessor.getServerData().m_128425_("BrewingStand", 10)) {
            return;
        }
        CompoundTag tag = accessor.getServerData().m_128469_("BrewingStand");
        int fuel = tag.m_128451_("Fuel");
        int time = tag.m_128451_("Time");
        IElementHelper helper = IElementHelper.get();
        tooltip.add(helper.smallItem(new ItemStack((ItemLike)Items.f_42593_)));
        tooltip.append((Component)IThemeHelper.get().info(fuel));
        if (time > 0) {
            tooltip.append(helper.spacer(5, 0));
            tooltip.append(helper.smallItem(new ItemStack((ItemLike)Items.f_42524_)));
            tooltip.append((Component)IThemeHelper.get().seconds(time));
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)accessor.getBlockEntity();
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("Time", brewingStand.f_58976_);
        compound.m_128405_("Fuel", brewingStand.f_58979_);
        tag.m_128365_("BrewingStand", (Tag)compound);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_BREWING_STAND;
    }
}

