/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.discord;

import com.hypherionmc.simplerpc.api.rpc.RichPresenceBuilder;
import com.hypherionmc.simplerpc.api.rpc.RichPresenceContainer;
import com.hypherionmc.simplerpc.api.utils.APIUtils;
import com.hypherionmc.simplerpc.api.variables.PlaceholderEngine;
import com.hypherionmc.simplerpc.config.impl.ClientConfig;
import com.hypherionmc.simplerpc.config.impl.ReplayModConfig;
import com.hypherionmc.simplerpc.config.impl.ServerEntriesConfig;
import com.hypherionmc.simplerpc.config.objects.DimensionSection;
import com.hypherionmc.simplerpc.config.objects.ServerEntry;
import com.hypherionmc.simplerpc.discord.SimpleRPCCore;
import com.hypherionmc.simplerpc.enums.GameType;
import com.hypherionmc.simplerpc.enums.RichPresenceState;
import com.hypherionmc.simplerpc.rpcsdk.models.DiscordRichPresence;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class RichPresenceEvents {
    private final SimpleRPCCore core;
    private RichPresenceState rpcState = RichPresenceState.INIT;
    private GameType gameType = GameType.SINGLE;
    @Nullable
    private DiscordRichPresence customPresence = null;

    @ApiStatus.Internal
    RichPresenceEvents(SimpleRPCCore core) {
        this.core = core;
        this.setRPCState(RichPresenceState.INIT);
    }

    public void setRPCState(RichPresenceState state) {
        this.rpcState = state;
        this.updateRPC();
    }

    public void setRPCState(RichPresenceState state, GameType type) {
        this.gameType = type;
        this.setRPCState(state);
    }

    public void setCustomRPC(@Nullable RichPresenceBuilder newPresence) {
        this.rpcState = RichPresenceState.CUSTOM;
        this.customPresence = newPresence != null ? newPresence.getPresence() : null;
    }

    @ApiStatus.Internal
    void updateRPC() {
        ClientConfig clientConfig = this.core.getClientConfig();
        SimpleRPCCore.DiscordController discordHandler = this.core.getDiscordController();
        ReplayModConfig replayModConfig = SimpleRPCCore.replayModConfig;
        if (clientConfig == null || !clientConfig.general.enabled || discordHandler == null) {
            return;
        }
        if (this.rpcState == RichPresenceState.CUSTOM && this.customPresence != null) {
            discordHandler.updateRichPresence(this.customPresence);
            return;
        }
        if ((this.rpcState == RichPresenceState.REPLAY_BROWSER || this.rpcState == RichPresenceState.REPLAY_EDITOR || this.rpcState == RichPresenceState.REPLAY_RENDER) && replayModConfig != null && replayModConfig.enabled) {
            switch (this.rpcState) {
                case REPLAY_BROWSER: {
                    discordHandler.updateRichPresence(clientConfig.generic.overrideWith(replayModConfig.replayModMenuSection).get());
                    break;
                }
                case REPLAY_EDITOR: {
                    discordHandler.updateRichPresence(clientConfig.generic.overrideWith(replayModConfig.replayModEditorSection).get());
                    break;
                }
                case REPLAY_RENDER: {
                    discordHandler.updateRichPresence(clientConfig.generic.overrideWith(replayModConfig.replayModRenderSection).get());
                }
            }
            return;
        }
        block5 : switch (this.rpcState) {
            case INIT: {
                discordHandler.updateRichPresence(clientConfig.init.buildPresence().getPresence());
                break;
            }
            case MAIN_MENU: {
                discordHandler.updateRichPresence(clientConfig.main_menu.buildPresence().getPresence());
                break;
            }
            case REALM_MENU: {
                discordHandler.updateRichPresence(clientConfig.realmsScreenSection.buildPresence().getPresence());
                break;
            }
            case SERVER_MENU: {
                discordHandler.updateRichPresence(clientConfig.server_list.buildPresence().getPresence());
                break;
            }
            case JOINING_GAME: {
                discordHandler.updateRichPresence(clientConfig.join_game.buildPresence().getPresence());
                break;
            }
            case PAUSED: {
                discordHandler.updateRichPresence(clientConfig.pauseSection.buildPresence().getPresence());
                break;
            }
            case IN_GAME: {
                switch (this.gameType) {
                    case SINGLE: {
                        this.updateSinglePlayerRpc(clientConfig, discordHandler);
                        break block5;
                    }
                    case MULTIPLAYER: {
                        this.updateMultiplayerRpc(clientConfig, discordHandler);
                        break block5;
                    }
                    case REALM: {
                        discordHandler.updateRichPresence(clientConfig.realmsGameSection.buildPresence().getPresence());
                    }
                }
            }
        }
    }

    private void updateSinglePlayerRpc(ClientConfig config, SimpleRPCCore.DiscordController discordHandler) {
        Optional<DimensionSection.Dimension> dimension;
        RichPresenceContainer main = config.single_player;
        if (config.dimension_overrides.enabled && !config.dimension_overrides.dimensions.isEmpty() && (dimension = APIUtils.findDimension(config.dimension_overrides.dimensions)).isPresent()) {
            main = main.overrideWith(dimension.get());
        }
        discordHandler.updateRichPresence(main.buildPresence().getPresence());
    }

    private void updateMultiplayerRpc(ClientConfig config, SimpleRPCCore.DiscordController discordHandler) {
        ServerEntriesConfig entriesConfig;
        Optional<DimensionSection.Dimension> dimension;
        RichPresenceContainer main = config.multi_player;
        if (config.dimension_overrides.enabled && !config.dimension_overrides.dimensions.isEmpty() && (dimension = APIUtils.findDimension(config.dimension_overrides.dimensions)).isPresent()) {
            main = main.overrideWith(dimension.get());
        }
        if ((entriesConfig = this.core.getServerEntriesConfig()) != null && entriesConfig.enabled && !entriesConfig.serverEntries.isEmpty()) {
            String ip = PlaceholderEngine.INSTANCE.resolvePlaceholders("{{server.ip}}");
            Optional<ServerEntry> entry = entriesConfig.serverEntries.stream().filter(e -> e.ip.equalsIgnoreCase(ip)).findFirst();
            if (entry.isPresent()) {
                main = main.overrideWith(entry.get());
            }
        }
        discordHandler.updateRichPresence(main.buildPresence().getPresence());
    }
}

