/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import juuxel.adorn.block.AbstractKitchenCounterBlock;
import juuxel.adorn.block.entity.KitchenSinkBlockEntity;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.util.LoggingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000  *\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001 B\u000f\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u000f\u0010\u0010J?\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Ljuuxel/adorn/client/renderer/KitchenSinkRenderer;", "Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;", "T", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "entity", "", "getFluidColor", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;)I", "", "getFluidLevel", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;)D", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getFluidSprite", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "", "isEmpty", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;)Z", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "light", "overlay", "", "render", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "Companion", "Adorn"})
@OnlyIn(value=Dist.CLIENT)
public abstract class KitchenSinkRenderer<T extends KitchenSinkBlockEntity>
implements BlockEntityRenderer<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER = LoggingKt.logger();
    private static final float PX = 0.0625f;
    private static final float X_START = 0.125f;
    private static final float X_END = 0.8125f;
    private static final float Z_START = 0.125f;
    private static final float Z_END = 0.875f;
    private static final float Y_START = 0.4375f;
    private static final float Y_END = 0.9375f;
    private static final double LITRES_PER_BLOCK = 1000.0;
    private static final float WAVE_PERIOD = 12000.0f;
    private static final float WAVE_HEIGHT = 0.0625f;
    private static final float MS_PER_TICK = 50.0f;

    public KitchenSinkRenderer(@NotNull BlockEntityRendererProvider.Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
    }

    public void render(@NotNull T entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        if (this.isEmpty(entity)) {
            return;
        }
        TextureAtlasSprite sprite = this.getFluidSprite(entity);
        VertexConsumer buffer = vertexConsumers.m_6299_(RenderType.m_110473_((ResourceLocation)sprite.m_247685_()));
        float u0 = Mth.m_14179_((float)0.125f, (float)sprite.m_118409_(), (float)sprite.m_118410_());
        float u1 = Mth.m_14179_((float)0.875f, (float)sprite.m_118409_(), (float)sprite.m_118410_());
        float v0 = Mth.m_14179_((float)0.125f, (float)sprite.m_118411_(), (float)sprite.m_118412_());
        float v1 = Mth.m_14179_((float)0.8125f, (float)sprite.m_118411_(), (float)sprite.m_118412_());
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        Comparable comparable = entity.m_58900_().m_61143_((Property)AbstractKitchenCounterBlock.Companion.getFACING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"entity.cachedState[Abstr\u2026tchenCounterBlock.FACING]");
        matrices.m_252781_(Axis.f_252436_.m_252977_(KitchenSinkRenderer.Companion.getRotation((Direction)comparable)));
        matrices.m_85837_(-0.5, 0.0, -0.5);
        double fluidLevel = this.getFluidLevel(entity) / 1000.0;
        matrices.m_85837_(0.0, Mth.m_14139_((double)fluidLevel, (double)0.4375, (double)0.9375), 0.0);
        Matrix4f positionMatrix = matrices.m_85850_().m_252922_();
        Matrix3f normalMatrix = matrices.m_85850_().m_252943_();
        int color = this.getFluidColor(entity);
        buffer.m_252986_(positionMatrix, 0.125f, KitchenSinkRenderer.render$y(0.125f, 0.875f), 0.875f).m_193479_(color).m_7421_(u0, v0).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(positionMatrix, 0.8125f, KitchenSinkRenderer.render$y(0.8125f, 0.875f), 0.875f).m_193479_(color).m_7421_(u0, v1).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(positionMatrix, 0.8125f, KitchenSinkRenderer.render$y(0.8125f, 0.125f), 0.125f).m_193479_(color).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(positionMatrix, 0.125f, KitchenSinkRenderer.render$y(0.125f, 0.125f), 0.125f).m_193479_(color).m_7421_(u1, v0).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        matrices.m_85849_();
    }

    private final TextureAtlasSprite getFluidSprite(T entity) {
        TextureAtlasSprite sprite = FluidRenderingBridge.Companion.get().getStillSprite(((KitchenSinkBlockEntity)((Object)entity)).getFluidReference());
        if (sprite == null) {
            LOGGER.error("Could not find sprite for fluid reference {} when rendering kitchen sink at {}", (Object)((KitchenSinkBlockEntity)((Object)entity)).getFluidReference(), (Object)entity.m_58899_());
            Object r = Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
            Intrinsics.checkNotNullExpressionValue(r, (String)"getInstance()\n          \u2026ite.getMissingSpriteId())");
            return (TextureAtlasSprite)r;
        }
        return sprite;
    }

    private final int getFluidColor(T entity) {
        return FluidRenderingBridge.Companion.get().getColor(((KitchenSinkBlockEntity)((Object)entity)).getFluidReference(), (BlockAndTintGetter)entity.m_58904_(), entity.m_58899_());
    }

    protected abstract double getFluidLevel(@NotNull T var1);

    protected abstract boolean isEmpty(@NotNull T var1);

    private static final float render$y(float x, float z) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        float time = (float)localPlayer.f_19797_ * 50.0f % 12000.0f;
        float t = time * ((float)Math.PI * 2) / 12000.0f;
        return Mth.m_14031_((float)(t + x + z)) * 0.0625f / (float)2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u000eR\u0014\u0010\u0016\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ljuuxel/adorn/client/renderer/KitchenSinkRenderer$Companion;", "", "Lnet/minecraft/core/Direction;", "facing", "", "getRotation", "(Lnet/minecraft/core/Direction;)F", "", "LITRES_PER_BLOCK", "D", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "MS_PER_TICK", "F", "PX", "WAVE_HEIGHT", "WAVE_PERIOD", "X_END", "X_START", "Y_END", "Y_START", "Z_END", "Z_START", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        private final float getRotation(Direction facing) {
            return switch (WhenMappings.$EnumSwitchMapping$0[facing.ordinal()]) {
                case 1 -> 0.0f;
                case 2 -> 90.0f;
                case 3 -> 180.0f;
                case 4 -> 270.0f;
                default -> 0.0f;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.values().length];
                try {
                    nArray[Direction.EAST.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.NORTH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.WEST.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.SOUTH.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

