/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.book.Book;
import juuxel.adorn.client.book.Image;
import juuxel.adorn.client.book.Page;
import juuxel.adorn.client.gui.Scissors;
import juuxel.adorn.client.gui.widget.Draggable;
import juuxel.adorn.client.gui.widget.FlipBook;
import juuxel.adorn.client.gui.widget.Panel;
import juuxel.adorn.client.gui.widget.ScrollEnvelope;
import juuxel.adorn.client.gui.widget.SizedElement;
import juuxel.adorn.client.gui.widget.TickingElement;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.animation.AnimationEngine;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 *2\u00020\u0001:\u0005+,-*.B\u000f\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b(\u0010)J\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\tJ/\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0019\u0010\tJ\u000f\u0010\u001a\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001a\u0010\tR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020$8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b'\u0010&\u00a8\u0006/"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "Lnet/minecraft/network/chat/Style;", "style", "", "handleTextClick", "(Lnet/minecraft/network/chat/Style;)Z", "", "init", "()V", "", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "removed", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "tick", "updatePageTurnButtons", "Ljuuxel/adorn/util/animation/AnimationEngine;", "animationEngine", "Ljuuxel/adorn/util/animation/AnimationEngine;", "Ljuuxel/adorn/client/book/Book;", "book", "Ljuuxel/adorn/client/book/Book;", "Ljuuxel/adorn/client/gui/widget/FlipBook;", "flipBook", "Ljuuxel/adorn/client/gui/widget/FlipBook;", "Lnet/minecraft/client/gui/screens/inventory/PageButton;", "nextPageButton", "Lnet/minecraft/client/gui/screens/inventory/PageButton;", "previousPageButton", "<init>", "(Ljuuxel/adorn/client/book/Book;)V", "Companion", "BookPageBody", "BookPageTitle", "CloseButton", "TitlePage", "Adorn"})
@SourceDebugExtension(value={"SMAP\nGuideBookScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuideBookScreen.kt\njuuxel/adorn/client/gui/screen/GuideBookScreen\n+ 2 Extensions.kt\njuuxel/adorn/client/gui/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n6#2,6:307\n288#3,2:313\n*S KotlinDebug\n*F\n+ 1 GuideBookScreen.kt\njuuxel/adorn/client/gui/screen/GuideBookScreen\n*L\n101#1:307,6\n122#1:313,2\n*E\n"})
public final class GuideBookScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Book book;
    private FlipBook flipBook;
    private PageButton previousPageButton;
    private PageButton nextPageButton;
    @NotNull
    private final AnimationEngine animationEngine;
    private static final int BOOK_SIZE = 192;
    private static final int PAGE_TITLE_X = 20;
    private static final int PAGE_WIDTH = 116;
    private static final int PAGE_BODY_HEIGHT = 121;
    private static final int PAGE_TITLE_WIDTH = 76;
    private static final int PAGE_TEXT_X = 4;
    private static final int PAGE_TEXT_Y = 24;
    private static final int PAGE_IMAGE_GAP = 4;
    private static final int ICON_DURATION = 25;
    @NotNull
    private static final ResourceLocation CLOSE_BOOK_ACTIVE_TEXTURE = AdornCommon.id("textures/gui/close_book_active.png");
    @NotNull
    private static final ResourceLocation CLOSE_BOOK_INACTIVE_TEXTURE = AdornCommon.id("textures/gui/close_book_inactive.png");
    private static final int HOVER_AREA_HIGHLIGHT_COLOR = ColorsKt.color(0xFFFFFF, 128);

    public GuideBookScreen(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        super(GameNarrator.f_93310_);
        this.book = book;
        this.animationEngine = new AnimationEngine();
    }

    protected void m_7856_() {
        int x = (this.f_96543_ - 192) / 2;
        int y = (this.f_96544_ - 192) / 2;
        int pageX = x + 35;
        int pageY = y + 14;
        this.m_142416_((GuiEventListener)new CloseButton(x + 142, y + 14, arg_0 -> GuideBookScreen.init$lambda$0(this, arg_0)));
        GuiEventListener guiEventListener = this.m_142416_((GuiEventListener)new PageButton(x + 49, y + 159, false, arg_0 -> GuideBookScreen.init$lambda$1(this, arg_0), true));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener, (String)"addDrawableChild(PageTur\u2026wPreviousPage() }, true))");
        this.previousPageButton = (PageButton)guiEventListener;
        GuiEventListener guiEventListener2 = this.m_142416_((GuiEventListener)new PageButton(x + 116, y + 159, true, arg_0 -> GuideBookScreen.init$lambda$2(this, arg_0), true));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener2, (String)"addDrawableChild(PageTur\u2026.showNextPage() }, true))");
        this.nextPageButton = (PageButton)guiEventListener2;
        GuiEventListener guiEventListener3 = this.m_142416_(new FlipBook((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                GuideBookScreen.access$updatePageTurnButtons((GuideBookScreen)((Object)this.receiver));
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener3, (String)"addDrawableChild(FlipBoo\u2026::updatePageTurnButtons))");
        this.flipBook = (FlipBook)guiEventListener3;
        FlipBook flipBook = this.flipBook;
        if (flipBook == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        flipBook.add(new TitlePage(pageX, pageY, this.book));
        for (Page page : this.book.getPages()) {
            Panel panel = new Panel();
            panel.add(new BookPageTitle(pageX, pageY, page));
            BookPageBody body = new BookPageBody(pageX, pageY + 24, page);
            panel.add(new ScrollEnvelope(pageX, pageY + 24, 116, 121, body, this.animationEngine));
            FlipBook flipBook2 = this.flipBook;
            if (flipBook2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
                flipBook2 = null;
            }
            flipBook2.add((GuiEventListener)panel);
        }
        this.updatePageTurnButtons();
        this.animationEngine.start();
    }

    private final void updatePageTurnButtons() {
        FlipBook flipBook;
        FlipBook flipBook2;
        PageButton pageButton = this.previousPageButton;
        if (pageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousPageButton");
            pageButton = null;
        }
        if ((flipBook2 = this.flipBook) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook2 = null;
        }
        pageButton.f_93624_ = flipBook2.hasPreviousPage();
        PageButton pageButton2 = this.nextPageButton;
        if (pageButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextPageButton");
            pageButton2 = null;
        }
        if ((flipBook = this.flipBook) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        pageButton2.f_93624_ = flipBook.hasNextPage();
    }

    public void m_88315_(@NotNull GuiGraphics context2, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.m_280273_(context2);
        int x = (this.f_96543_ - 192) / 2;
        int y = (this.f_96544_ - 192) / 2;
        context2.m_280218_(BookViewScreen.f_98252_, x, y, 0, 0, 192, 192);
        super.m_88315_(context2, mouseX, mouseY, delta);
    }

    public boolean m_5561_(@Nullable Style style) {
        ClickEvent clickEvent;
        if (style != null && (clickEvent = style.m_131182_()) != null && clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            boolean bl;
            String string = clickEvent.m_130623_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clickEvent.value");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) {
                return false;
            }
            int page = n;
            int pageIndex = page - 1;
            if (0 <= pageIndex) {
                FlipBook flipBook = this.flipBook;
                if (flipBook == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
                    flipBook = null;
                }
                bl = pageIndex < flipBook.getPageCount();
            } else {
                bl = false;
            }
            if (bl) {
                FlipBook flipBook = this.flipBook;
                if (flipBook == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
                    flipBook = null;
                }
                flipBook.setCurrentPage(pageIndex);
                Minecraft minecraft = this.f_96541_;
                Intrinsics.checkNotNull((Object)minecraft);
                minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                return true;
            }
        }
        return super.m_5561_(style);
    }

    public void m_86600_() {
        ContainerEventHandler $this$forEach$iv = (ContainerEventHandler)this;
        boolean $i$f$forEach = false;
        for (GuiEventListener child$iv : $this$forEach$iv.m_6702_()) {
            if (!(child$iv instanceof TickingElement)) continue;
            TickingElement it = (TickingElement)child$iv;
            boolean bl = false;
            it.tick();
        }
        GuiEventListener focused = this.m_7222_();
        if (focused instanceof Draggable && !this.m_7282_()) {
            ((Draggable)focused).stopDragging();
        }
    }

    public void m_7861_() {
        this.animationEngine.stop();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        GuiEventListener currentPage;
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        FlipBook flipBook = this.flipBook;
        if (flipBook == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        if ((currentPage = flipBook.getCurrentPageValue()) instanceof Panel) {
            Object v1;
            block5: {
                Iterable $this$firstOrNull$iv = ((Panel)currentPage).m_6702_();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GuiEventListener it = (GuiEventListener)element$iv;
                    boolean bl = false;
                    if (!(it instanceof ScrollEnvelope)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            GuiEventListener scroll = v1;
            if (scroll != null) {
                return scroll.m_7933_(keyCode, scanCode, modifiers);
            }
        }
        return false;
    }

    private static final void init$lambda$0(GuideBookScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.m_7379_();
    }

    private static final void init$lambda$1(GuideBookScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FlipBook flipBook = this$0.flipBook;
        if (flipBook == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        flipBook.showPreviousPage();
    }

    private static final void init$lambda$2(GuideBookScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FlipBook flipBook = this$0.flipBook;
        if (flipBook == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        flipBook.showNextPage();
    }

    public static final /* synthetic */ void access$updatePageTurnButtons(GuideBookScreen $this) {
        $this.updatePageTurnButtons();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b4\u00105J!\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b \u0010!R\u0016\u0010\u001f\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\"R\u001a\u0010#\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010$R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010$R\u001a\u0010,\u001a\u00020\u00038\u0016X\u0096D\u00a2\u0006\f\n\u0004\b,\u0010$\u001a\u0004\b-\u0010&R8\u00102\u001a&\u0012\f\u0012\n 0*\u0004\u0018\u00010/0/ 0*\u0012\u0012\f\u0012\n 0*\u0004\u0018\u00010/0/\u0018\u0001010.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010$R\u0014\u0010\u0005\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$\u00a8\u00066"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$BookPageBody;", "Ljuuxel/adorn/client/gui/widget/SizedElement;", "Lnet/minecraft/client/gui/components/Renderable;", "", "x", "y", "Lnet/minecraft/network/chat/Style;", "getTextStyleAt", "(II)Lnet/minecraft/network/chat/Style;", "", "isFocused", "()Z", "", "mouseX", "mouseY", "isMouseOver", "(DD)Z", "button", "mouseClicked", "(DDI)Z", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "delta", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Ljuuxel/adorn/client/book/Image;", "image", "renderImage", "(Lnet/minecraft/client/gui/GuiGraphics;Ljuuxel/adorn/client/book/Image;II)V", "focused", "setFocused", "(Z)V", "Z", "height", "I", "getHeight", "()I", "imageHeight", "Ljuuxel/adorn/client/book/Page;", "page", "Ljuuxel/adorn/client/book/Page;", "textHeight", "width", "getWidth", "", "Lnet/minecraft/util/FormattedCharSequence;", "kotlin.jvm.PlatformType", "", "wrappedBodyLines", "Ljava/util/List;", "<init>", "(Ljuuxel/adorn/client/gui/screen/GuideBookScreen;IILjuuxel/adorn/client/book/Page;)V", "Adorn"})
    @SourceDebugExtension(value={"SMAP\nGuideBookScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuideBookScreen.kt\njuuxel/adorn/client/gui/screen/GuideBookScreen$BookPageBody\n+ 2 Scissors.kt\njuuxel/adorn/client/gui/Scissors\n*L\n1#1,306:1\n47#2,5:307\n47#2,5:312\n*S KotlinDebug\n*F\n+ 1 GuideBookScreen.kt\njuuxel/adorn/client/gui/screen/GuideBookScreen$BookPageBody\n*L\n247#1:307,5\n270#1:312,5\n*E\n"})
    private final class BookPageBody
    implements SizedElement,
    Renderable {
        private final int x;
        private final int y;
        @NotNull
        private final Page page;
        private final int width;
        private final List<FormattedCharSequence> wrappedBodyLines;
        private final int textHeight;
        private final int imageHeight;
        private final int height;
        private boolean focused;

        public BookPageBody(int x, @NotNull int y, Page page) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            this.x = x;
            this.y = y;
            this.page = page;
            this.width = 116;
            this.wrappedBodyLines = GuideBookScreen.this.f_96547_.m_92923_((FormattedText)this.page.getText(), 112);
            this.textHeight = this.wrappedBodyLines.size() * ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_;
            this.imageHeight = this.page.getImage() != null ? this.page.getImage().getSize().getY() + 4 : 0;
            this.height = Math.max(121, this.textHeight + this.imageHeight);
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return (double)this.x <= mouseX && mouseX <= (double)(this.x + this.getWidth()) && (double)this.y <= mouseY && mouseY <= (double)(this.y + this.getHeight());
        }

        private final Style getTextStyleAt(int x, int y) {
            if (!this.m_5953_(x, y)) {
                return null;
            }
            int wx = x - (this.x + 4);
            int wy = y - this.y;
            int lineIndex = wy / ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_;
            boolean bl = 0 <= lineIndex ? lineIndex < this.wrappedBodyLines.size() : false;
            if (bl) {
                FormattedCharSequence line = this.wrappedBodyLines.get(lineIndex);
                return GuideBookScreen.this.f_96547_.m_92865_().m_92338_(line, wx);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public void m_88315_(@NotNull GuiGraphics context2, int mouseX, int mouseY, float delta) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            int textYOffset = this.page.getImage() != null && this.page.getImage().getPlacement() == Image.Placement.BEFORE_TEXT ? this.imageHeight : 0;
            Iterator<FormattedCharSequence> iterator2 = this.wrappedBodyLines.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                FormattedCharSequence line = iterator2.next();
                context2.m_280649_(GuideBookScreen.this.f_96547_, line, this.x + 4, textYOffset + this.y + i * ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_, Colors.INSTANCE.getSCREEN_TEXT(), false);
            }
            if (this.page.getImage() != null) {
                this.renderImage(context2, this.page.getImage(), mouseX, mouseY);
            }
            Style hoveredStyle = this.getTextStyleAt(mouseX, mouseY);
            Scissors scissors = Scissors.INSTANCE;
            GuideBookScreen guideBookScreen = GuideBookScreen.this;
            boolean $i$f$suspendScissors = false;
            Scissors.Frame frame$iv = this_$iv.pop();
            boolean bl = false;
            context2.m_280304_(guideBookScreen.f_96547_, hoveredStyle, mouseX, mouseY);
            this_$iv.push(frame$iv);
        }

        /*
         * WARNING - void declaration
         */
        private final void renderImage(GuiGraphics context2, Image image, int mouseX, int mouseY) {
            int imageX = this.x + (116 - image.getSize().getX()) / 2;
            int imageY = switch (WhenMappings.$EnumSwitchMapping$0[image.getPlacement().ordinal()]) {
                case 1 -> this.y;
                case 2 -> this.y + this.textHeight + 4;
                default -> throw new NoWhenBranchMatchedException();
            };
            RenderSystem.enableBlend();
            context2.m_280163_(image.getLocation(), imageX, imageY, 0.0f, 0.0f, image.getSize().getX(), image.getSize().getY(), image.getSize().getX(), image.getSize().getY());
            RenderSystem.disableBlend();
            for (Image.HoverArea hoverArea : image.getHoverAreas()) {
                void this_$iv;
                if (!hoverArea.contains(mouseX - imageX, mouseY - imageY)) continue;
                int hX = imageX + hoverArea.getPosition().getX();
                int hY = imageY + hoverArea.getPosition().getY();
                context2.m_280509_(hX, hY, hX + hoverArea.getSize().getX(), hY + hoverArea.getSize().getY(), HOVER_AREA_HIGHLIGHT_COLOR);
                List wrappedTooltip = GuideBookScreen.this.f_96547_.m_92923_((FormattedText)hoverArea.getTooltip(), 116);
                Scissors scissors = Scissors.INSTANCE;
                GuideBookScreen guideBookScreen = GuideBookScreen.this;
                boolean $i$f$suspendScissors = false;
                Scissors.Frame frame$iv = this_$iv.pop();
                boolean bl = false;
                context2.m_280245_(guideBookScreen.f_96547_, wrappedTooltip, mouseX, mouseY);
                this_$iv.push(frame$iv);
                break;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Style style;
            if (button == 0 && (style = this.getTextStyleAt((int)mouseX, (int)mouseY)) != null && GuideBookScreen.this.m_5561_(style)) {
                return true;
            }
            return SizedElement.super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_93696_() {
            return this.focused;
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Image.Placement.values().length];
                try {
                    nArray[Image.Placement.BEFORE_TEXT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Image.Placement.AFTER_TEXT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\"\u001a\u00020\t\u0012\u0006\u0010#\u001a\u00020\t\u0012\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0011\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR8\u0010!\u001a&\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f  *\u0012\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f\u0018\u00010\u001a0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001dR\u0014\u0010\"\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\u0018R\u0014\u0010#\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\u0018\u00a8\u0006("}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$BookPageTitle;", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "Lnet/minecraft/client/gui/components/Renderable;", "Ljuuxel/adorn/client/gui/widget/TickingElement;", "", "isFocused", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "mouseX", "mouseY", "", "delta", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "focused", "setFocused", "(Z)V", "tick", "()V", "Z", "icon", "I", "iconTicks", "", "Lnet/minecraft/world/item/ItemStack;", "icons", "Ljava/util/List;", "", "Lnet/minecraft/util/FormattedCharSequence;", "kotlin.jvm.PlatformType", "wrappedTitleLines", "x", "y", "Ljuuxel/adorn/client/book/Page;", "page", "<init>", "(Ljuuxel/adorn/client/gui/screen/GuideBookScreen;IILjuuxel/adorn/client/book/Page;)V", "Adorn"})
    @SourceDebugExtension(value={"SMAP\nGuideBookScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuideBookScreen.kt\njuuxel/adorn/client/gui/screen/GuideBookScreen$BookPageTitle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1549#2:307\n1620#2,3:308\n*S KotlinDebug\n*F\n+ 1 GuideBookScreen.kt\njuuxel/adorn/client/gui/screen/GuideBookScreen$BookPageTitle\n*L\n175#1:307\n175#1:308,3\n*E\n"})
    private final class BookPageTitle
    implements GuiEventListener,
    Renderable,
    TickingElement {
        private final int x;
        private final int y;
        private final List<FormattedCharSequence> wrappedTitleLines;
        @NotNull
        private final List<ItemStack> icons;
        private int icon;
        private int iconTicks;
        private boolean focused;

        /*
         * WARNING - void declaration
         */
        public BookPageTitle(int x, @NotNull int y, Page page) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            this.x = x;
            this.y = y;
            this.wrappedTitleLines = GuideBookScreen.this.f_96547_.m_92923_((FormattedText)page.getTitle().m_6881_().m_130938_(BookPageTitle::wrappedTitleLines$lambda$0), 76);
            Iterable iterable = page.getIcons();
            BookPageTitle bookPageTitle = this;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Page.Icon icon = (Page.Icon)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.createStacks());
            }
            bookPageTitle.icons = juuxel.adorn.util.CollectionsKt.interleave((List)destination$iv$iv);
        }

        public void m_88315_(@NotNull GuiGraphics context2, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            context2.m_280203_(this.icons.get(this.icon), this.x, this.y);
            int titleY = this.y + 10 - ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_ * this.wrappedTitleLines.size() / 2;
            Iterator<FormattedCharSequence> iterator2 = this.wrappedTitleLines.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                FormattedCharSequence line = iterator2.next();
                context2.m_280649_(GuideBookScreen.this.f_96547_, line, this.x + 20, titleY + i * ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_, Colors.INSTANCE.getSCREEN_TEXT(), false);
            }
        }

        @Override
        public void tick() {
            int n = this.iconTicks;
            this.iconTicks = n + 1;
            if (n >= 25) {
                this.iconTicks = 0;
                this.icon = (this.icon + 1) % this.icons.size();
            }
        }

        public boolean m_93696_() {
            return this.focused;
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }

        private static final Style wrappedTitleLines$lambda$0(Style it) {
            return it.m_131136_(Boolean.valueOf(true));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$CloseButton;", "Lnet/minecraft/client/gui/components/Button;", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "mouseX", "mouseY", "", "delta", "", "renderButton", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "x", "y", "Lnet/minecraft/client/gui/components/Button$OnPress;", "pressAction", "<init>", "(IILnet/minecraft/client/gui/components/Button$OnPress;)V", "Adorn"})
    private static final class CloseButton
    extends Button {
        public CloseButton(int x, int y, @NotNull Button.OnPress pressAction) {
            Intrinsics.checkNotNullParameter((Object)pressAction, (String)"pressAction");
            super(x, y, 8, 8, (Component)Component.m_237119_(), pressAction, Button.f_252438_);
        }

        protected void m_87963_(@NotNull GuiGraphics context2, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            ResourceLocation texture = this.m_274382_() ? CLOSE_BOOK_ACTIVE_TEXTURE : CLOSE_BOOK_INACTIVE_TEXTURE;
            context2.m_280163_(texture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0004R\u0014\u0010\n\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0004R\u0014\u0010\f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0004R\u0014\u0010\r\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0004R\u0014\u0010\u000e\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0004R\u0014\u0010\u000f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0004R\u0014\u0010\u0010\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0004R\u0014\u0010\u0011\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0004\u00a8\u0006\u0014"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$Companion;", "", "", "BOOK_SIZE", "I", "Lnet/minecraft/resources/ResourceLocation;", "CLOSE_BOOK_ACTIVE_TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "CLOSE_BOOK_INACTIVE_TEXTURE", "HOVER_AREA_HIGHLIGHT_COLOR", "ICON_DURATION", "PAGE_BODY_HEIGHT", "PAGE_IMAGE_GAP", "PAGE_TEXT_X", "PAGE_TEXT_Y", "PAGE_TITLE_WIDTH", "PAGE_TITLE_X", "PAGE_WIDTH", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u001b\u001a\u00020\b\u0012\u0006\u0010\u001d\u001a\u00020\b\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0010\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001c\u00a8\u0006 "}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$TitlePage;", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "Lnet/minecraft/client/gui/components/Renderable;", "", "isFocused", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "mouseX", "mouseY", "", "delta", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "focused", "setFocused", "(Z)V", "Ljuuxel/adorn/client/book/Book;", "book", "Ljuuxel/adorn/client/book/Book;", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "byAuthor", "Lnet/minecraft/network/chat/MutableComponent;", "Z", "x", "I", "y", "<init>", "(Ljuuxel/adorn/client/gui/screen/GuideBookScreen;IILjuuxel/adorn/client/book/Book;)V", "Adorn"})
    private final class TitlePage
    implements GuiEventListener,
    Renderable {
        private final int x;
        private final int y;
        @NotNull
        private final Book book;
        private final MutableComponent byAuthor;
        private boolean focused;

        public TitlePage(int x, @NotNull int y, Book book) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            this.x = x;
            this.y = y;
            this.book = book;
            Object[] objectArray = new Object[]{this.book.getAuthor()};
            this.byAuthor = Component.m_237110_((String)"book.byAuthor", (Object[])objectArray);
        }

        public void m_88315_(@NotNull GuiGraphics context2, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            int cx = this.x + 58;
            PoseStack matrices = context2.m_280168_();
            matrices.m_85836_();
            matrices.m_85837_((double)cx, (double)(this.y + 7) + (double)25, 0.0);
            matrices.m_85841_(this.book.getTitleScale(), this.book.getTitleScale(), 1.0f);
            context2.m_280614_(GuideBookScreen.this.f_96547_, this.book.getTitle(), -GuideBookScreen.this.f_96547_.m_92852_((FormattedText)this.book.getTitle()) / 2, 0, Colors.INSTANCE.getSCREEN_TEXT(), false);
            matrices.m_85849_();
            context2.m_280614_(GuideBookScreen.this.f_96547_, this.book.getSubtitle(), cx - GuideBookScreen.this.f_96547_.m_92852_((FormattedText)this.book.getSubtitle()) / 2, this.y + 45, Colors.INSTANCE.getSCREEN_TEXT(), false);
            context2.m_280614_(GuideBookScreen.this.f_96547_, (Component)this.byAuthor, cx - GuideBookScreen.this.f_96547_.m_92852_((FormattedText)this.byAuthor) / 2, this.y + 60, Colors.INSTANCE.getSCREEN_TEXT(), false);
        }

        public boolean m_93696_() {
            return this.focused;
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }
    }
}

