/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.mixins.impl;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.features.TrueDarknessFeature;
import me.srrapero720.chloride.mixins.impl.accessors.LightTextureAccessors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class TrueDarknessMixin {

    @Mixin(value={DimensionSpecialEffects.class})
    public static class DimensionEffectsMixin {

        @Mixin(value={DimensionSpecialEffects.EndEffects.class})
        public static class EndMixin {
            @Inject(method={"getBrightnessDependentFogColor"}, at={@At(value="RETURN")}, cancellable=true)
            private void inject$brightFogColor(CallbackInfoReturnable<Vec3> cir) {
                if (ChlorideConfig.darknessMode == ChlorideConfig.DarknessMode.OFF) {
                    return;
                }
                if (!ChlorideConfig.darknessOnEnd) {
                    return;
                }
                cir.setReturnValue((Object)TrueDarknessFeature.getDarkFogColor((Vec3)cir.getReturnValue(), ChlorideConfig.darknessEndFogBright));
            }
        }

        @Mixin(value={DimensionSpecialEffects.NetherEffects.class})
        public static class NetherMixin {
            @Inject(method={"getBrightnessDependentFogColor"}, at={@At(value="RETURN")}, cancellable=true)
            private void inject$brightFogColor(CallbackInfoReturnable<Vec3> cir) {
                if (ChlorideConfig.darknessMode == ChlorideConfig.DarknessMode.OFF) {
                    return;
                }
                if (!ChlorideConfig.darknessOnNether) {
                    return;
                }
                cir.setReturnValue((Object)TrueDarknessFeature.getDarkFogColor((Vec3)cir.getReturnValue(), ChlorideConfig.darknessNetherFogBright));
            }
        }
    }

    @Mixin(value={DynamicTexture.class})
    public static class DynamicTextureMixin {
        @Shadow
        private NativeImage f_117977_;
        @Unique
        private boolean chloride$firstCall = true;

        @Inject(method={"upload"}, at={@At(value="HEAD")})
        private void inject$onUpload(CallbackInfo ci) {
            if (!TrueDarknessFeature.enabled) {
                return;
            }
            if (this.chloride$firstCall) {
                this.chloride$firstCall = false;
                return;
            }
            NativeImage img = this.f_117977_;
            for (int b = 0; b < 16; ++b) {
                for (int s = 0; s < 16; ++s) {
                    int color = TrueDarknessFeature.darken(img.m_84985_(b, s), b, s);
                    img.m_84988_(b, s, color);
                }
            }
        }
    }

    @Mixin(value={GameRenderer.class})
    public static abstract class GameRendererMixin {
        @Shadow
        @Final
        public LightTexture f_109074_;
        @Shadow
        @Final
        private Minecraft f_109059_;

        @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
        private void inject$renderLevel(float tickDelta, long nanos, PoseStack matrixStack, CallbackInfo ci) {
            LightTextureAccessors lightTexAccessor = (LightTextureAccessors)this.f_109074_;
            if (lightTexAccessor.embPlus$isDirty()) {
                this.f_109059_.m_91307_().m_6180_("lightTex");
                TrueDarknessFeature.updateLuminance(tickDelta, this.f_109059_, (GameRenderer)this, lightTexAccessor.embPlus$getFlicker());
                this.f_109059_.m_91307_().m_7238_();
            }
        }
    }
}

