/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.features.sodium;

import java.util.List;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.srrapero720.chloride.Chloride;
import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.Tools;
import me.srrapero720.chloride.features.sodium.pages.DetailsPage;
import me.srrapero720.chloride.features.sodium.pages.EntityCullingPage;
import me.srrapero720.chloride.features.sodium.pages.OthersPage;
import me.srrapero720.chloride.features.sodium.pages.OverlayPage;
import me.srrapero720.chloride.features.sodium.pages.TrueDarknessPage;
import me.srrapero720.chloride.features.sodium.pages.ZoomPage;
import me.srrapero720.chloride.features.sodium.storage.ChlorideOptionsStorage;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.embeddedt.embeddium.api.OptionGUIConstructionEvent;
import org.embeddedt.embeddium.api.OptionGroupConstructionEvent;
import org.embeddedt.embeddium.api.OptionPageConstructionEvent;
import org.embeddedt.embeddium.client.gui.options.OptionIdentifier;
import org.embeddedt.embeddium.client.gui.options.StandardOptions;

@Mod.EventBusSubscriber(modid="chloride", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChlorideOptions {
    public static final OptionStorage<?> STORAGE = new ChlorideOptionsStorage();

    @SubscribeEvent
    public static void onSodiumPagesRegister(OptionGUIConstructionEvent e) {
        List pages = e.getPages();
        pages.add(new OverlayPage());
        pages.add(new DetailsPage());
        if (!ChlorideConfig.modpackMode) {
            pages.add(new TrueDarknessPage());
        }
        pages.add(new EntityCullingPage());
        if (!ChlorideConfig.modpackMode) {
            pages.add(new ZoomPage());
        }
        pages.add(new OthersPage());
        if (ChlorideConfig.modpackMode) {
            Chloride.LOGGER.info("Modpack Mode is enabled, skipping chloride True Darkness and Zoom page registration");
        }
    }

    @SubscribeEvent
    public static void onSodiumPagesRegister(OptionGroupConstructionEvent e) {
        if (e.getId() != null && e.getId().toString().equals(StandardOptions.Group.WINDOW.toString())) {
            List options = e.getOptions();
            for (int i = 0; i < options.size(); ++i) {
                OptionIdentifier id = ((Option)options.get(i)).getId();
                if (id == null || !id.matches(StandardOptions.Option.FULLSCREEN)) continue;
                options.set(i, ChlorideOptions.getFullscreenOption());
            }
        }
    }

    @SubscribeEvent
    public static void onSodiumGroupRegister(OptionPageConstructionEvent e) {
        if (e.getId() != null && e.getId().equals((Object)StandardOptions.Pages.PERFORMANCE)) {
            OptionGroup.Builder builder = OptionGroup.createBuilder();
            OptionStorage sodiumOpts = SodiumGameOptionPages.getVanillaOpts();
            OptionImpl fontShadow = OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumOpts).setId(ResourceLocation.m_214293_((String)"chloride", (String)"font_shadow")).setName((Component)Component.m_237115_((String)"chloride.options.fontshadow.title")).setTooltip((Component)Component.m_237115_((String)"chloride.options.fontshadow.desc")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
                ChlorideConfig.fontShadows = value;
            }, opts -> ChlorideConfig.fontShadows).setImpact(OptionImpact.VARIES).build();
            OptionImpl leavesCulling = OptionImpl.createBuilder(ChlorideConfig.LeavesCullingMode.class, (OptionStorage)sodiumOpts).setId(ResourceLocation.m_214293_((String)"chloride", (String)"leaves_culling")).setName((Component)Component.m_237115_((String)"chloride.options.leaves_culling.title")).setTooltip((Component)Component.m_237115_((String)"chloride.options.leaves_culling.desc")).setControl(opt -> new CyclingControl((Option)opt, ChlorideConfig.LeavesCullingMode.class, new Component[]{Component.m_237115_((String)"chloride.options.leaves_culling.all"), Component.m_237115_((String)"chloride.options.leaves_culling.off")})).setBinding((opt, v) -> {
                ChlorideConfig.leavesCulling = v;
            }, opts -> ChlorideConfig.leavesCulling).setImpact(OptionImpact.HIGH).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build();
            OptionImpl fastChest = OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumOpts).setId(ResourceLocation.m_214293_((String)"chloride", (String)"fast_chests")).setName((Component)Component.m_237115_((String)"chloride.options.fastchest.title")).setTooltip((Component)Component.m_237115_((String)"chloride.options.fastchest.desc")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
                ChlorideConfig.fastChests = value;
            }, opts -> ChlorideConfig.fastChests).setImpact(OptionImpact.HIGH).setEnabled(false).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build();
            OptionImpl fastBeds = OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumOpts).setId(ResourceLocation.m_214293_((String)"chloride", (String)"fast_beds")).setName((Component)Component.m_237115_((String)"chloride.options.fastbeds.title")).setTooltip((Component)Component.m_237115_((String)"chloride.options.fastbeds.desc")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
                ChlorideConfig.fastBeds = value;
            }, opts -> ChlorideConfig.fastBeds).setImpact(OptionImpact.LOW).setEnabled(false).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build();
            OptionImpl hideJEI = OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumOpts).setId(ResourceLocation.m_214293_((String)"chloride", (String)"hide_jremi")).setName((Component)Component.m_237115_((String)"chloride.options.jei.title")).setTooltip((Component)Component.m_237115_((String)"chloride.options.jei.desc")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
                ChlorideConfig.hideJREMI = value;
            }, opts -> ChlorideConfig.hideJREMI).setImpact(OptionImpact.LOW).setEnabled(Tools.isModInstalled("jei") || Tools.isModInstalled("roughlyenoughitems") || Tools.isModInstalled("emi")).build();
            builder.add((Option)leavesCulling);
            builder.add((Option)fontShadow);
            builder.add((Option)fastChest);
            builder.add((Option)fastBeds);
            builder.add((Option)hideJEI);
            e.addGroup(builder.build());
        }
    }

    private static Option<ChlorideConfig.FullScreenMode> getFullscreenOption() {
        OptionStorage options = SodiumGameOptionPages.getVanillaOpts();
        return OptionImpl.createBuilder(ChlorideConfig.FullScreenMode.class, (OptionStorage)options).setId(ResourceLocation.m_214293_((String)"chloride", (String)"fullscreen")).setName((Component)Component.m_237115_((String)"chloride.options.screen.title")).setTooltip((Component)Component.m_237115_((String)"chloride.options.screen.desc")).setControl(opt -> new CyclingControl((Option)opt, ChlorideConfig.FullScreenMode.class, new Component[]{Component.m_237115_((String)"chloride.options.screen.windowed"), Component.m_237115_((String)"chloride.options.screen.borderless"), Component.m_237115_((String)"options.fullscreen")})).setBinding(ChlorideConfig::setFullScreenMode, opts -> ChlorideConfig.fullScreen).build();
    }
}

