/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.io;

public class EndianUtils {
    public static short swapShort(short s) {
        return (short)((s & 0xFF00) >> 8 | (s & 0xFF) << 8);
    }

    public static int swapInteger(int n) {
        return (n & 0xFF000000) >> 24 | (n & 0xFF0000) >> 8 | (n & 0xFF00) << 8 | (n & 0xFF) << 24;
    }

    public static long swapLong(long l) {
        return (l & 0xFF00000000000000L) >> 56 | (l & 0xFF000000000000L) >> 40 | (l & 0xFF0000000000L) >> 24 | (l & 0xFF00000000L) >> 8 | (l & 0xFF000000L) << 8 | (l & 0xFF0000L) << 24 | (l & 0xFF00L) << 40 | (l & 0xFFL) << 56;
    }

    public static float swapFloat(float f) {
        int n = Float.floatToIntBits(f);
        n = EndianUtils.swapInteger(n);
        return Float.intBitsToFloat(n);
    }

    public static double swapDouble(double d) {
        long l = Double.doubleToLongBits(d);
        l = EndianUtils.swapLong(l);
        return Double.longBitsToDouble(l);
    }

    public static String toHexString(int n, boolean bl, int n2) {
        if (bl) {
            n = EndianUtils.swapInteger(n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toHexString(n));
        if (stringBuilder.length() % 2 != 0) {
            stringBuilder.insert(0, '0');
        }
        while (stringBuilder.length() < n2 * 2) {
            stringBuilder.insert(0, "00");
        }
        return stringBuilder.toString();
    }

    public static StringBuilder toCharString(StringBuilder stringBuilder, int n, int n2, char c) {
        int n3 = 24;
        for (int i = 0; i < n2; ++i) {
            int n4 = n >> n3 & 0xFF;
            char c2 = n4 < 32 ? c : (char)n4;
            stringBuilder.append(c2);
            n3 -= 8;
        }
        return stringBuilder;
    }

    public static String toInfoString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Decimal: ").append(n);
        stringBuilder.append(", Hex BE: ").append(EndianUtils.toHexString(n, false, 4));
        stringBuilder.append(", Hex LE: ").append(EndianUtils.toHexString(n, true, 4));
        stringBuilder.append(", String BE: [");
        stringBuilder = EndianUtils.toCharString(stringBuilder, n, 4, '.');
        stringBuilder.append(']');
        stringBuilder.append(", String LE: [");
        stringBuilder = EndianUtils.toCharString(stringBuilder, EndianUtils.swapInteger(n), 4, '.');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

