/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import dk.zlepper.itlt.client.ClientConfig;
import dk.zlepper.itlt.client.ClientModEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.Pair;

public class FirstLaunchScreen
extends Screen {
    private final Screen previousScreen;
    private final Minecraft mcInstance = Minecraft.m_91087_();
    private ScrollableTextPanel scrollableTextPanel;

    public FirstLaunchScreen(Screen previousScreen, Component title) {
        super(title);
        this.previousScreen = previousScreen;
    }

    public void m_7379_() {
        ClientConfig.enableWelcomeScreen.set((Object)false);
        this.mcInstance.m_91152_(this.previousScreen);
    }

    protected void m_7856_() {
        Button doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, onPress -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 200, 20).m_253136_();
        this.scrollableTextPanel = new ScrollableTextPanel(this.mcInstance, this.f_96543_ - 40, this.f_96544_ - 40 - doneButton.m_93694_(), 24, 20);
        try (Stream<String> lines = Files.lines(ClientModEvents.itltDir.toPath().resolve("welcome.txt"));){
            this.scrollableTextPanel.setText(lines.toList());
        }
        catch (IOException e) {
            this.scrollableTextPanel.setText(List.of("Error: Failed to load welcome.txt, see the console log for details."));
            e.printStackTrace();
        }
        this.m_142416_((GuiEventListener)doneButton);
        this.m_142416_((GuiEventListener)this.scrollableTextPanel);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        FirstLaunchScreen.drawCenteredStringWithScale(guiGraphics, this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF, 1.5f);
        this.scrollableTextPanel.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private static void drawCenteredStringWithScale(GuiGraphics guiGraphics, Font font, Component string, int x, int y, int color, float scale) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280430_(font, string, (int)((float)x / scale - (float)font.m_92852_((FormattedText)string) / 2.0f), (int)((float)y / scale), color);
        poseStack.m_85849_();
    }

    public class ScrollableTextPanel
    extends ScrollPanel {
        private List<Pair<Boolean, FormattedCharSequence>> lines;
        public int padding;

        ScrollableTextPanel(Minecraft mcInstance, int width, int height, int top, int left) {
            super(mcInstance, width, height, top, left);
            this.lines = Collections.emptyList();
            this.padding = 6;
        }

        public void setText(List<String> lines) {
            this.lines = this.wordWrapAndFormat(lines);
        }

        protected int getContentHeight() {
            int n = this.lines.size();
            Objects.requireNonNull(FirstLaunchScreen.this.f_96547_);
            int n2 = n * 9;
            Objects.requireNonNull(FirstLaunchScreen.this.f_96547_);
            return n2 + 9;
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tesselator, int mouseX, int mouseY) {
            for (Pair<Boolean, FormattedCharSequence> line : this.lines) {
                if (line != null) {
                    RenderSystem.enableBlend();
                    if (((Boolean)line.getLeft()).booleanValue()) {
                        PoseStack poseStack = guiGraphics.m_280168_();
                        poseStack.m_85836_();
                        poseStack.m_85841_(1.5f, 1.5f, 1.0f);
                        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
                        guiGraphics.drawString(FirstLaunchScreen.this.f_96547_, (FormattedCharSequence)line.getRight(), (float)(this.left + this.padding) / 1.5f, (float)relativeY / 1.5f, 0xFFFFFF, true);
                        poseStack.m_85849_();
                    } else {
                        guiGraphics.m_280649_(FirstLaunchScreen.this.f_96547_, (FormattedCharSequence)line.getRight(), this.left + this.padding, relativeY, 0xFFFFFF, true);
                    }
                    RenderSystem.disableBlend();
                }
                Objects.requireNonNull(FirstLaunchScreen.this.f_96547_);
                relativeY += 9;
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        /*
         * WARNING - void declaration
         */
        public List<Pair<Boolean, FormattedCharSequence>> wordWrapAndFormat(List<String> lines) {
            ArrayList<Pair<Boolean, FormattedCharSequence>> resized = new ArrayList<Pair<Boolean, FormattedCharSequence>>(lines.size());
            int lineCounter = 0;
            for (String string : lines) {
                void var5_12;
                boolean isHeading;
                void var5_8;
                String string2;
                String string3;
                if (string == null) {
                    resized.add(null);
                    continue;
                }
                if (string.isEmpty()) {
                    String string4 = string + " ";
                }
                if ((string3 = (string2 = var5_8.replaceAll("(?i)&([a-f]|[0-9]|l|m|n|o|r)", "\u00a7$1")).replace("\\\u00a7", "&")).startsWith("&h")) {
                    isHeading = true;
                    String string5 = string3.substring(2);
                } else {
                    isHeading = false;
                }
                Component lineWithFormattedLinks = ForgeHooks.newChatWithLinks((String)var5_12, (boolean)false);
                int maxTextLength = this.width - this.padding * 2;
                if (maxTextLength >= 0) {
                    Language.m_128107_().m_128112_(FirstLaunchScreen.this.f_96547_.m_92865_().m_92414_((FormattedText)lineWithFormattedLinks, maxTextLength, Style.f_131099_)).forEach(formattedCharSequence -> resized.add(Pair.of((Object)isHeading, (Object)formattedCharSequence)));
                }
                lineCounter += resized.size() - lineCounter;
                if (isHeading) {
                    resized.add((Pair<Boolean, FormattedCharSequence>)Pair.of((Object)false, (Object)Component.m_237113_((String)" ").m_7532_()));
                }
                ++lineCounter;
            }
            if (!((Boolean)((Pair)resized.get(resized.size() - 1)).getLeft()).booleanValue()) {
                resized.add((Pair<Boolean, FormattedCharSequence>)Pair.of((Object)false, (Object)Component.m_237113_((String)" ").m_7532_()));
            }
            return resized;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Style component = this.findTextLine((int)mouseX, (int)mouseY);
            if (component != null) {
                FirstLaunchScreen.this.m_5561_(component);
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Nullable
        private Style findTextLine(int mouseX, int mouseY) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return null;
            }
            double offset = (float)(mouseY - this.top + this.border) + this.scrollDistance + 1.0f;
            if (offset <= 0.0) {
                return null;
            }
            Objects.requireNonNull(FirstLaunchScreen.this.f_96547_);
            int lineIdx = (int)(offset / 9.0);
            if (lineIdx >= this.lines.size() || lineIdx < 1) {
                return null;
            }
            FormattedCharSequence line = (FormattedCharSequence)this.lines.get(lineIdx - 1).getRight();
            if (line != null) {
                return FirstLaunchScreen.this.f_96547_.m_92865_().m_92338_(line, mouseX - this.left - this.border);
            }
            return null;
        }
    }
}

