/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class WarningPreferences {
    private static final String warningPrefsFileStr = "config/itlt/warning.properties";
    private static final File warningPrefsFile = new File("config/itlt/warning.properties");
    private final Properties properties = new Properties();

    public WarningPreferences() {
        if (!warningPrefsFile.exists()) {
            try {
                System.out.println(warningPrefsFile);
                if (!warningPrefsFile.createNewFile()) {
                    System.err.println("Error: Unable to create warning.properties for storing warning preferences.");
                }
            }
            catch (IOException e) {
                System.err.println("Error: Unable to create warning.properties for storing warning preferences.");
                e.printStackTrace();
            }
        }
    }

    public void load() {
        block2: {
            try {
                FileInputStream input = new FileInputStream(warningPrefsFileStr);
                this.properties.load(input);
            }
            catch (IOException e) {
                File warningPropertiesFile = new File(warningPrefsFileStr);
                if (!warningPropertiesFile.exists() || warningPropertiesFile.isDirectory()) break block2;
                System.err.println("Error: Warning preferences file found but can't be read, deleting...");
                if (warningPropertiesFile.delete()) break block2;
                warningPropertiesFile.deleteOnExit();
            }
        }
    }

    public void save() {
        try {
            FileOutputStream output = new FileOutputStream(warningPrefsFile);
            this.properties.store(output, null);
        }
        catch (IOException e) {
            System.err.println("Error: Unable to write warning preferences to file.");
            e.printStackTrace();
        }
    }

    public boolean getBoolInt(String keyName) {
        return this.properties.getProperty(keyName, "0").equals("1");
    }

    public boolean getBoolInt(String keyName, boolean defaultValue) {
        return this.properties.getProperty(keyName, WarningPreferences.convertBoolToString(defaultValue)).equals("1");
    }

    public void setBoolInt(String keyName, boolean keyBoolValue) {
        this.properties.setProperty(keyName, WarningPreferences.convertBoolToString(keyBoolValue));
    }

    private static String convertBoolToString(boolean bool) {
        if (bool) {
            return "1";
        }
        return "0";
    }
}

