/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client.helpers;

import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import dk.zlepper.itlt.client.ClientConfig;
import dk.zlepper.itlt.itlt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.ForgeConfigSpec;

public class Migration {
    private static HashMap<String, Field> configFields;

    private static void migrateSameFormat(UnmodifiableCommentedConfig oldConfig, Set<String> blacklist) {
        if (configFields == null) {
            configFields = new HashMap(ClientConfig.class.getDeclaredFields().length);
            for (Field declaredField : ClientConfig.class.getDeclaredFields()) {
                if (!declaredField.getType().toString().contains("ForgeConfigSpec") || declaredField.getName().equals("clientConfig")) continue;
                configFields.put(declaredField.getName(), declaredField);
            }
        }
        for (Map.Entry entry : oldConfig.valueMap().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof UnmodifiableCommentedConfig) {
                UnmodifiableCommentedConfig valueAsMap = (UnmodifiableCommentedConfig)value;
                Migration.migrateSameFormat(valueAsMap, blacklist);
            }
            if (blacklist.contains(key) || !configFields.containsKey(key)) continue;
            try {
                Field field = ClientConfig.class.getDeclaredField(key);
                if (field.getType().equals(ForgeConfigSpec.BooleanValue.class)) {
                    ((ForgeConfigSpec.BooleanValue)field.get(Object.class)).set((Object)((Boolean)value));
                    continue;
                }
                if (field.getType().equals(ForgeConfigSpec.DoubleValue.class)) {
                    ((ForgeConfigSpec.DoubleValue)field.get(Object.class)).set((Object)((Double)value));
                    continue;
                }
                if (field.getType().equals(ForgeConfigSpec.IntValue.class)) {
                    ((ForgeConfigSpec.IntValue)field.get(Object.class)).set((Object)((Integer)value));
                    continue;
                }
                if (field.getGenericType().getTypeName().equals("net.minecraftforge.common.ForgeConfigSpec$ConfigValue<java.lang.String>")) {
                    ((ForgeConfigSpec.ConfigValue)field.get(Object.class)).set((Object)((String)value));
                    continue;
                }
                itlt.LOGGER.debug("Skipping unknown/unsupported variable type \"" + field.getGenericType().getTypeName() + "\" encountered during migration");
            }
            catch (Exception e) {
                itlt.LOGGER.info(String.format("Unable to migrate \"%s\" with value \"%s\" to v%s", key, value, "2.2.1"));
                itlt.LOGGER.debug((Object)e);
                itlt.LOGGER.debug((Object)e.getStackTrace());
            }
        }
    }

    public static void migrate(String from, String to, UnmodifiableCommentedConfig oldConfig) {
        switch (from) {
            case "2.2.1": 
            case "2.2.0": {
                Migration.migrateSameFormat(oldConfig, Set.of());
                ClientConfig.configVersion.set((Object)"2.2.1");
                break;
            }
            case "2.1.5": 
            case "2.1.4": 
            case "2.1.3": 
            case "2.1.2": 
            case "2.1.1": 
            case "2.1.0": {
                String modpackName = (String)oldConfig.get("Display.WindowTitle.autoDetectedDisplayNameFallback");
                if (modpackName.equals("ModpackName")) {
                    modpackName = "";
                }
                ClientConfig.modpackName.set((Object)modpackName);
                boolean enableUsingCustomWelcomeHeaderModpackDisplayName = (Boolean)oldConfig.get("Display.WelcomeScreen.enableUsingCustomWelcomeHeaderModpackDisplayName");
                String customWelcomeHeaderModpackDisplayName = (String)oldConfig.get("Display.WelcomeScreen.customWelcomeHeaderModpackDisplayName");
                if (enableUsingCustomWelcomeHeaderModpackDisplayName) {
                    if (customWelcomeHeaderModpackDisplayName.equals("ModpackName")) {
                        customWelcomeHeaderModpackDisplayName = "";
                    }
                } else {
                    customWelcomeHeaderModpackDisplayName = "";
                }
                ClientConfig.customWelcomeHeaderModpackDisplayName.set((Object)customWelcomeHeaderModpackDisplayName);
                String customWindowTitleText = (String)oldConfig.get("Display.WindowTitle.customWindowTitleText");
                customWindowTitleText = customWindowTitleText.replace("%autoName", "%modpackName");
                ClientConfig.customWindowTitleText.set((Object)customWindowTitleText);
                break;
            }
            case "2.0.1": 
            case "2.0.0": {
                ClientConfig.enableCustomWindowTitle.set((Object)((Boolean)oldConfig.get("Java.Display.WindowTitle.enableCustomWindowTitle")));
                ClientConfig.customWindowTitleText.set((Object)((String)oldConfig.get("Java.Display.WindowTitle.customWindowTitleText")));
                String modpackName = (String)oldConfig.get("Java.Display.WindowTitle.autoDetectedDisplayNameFallback");
                if (modpackName.equals("ModpackName")) {
                    modpackName = "";
                }
                ClientConfig.modpackName.set((Object)modpackName);
                ClientConfig.enableEnhancedVanillaIcon.set((Object)((Boolean)oldConfig.get("Java.Display.Icon.enableEnhancedVanillaIcon")));
                ClientConfig.enableCustomIcon.set((Object)((Boolean)oldConfig.get("Java.Display.Icon.enableCustomIcon")));
                ClientConfig.enableUsingAutodetectedIcon.set((Object)((Boolean)oldConfig.get("Java.Display.Icon.enableUsingAutodetectedIcon")));
                ClientConfig.enableCustomServerListEntries.set((Object)((Boolean)oldConfig.get("Java.ServerList.enableCustomServerListEntries")));
                ArrayList<String> triggersList = new ArrayList<String>(3);
                if (((Boolean)oldConfig.get("Java.Advanced.ExplicitGC.explicitGCOnPause")).booleanValue()) {
                    triggersList.add(ClientConfig.explicitGCTriggers.Pause.toString());
                }
                if (((Boolean)oldConfig.get("Java.Advanced.ExplicitGC.explicitGCOnSleep")).booleanValue()) {
                    triggersList.add(ClientConfig.explicitGCTriggers.Sleep.toString());
                }
                if (((Boolean)oldConfig.get("Java.Advanced.ExplicitGC.explicitGCOnMenu")).booleanValue()) {
                    triggersList.add(ClientConfig.explicitGCTriggers.Menu.toString());
                }
                ClientConfig.doExplicitGCWhen.set(triggersList);
                ClientConfig.requiredMaxJavaVersion.set((Object)((Integer)oldConfig.get("Java.Version.Max.Requirement.requiredMaxJavaVerion")));
                ClientConfig.requiredMinJavaVersion.set((Object)((Integer)oldConfig.get("Java.Version.Min.Requirement.requiredMinJavaVerion")));
                HashSet<String> ignoreList = new HashSet<String>(List.of("enableCustomWindowTitle", "customWindowTitleText", "enableUsingAutodetectedDisplayName", "autoDetectedDisplayNameFallback", "enableEnhancedVanillaIcon", "enableCustomIcon", "enableUsingAutodetectedIcon", "enableCustomServerListEntries", "configVersion"));
                Migration.migrateSameFormat(oldConfig, ignoreList);
                ClientConfig.configVersion.set((Object)"2.2.1");
                break;
            }
            case "1.0.3": {
                from = (String)from + " (auto-detected)";
                ClientConfig.enableUsingAutodetectedIcon.set((Object)((Boolean)oldConfig.get("Display.useTechnicIcon")));
                ClientConfig.enableCustomIcon.set((Object)((Boolean)oldConfig.get("Display.loadCustomIcon")));
                ClientConfig.enableCustomWindowTitle.set((Object)((Boolean)oldConfig.get("Display.useTechnicDisplayName")));
                boolean addDedicatedServer = (Boolean)oldConfig.get("Server.AddDedicatedServer");
                if (addDedicatedServer) {
                    ClientConfig.enableCustomServerListEntries.set((Object)true);
                    itlt.LOGGER.warn(String.format("Unable to migrate SERVER_SERVER_NAME option from v%s to v%s", from, to));
                    itlt.LOGGER.warn(String.format("Unable to migrate SERVER_SERVER_IP option from v%s to v%s", from, to));
                }
                ClientConfig.configVersion.set((Object)"2.2.1");
                break;
            }
            default: {
                itlt.LOGGER.error(String.format("Migration failed: Unknown config version \"v%s\"", from));
            }
        }
    }
}

