/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client.helpers;

import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import dk.zlepper.itlt.client.ClientConfig;
import dk.zlepper.itlt.itlt;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigUtils {
    public static final Path configDir = FMLPaths.CONFIGDIR.get();

    public static UnmodifiableCommentedConfig readToml(File tomlFile) throws IOException {
        return new TomlParser().parse((Reader)new FileReader(tomlFile.getPath(), StandardCharsets.UTF_8)).unmodifiable();
    }

    public static void writeToml(UnmodifiableCommentedConfig config, File tomlFile) throws IOException {
        new TomlWriter().write((UnmodifiableConfig)config, (Writer)new FileWriter(tomlFile.getPath(), StandardCharsets.UTF_8));
    }

    public static String getConfigVersion(File tomlFile) throws IOException {
        return ConfigUtils.getConfigVersion(ConfigUtils.readToml(tomlFile));
    }

    public static String getConfigVersion(UnmodifiableCommentedConfig config) {
        Map configMap = config.valueMap();
        String configVer = "Unknown";
        try {
            configVer = ((UnmodifiableCommentedConfig)configMap.get("Internal")).valueMap().get("configVersion").toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Map javaSection = ((UnmodifiableCommentedConfig)configMap.get("Java")).valueMap();
            configVer = ((UnmodifiableCommentedConfig)javaSection.get("Internal")).valueMap().get("configVersion").toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configVer.equals("unset") ? "Unknown" : configVer;
    }

    public static void backup() {
        Path currentConfigPath = configDir.resolve("itlt-client.toml");
        Path backupConfigPath = configDir.resolve("itlt-client.toml.bak");
        itlt.LOGGER.info("Backing up itlt config just in case...");
        if (currentConfigPath.toFile().exists() && !currentConfigPath.toFile().isDirectory()) {
            try {
                Files.copy(currentConfigPath, backupConfigPath, StandardCopyOption.REPLACE_EXISTING);
                itlt.LOGGER.info("itlt config backup completed successfully");
            }
            catch (IOException e) {
                itlt.LOGGER.warn("Failed to make a backup of itlt-client.toml");
                e.printStackTrace();
            }
        }
    }

    public static void delete(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            try {
                path.toFile().deleteOnExit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static File makeItltFolderIfNeeded() {
        File itltDir = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "itlt").toFile();
        if (!itltDir.exists() && (((Boolean)ClientConfig.enableCustomIcon.get()).booleanValue() || ((Boolean)ClientConfig.enableEnhancedVanillaIcon.get()).booleanValue() || ClientConfig.areAnyWarningsEnabled() || ((Boolean)ClientConfig.enableCustomServerListEntries.get()).booleanValue() || ((Boolean)ClientConfig.enableWelcomeScreen.get()).booleanValue()) && !itltDir.mkdir()) {
            itlt.LOGGER.warn("Unable to make an \"itlt\" folder inside the config folder. Please make it manually.");
            return null;
        }
        return itltDir;
    }
}

