/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client.helpers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import dk.zlepper.itlt.client.ClientConfig;
import dk.zlepper.itlt.client.ClientModEvents;
import dk.zlepper.itlt.client.helpers.Message;
import dk.zlepper.itlt.itlt;
import dk.zlepper.itlt.shadow.org.apache.commons.imaging.ImageReadException;
import dk.zlepper.itlt.shadow.org.apache.commons.imaging.formats.icns.IcnsImageParser;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraftforge.fml.ModList;
import net.sf.image4j.codec.ico.ICODecoder;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ClientUtils {
    public static String getAutoDetectedDisplayName() {
        String modpackName = (String)ClientConfig.modpackName.get();
        if (modpackName.isEmpty()) {
            try {
                String tmp = ClientModEvents.detectedLauncher.getModpackDisplayName();
                if (tmp != null && !tmp.isBlank()) {
                    modpackName = tmp;
                }
            }
            catch (IOException e) {
                itlt.LOGGER.warn("Unable to auto-detect modpack display name, please set one in the itlt-client.toml config file.");
                e.printStackTrace();
            }
        }
        return modpackName;
    }

    public static byte getJavaVersion() {
        String javaVerStr = System.getProperty("java.version");
        String[] splitJavaVer = javaVerStr.split(Pattern.quote("."));
        byte javaVer = Byte.parseByte(splitJavaVer[0]);
        if (javaVer == 1) {
            javaVer = Byte.parseByte(splitJavaVer[1]);
        }
        return javaVer;
    }

    public static boolean alreadyInServerList(ServerData server, ServerList list) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.m_105445_(); ++i) {
            ServerData serverData = list.m_105432_(i);
            if (!serverData.f_105362_.equalsIgnoreCase(server.f_105362_) || !serverData.f_105363_.equalsIgnoreCase(server.f_105363_)) continue;
            return true;
        }
        return false;
    }

    public static String getCustomWindowTitle(Minecraft mcInstance) {
        if (ClientConfig.enableCustomWindowTitle == null) {
            return "Minecraft* " + SharedConstants.m_183709_().m_132493_();
        }
        if (!((Boolean)ClientConfig.enableCustomWindowTitle.get()).booleanValue()) {
            return mcInstance.m_91270_();
        }
        String customWindowTitle = (String)ClientConfig.customWindowTitleText.get();
        String autoDetectedDisplayName = ClientUtils.getAutoDetectedDisplayName();
        customWindowTitle = customWindowTitle.replaceFirst("%autoName", autoDetectedDisplayName);
        customWindowTitle = customWindowTitle.replaceFirst("%modpackName", autoDetectedDisplayName);
        if ((customWindowTitle = customWindowTitle.replaceFirst("%mc", mcInstance.m_91270_())).isEmpty() || autoDetectedDisplayName.isEmpty()) {
            return mcInstance.m_91270_();
        }
        return customWindowTitle;
    }

    public static void setWindowIcon(InputStream inputIconInStream, Minecraft mcInstance, File itltDir, String fileExtension) throws IOException {
        Files.copy(inputIconInStream, Paths.get(itltDir.getAbsolutePath(), "temp." + fileExtension), StandardCopyOption.REPLACE_EXISTING);
        File tmpIconFile = new File(itltDir.getAbsolutePath(), "temp." + fileExtension);
        ClientUtils.setWindowIcon(tmpIconFile, mcInstance);
        if (!tmpIconFile.delete()) {
            tmpIconFile.deleteOnExit();
        }
    }

    public static void setWindowIcon(File inputIconFile, Minecraft mcInstance) throws IOException {
        ArrayList<InputStream> iconsList = new ArrayList<InputStream>();
        List<Object> bufferedImageList = new ArrayList(0);
        String inputIconFilenameAndExt = inputIconFile.getName().toLowerCase();
        if (inputIconFilenameAndExt.endsWith(".ico")) {
            bufferedImageList = ICODecoder.read(inputIconFile);
        } else if (inputIconFilenameAndExt.endsWith(".icns")) {
            try {
                bufferedImageList = new IcnsImageParser().getAllBufferedImages(inputIconFile);
            }
            catch (ImageReadException e) {
                e.printStackTrace();
                return;
            }
        } else if (inputIconFilenameAndExt.endsWith(".png")) {
            iconsList.add(new FileInputStream(inputIconFile));
        }
        itlt.LOGGER.debug("Icon file: \"" + inputIconFilenameAndExt + "\"");
        if (inputIconFilenameAndExt.endsWith(".ico") || inputIconFilenameAndExt.endsWith(".icns")) {
            for (BufferedImage bufferedImage : bufferedImageList) {
                itlt.LOGGER.debug("---");
                itlt.LOGGER.debug("Type: " + bufferedImage.getType());
                itlt.LOGGER.debug("Width: " + bufferedImage.getWidth());
                itlt.LOGGER.debug("Height: " + bufferedImage.getHeight());
                itlt.LOGGER.debug("Transparency: " + bufferedImage.getTransparency());
                if (bufferedImage.getType() == 2) {
                    if (inputIconFilenameAndExt.endsWith(".icns")) {
                        if (bufferedImage.getWidth() <= 48) {
                            iconsList.add(ClientUtils.convertToInputStream(bufferedImage));
                            itlt.LOGGER.debug("Added embedded image");
                            continue;
                        }
                        itlt.LOGGER.debug("Skipped embedded image");
                        continue;
                    }
                    iconsList.add(ClientUtils.convertToInputStream(bufferedImage));
                    itlt.LOGGER.debug("Added embedded image");
                    continue;
                }
                itlt.LOGGER.debug("Skipped embedded image");
            }
        }
        itlt.LOGGER.debug("Final iconsList size: " + iconsList.size());
        GLFWImage.Buffer buffer = ClientUtils.loadIconsIntoBuffer(iconsList, mcInstance);
        GLFW.glfwSetWindowIcon((long)mcInstance.m_91268_().f_85349_, (GLFWImage.Buffer)buffer);
    }

    public static GLFWImage.Buffer loadIconsIntoBuffer(List<InputStream> iconsList, Minecraft mcInstance) throws IOException {
        return ClientUtils.loadIconsIntoBuffer(iconsList, mcInstance, 1);
    }

    public static GLFWImage.Buffer loadIconsIntoBuffer(List<InputStream> iconsList, Minecraft mcInstance, int attempt) throws IOException {
        MemoryStack memoryStack = MemoryStack.stackPush();
        GLFWImage.Buffer buffer = GLFWImage.malloc((int)iconsList.size(), (MemoryStack)memoryStack);
        IntBuffer intBufferX = memoryStack.mallocInt(1);
        IntBuffer intBufferY = memoryStack.mallocInt(1);
        IntBuffer intBufferChannels = memoryStack.mallocInt(1);
        short iconCounter = 0;
        int errorCounter = 0;
        ArrayList<InputStream> newIconsList = new ArrayList<InputStream>();
        for (InputStream inStream : iconsList) {
            ByteBuffer byteBuffer;
            try {
                byteBuffer = ClientUtils.readIconPixels(inStream, intBufferX, intBufferY, intBufferChannels);
                if (byteBuffer == null) {
                    throw new IOException("byteBuffer is null");
                }
            }
            catch (IOException e) {
                itlt.LOGGER.debug("Unable to load image #" + iconCounter + " inside iconsList, skipping...");
                errorCounter = (short)(errorCounter + 1);
                continue;
            }
            buffer.position((int)iconCounter);
            buffer.width(intBufferX.get(0));
            buffer.height(intBufferY.get(0));
            buffer.pixels(byteBuffer);
            iconCounter = (short)(iconCounter + 1);
            newIconsList.add(inStream);
        }
        if (errorCounter == iconsList.size()) {
            throw new IOException("Unable to load icon(s): Failed to load all embedded images");
        }
        if (errorCounter > 0) {
            if (attempt > 2) {
                throw new IOException("Unable to load icon(s): Too many failed attempts");
            }
            return ClientUtils.loadIconsIntoBuffer(newIconsList, mcInstance, attempt + 1);
        }
        buffer.position(0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer readIconPixels(InputStream pTextureStream, IntBuffer pX, IntBuffer pY, IntBuffer pChannelInFile) throws IOException {
        ByteBuffer bytebuffer1;
        RenderSystem.assertInInitPhase();
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource((InputStream)pTextureStream);
            bytebuffer.rewind();
            bytebuffer1 = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)pX, (IntBuffer)pY, (IntBuffer)pChannelInFile, (int)0);
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return bytebuffer1;
    }

    public static ByteArrayInputStream convertToInputStream(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        ImageIO.write((RenderedImage)bufferedImage, "png", output);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(output.toByteArray(), 0, output.size());
        bufferedImage.flush();
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startUIProcess(Message.Content messageContent) {
        Type type;
        InputStreamReader embeddedLangJson;
        HashMap translationsMap;
        Object rightButtonText;
        Object middleButtonText;
        Path modFile = ModList.get().getModFileById("itlt").getFile().getFilePath();
        String msgTranslationKeyTemplate = "itlt." + (messageContent.msgType.name() + "." + messageContent.msgDesire.name() + "." + messageContent.msgSubject.name()).toLowerCase();
        Object messageTitle = msgTranslationKeyTemplate + ".title";
        Object messageBody = msgTranslationKeyTemplate + ".body";
        String messageGuideError = "itlt.cantOpenGuideErrorMsg";
        Object leftButtonText = msgTranslationKeyTemplate + ".guideButtonText";
        if (messageContent.msgType == Message.Type.Needs) {
            middleButtonText = msgTranslationKeyTemplate + ".closeButtonText";
            rightButtonText = ".";
        } else {
            middleButtonText = msgTranslationKeyTemplate + ".askLaterButtonText";
            rightButtonText = msgTranslationKeyTemplate + ".dontAskAgainButtonText";
        }
        String defaultGuideURL = "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
        String guideURL = switch (messageContent.msgSubject) {
            default -> throw new IncompatibleClassChangeError();
            case Message.Subject.Memory -> {
                if (((Boolean)ClientConfig.enableCustomMemoryAllocGuide.get()).booleanValue()) {
                    yield (String)ClientConfig.customMemoryAllocGuideURL.get();
                }
                yield "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
            }
            case Message.Subject.Java -> {
                if (messageContent.msgDesire == Message.Desire.SixtyFourBit) {
                    if (((Boolean)ClientConfig.enableCustom64bitJavaGuide.get()).booleanValue()) {
                        yield (String)ClientConfig.custom64bitJavaGuideURL.get();
                    }
                    yield "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
                }
                if (messageContent.msgDesire == Message.Desire.Newer) {
                    if (((Boolean)ClientConfig.enableCustomJavaUpgradeGuide.get()).booleanValue()) {
                        yield (String)ClientConfig.customJavaUpgradeGuideURL.get();
                    }
                    yield "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
                }
                yield (Boolean)ClientConfig.enableCustomJavaDowngradeGuide.get() != false ? (String)ClientConfig.customJavaDowngradeGuideURL.get() : "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
            }
        };
        guideURL = guideURL.replaceAll("%launcher", ClientModEvents.detectedLauncher.getName()).replaceAll("%reason", messageContent.toString()).replaceAll("%type", messageContent.msgType.toString()).replaceAll("%desire", messageContent.msgDesire.toString()).replaceAll("%subject", messageContent.msgSubject.toString());
        String lang = Minecraft.m_91087_().f_91066_.f_92075_;
        InputStream embeddedLangJsonInStream = itlt.class.getClassLoader().getResourceAsStream("assets/itlt/lang/" + lang + ".json");
        if (embeddedLangJsonInStream == null) {
            embeddedLangJsonInStream = itlt.class.getClassLoader().getResourceAsStream("assets/itlt/lang/en_us.json");
        }
        if ((translationsMap = (HashMap)new Gson().fromJson((Reader)(embeddedLangJson = new InputStreamReader(embeddedLangJsonInStream, StandardCharsets.UTF_8)), type = new TypeToken<HashMap<String, String>>(){}.getType())) != null) {
            messageTitle = (String)((Object)translationsMap.getOrDefault(messageTitle, messageTitle));
            messageBody = (String)((Object)translationsMap.getOrDefault(messageBody, messageBody));
            leftButtonText = (String)((Object)translationsMap.getOrDefault(leftButtonText, leftButtonText));
            middleButtonText = (String)((Object)translationsMap.getOrDefault(middleButtonText, middleButtonText));
            rightButtonText = (String)translationsMap.getOrDefault(rightButtonText, rightButtonText);
            messageGuideError = translationsMap.getOrDefault(messageGuideError, messageGuideError);
            if (messageContent.msgSubject == Message.Subject.Memory) {
                messageBody = ((String)messageBody).replaceFirst("%sb", ClientConfig.getSimplifiedFloatStr(ClientModEvents.currentMem));
            } else if (messageContent.msgSubject == Message.Subject.Java) {
                messageBody = ((String)messageBody).replaceFirst("%sb", String.valueOf(ClientUtils.getJavaVersion()));
            }
            messageBody = switch (messageContent) {
                case Message.Content.NeedsMoreMemory -> ((String)messageBody).replaceFirst("%s", ClientConfig.getSimplifiedFloatStr(((Double)ClientConfig.reqMinMemoryAmountInGB.get()).floatValue()));
                case Message.Content.WantsMoreMemory -> ((String)messageBody).replaceFirst("%s", ClientConfig.getSimplifiedFloatStr(((Double)ClientConfig.warnMinMemoryAmountInGB.get()).floatValue()));
                case Message.Content.NeedsLessMemory -> ((String)messageBody).replaceFirst("%s", ClientConfig.getSimplifiedFloatStr(((Double)ClientConfig.reqMaxMemoryAmountInGB.get()).floatValue()));
                case Message.Content.WantsLessMemory -> ((String)messageBody).replaceFirst("%s", ClientConfig.getSimplifiedFloatStr(((Double)ClientConfig.warnMaxMemoryAmountInGB.get()).floatValue()));
                case Message.Content.NeedsNewerJava -> {
                    messageTitle = ((String)messageTitle).replaceFirst("%s", ((Integer)ClientConfig.requiredMinJavaVersion.get()).toString());
                    yield ((String)messageBody).replaceFirst("%s", ((Integer)ClientConfig.requiredMinJavaVersion.get()).toString());
                }
                case Message.Content.WantsNewerJava -> {
                    messageTitle = ((String)messageTitle).replaceFirst("%s", ((Integer)ClientConfig.warnMinJavaVersion.get()).toString());
                    yield ((String)messageBody).replaceFirst("%s", ((Integer)ClientConfig.warnMinJavaVersion.get()).toString());
                }
                case Message.Content.NeedsOlderJava -> {
                    messageTitle = ((String)messageTitle).replaceFirst("%s", ((Integer)ClientConfig.requiredMaxJavaVersion.get()).toString());
                    yield ((String)messageBody).replaceFirst("%s", ((Integer)ClientConfig.requiredMaxJavaVersion.get()).toString());
                }
                case Message.Content.WantsOlderJava -> {
                    messageTitle = ((String)messageTitle).replaceFirst("%s", ((Integer)ClientConfig.warnMaxJavaVersion.get()).toString());
                    yield ((String)messageBody).replaceFirst("%s", ((Integer)ClientConfig.warnMaxJavaVersion.get()).toString());
                }
                default -> messageBody;
            };
        }
        messageGuideError = messageGuideError.replaceFirst("%s", guideURL);
        itlt.LOGGER.info("messageContent: " + messageContent.toString());
        itlt.LOGGER.debug("messageType: " + messageContent.msgType.toString());
        itlt.LOGGER.info("messageTitle: " + (String)messageTitle);
        itlt.LOGGER.info("messageBody: " + (String)messageBody);
        itlt.LOGGER.info("guideURL: " + guideURL);
        itlt.LOGGER.debug("messageGuideError: " + messageGuideError);
        itlt.LOGGER.debug("left: " + (String)leftButtonText);
        itlt.LOGGER.debug("middle: " + (String)middleButtonText);
        itlt.LOGGER.debug("right: " + (String)rightButtonText);
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[]{System.getProperty("java.home") + File.separator + "bin" + File.separator + "java", "-Dapple.awt.application.appearance=system", "-XX:+IgnoreUnrecognizedVMOptions", "--add-opens=java.desktop/sun.awt.shell=ALL-UNNAMED", "-jar", modFile.toString(), messageContent.msgType.toString().toLowerCase(), messageTitle, messageBody, leftButtonText, middleButtonText, rightButtonText, messageGuideError, guideURL, messageContent.toString()});
            builder.inheritIO();
            builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (messageContent.msgType == Message.Type.Needs) {
                itlt.LOGGER.fatal("Can't launch the game as a requirement isn't met. ");
                itlt.LOGGER.fatal("The unmet requirement is: \"" + messageContent + "\".");
                if (((String)messageBody).isEmpty()) {
                    itlt.LOGGER.error("The requirement details are blank, please report this bug on itlt's GitHub issues");
                } else {
                    itlt.LOGGER.error("Requirement details: " + (String)messageBody);
                }
                System.exit(1);
            }
        }
    }

    public static class CustomServerData {
        public String name;
        public String address;
        public boolean forceResourcePack;
    }
}

