/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client;

import com.mojang.realmsclient.RealmsMainScreen;
import dk.zlepper.itlt.client.ClientConfig;
import dk.zlepper.itlt.client.ClientModEvents;
import dk.zlepper.itlt.client.helpers.ClientUtils;
import dk.zlepper.itlt.client.screens.FirstLaunchScreen;
import dk.zlepper.itlt.itlt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.minecraft.client.gui.screens.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.ChatOptionsScreen;
import net.minecraft.client.gui.screens.DirectJoinServerScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="itlt", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientForgeEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onGuiOpen(ScreenEvent.Opening event) {
        Screen screen = event.getNewScreen();
        if (screen == null || ClientConfig.enableExplicitGC == null) {
            return;
        }
        if (((Boolean)ClientConfig.enableExplicitGC.get()).booleanValue()) {
            itlt.LOGGER.debug("Screen: " + screen);
            ((List)ClientConfig.doExplicitGCWhen.get()).forEach(trigger -> {
                switch (ClientConfig.explicitGCTriggers.valueOf(trigger)) {
                    case Pause: {
                        if (!screen.m_7043_()) break;
                        Runtime.getRuntime().gc();
                        break;
                    }
                    case Sleep: {
                        if (!(screen instanceof InBedChatScreen)) break;
                        Runtime.getRuntime().gc();
                        break;
                    }
                    case Menu: {
                        if (!(screen instanceof SelectWorldScreen) && !(screen instanceof JoinMultiplayerScreen) && !(screen instanceof DirectJoinServerScreen) && !(screen instanceof PackSelectionScreen) && !(screen instanceof LanguageSelectScreen) && !(screen instanceof ChatOptionsScreen) && !(screen instanceof ControlsScreen) && !(screen instanceof AccessibilityOptionsScreen) && !(screen instanceof RealmsMainScreen) && !(screen instanceof StatsScreen)) break;
                        Runtime.getRuntime().gc();
                    }
                }
            });
        }
        if (((Boolean)ClientConfig.enableWelcomeScreen.get()).booleanValue() && screen instanceof TitleScreen) {
            String customWelcomeHeaderModpackDisplayName;
            if (ClientModEvents.itltDir == null) {
                itlt.LOGGER.warn("itlt folder in the config folder is missing");
                itlt.LOGGER.warn("Please create a folder named \"itlt\" (case sensitive) in the config folder.");
                return;
            }
            Path welcomeFilePath = ClientModEvents.itltDir.toPath().resolve("welcome.txt");
            if (!welcomeFilePath.toFile().exists()) {
                Path embeddedWelcomeFile = ModList.get().getModFileById("itlt").getFile().findResource(new String[]{"welcome.txt"});
                try {
                    Files.copy(embeddedWelcomeFile, welcomeFilePath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String welcomeHeaderModpackDisplayName = (customWelcomeHeaderModpackDisplayName = (String)ClientConfig.customWelcomeHeaderModpackDisplayName.get()).isEmpty() ? ClientUtils.getAutoDetectedDisplayName() : customWelcomeHeaderModpackDisplayName;
            event.setNewScreen((Screen)new FirstLaunchScreen((Screen)new TitleScreen(), (Component)Component.m_237110_((String)"itlt.welcomeScreen.title", (Object[])new Object[]{welcomeHeaderModpackDisplayName})));
        }
    }
}

